/* AVGFSIZE.H - Average file size of all files on a volume.   Revision 1.04
   Written 17 July 1996 by Robert B. Clark <rclark@iquest.net>
   Turbo C v3.0 code.  Donated to the public domain.
   ------------------------------------------------------------------------
   HISTORY:
   --------
   Rev 1.00 17 Jul 96   Internal release.

   Rev 1.01 18 Jul 96   Internal release.  Added internationalization
                        niceties, std dev calculations, improved filename
                        display so that it prints the path only when it
                        changes; otherwise just displays the filename.

   Rev 1.02 19 Jul 96   Internal release.  Divide by zero errors if disk
                        had no files or directories; fixed.  Added check
                        for drive existance before process_dir() call.

   Rev 1.03 20 Jul 96   Internal release. Changed disp_block_table() so
                        that it indicates the A.U. size in use on the drive
                        (displays star next to line). Documentation and
                        comment changes.  Fixed wrong date in vanity
                        copyleft line.  Fixed filename display so that a
                        full 12 characters (right-padded with spaces) are
                        printed.  Added prototypes to header file.

   Rev 1.04 25 Jul 96   FIRST RELEASE.  Divide by zero error if only one
                        file (std dev); fixed.  Now does not display file
                        names if stdout or stdin is redirected.  Added new
                        column that shows the amount of wasted space on the
                        drive given the average file size and slack space
                        per file.

                        Compile cmd: tcc -G -O -d -a avgfsize.c mylib.lib
                        Compiled size: 30,370 bytes.
   ------------------------------------------------------------------------
*/
#ifndef __AVGFSIZE_H
#define __AVGFSIZE_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>        /* Sundry string functions */
#include <dir.h>           /* getdisk() */
#include <ctype.h>         /* toupper() */
#include <math.h>          /* floor(), sqrt() */
#include <conio.h>         /* clreol() */
#include <errno.h>         /* For error definitions */
#include "strutils.h"      /* uExpand(), iDecimal() */
#include "plurals.h"       /* Pluralize noun macros */
/* --------------------------------------------------------------------- */
/* Defines */

#undef PROGNAME
#undef VERSION

#define PROGNAME           "AVGFSIZE"
#define VERSION            "1.04"

#define ANYFILE            FA_RDONLY + FA_HIDDEN + FA_SYSTEM + \
                           FA_DIREC + FA_ARCH
/* --------------------------------------------------------------------- */
/* Globals */

unsigned long dir_cnt, file_cnt, file_size_tot, sum_sq;
int conio_redirected;

/* --------------------------------------------------------------------- */
/* Prototypes */

int   isredirected(void);
int   drvexists(char drv);
int   process_dir(const char * pathspec);
void  disp_block_table(unsigned long avgsize, unsigned int au_size);
int   get_dir_stats(char drv);

/* --------------------------------------------------------------------- */
/* Useful macros */

#define LAST_CHAR(A)    (A)[strlen((A))-1]

#endif   /* __AVGFSIZE_H */
