
if 01

        model   flat,stdcall

macro   startcode
        codeseg
endm    startcode
macro   endcode
        align   dword   ;pad it with nops instead of 0's
        ends
endm    endcode
macro   startdata
        dataseg
endm    startdata
macro   enddata
        ends
endm    enddata
macro   startbss
        udataseg
endm    startbss
macro   endbss
        ends
endm    endbss
macro   startconst
        const
endm    startconst
macro   endconst
        ends
endm    endconst

@codesize       equ     0
@datasize       equ     0

procptr         equ     near
_es             equ     ds

else

        nowarn  res ;don't warn if we use a reserved word (stack,codeptr,etc)

@codesize       equ     0               ;0=near code, 1=far code
@datasize       equ     0               ;0=near data, 1=far data

if @codesize
  procptr       equ     far
  codeptr       equ     fword
else
  procptr       equ     near
  codeptr       equ     dword
endif
if @datasize
  stackfar      equ     1
  _es           equ     es
  dataptr       equ     fword
else
  _es           equ     ds
  dataptr       equ     dword
endif

macro   startcode
  segment _text dword public 'code' use32
        assume  es:@data,cs:@code,ss:@stack,ds:@data,fs:nothing,gs:nothing
endm    startcode
macro   endcode
  ends  _text
endm    endcode
macro   startdata
  segment _data dword public 'data' use32
endm    startdata
macro   enddata
  ends  _data
endm    enddata
macro   startconst
  segment const dword public 'const' use32
endm    startconst
macro   endconst
  ends  const
endm    endconst
macro   startbss
  segment _bss dword public 'bss' use32
endm    endbss
macro   endbss
  ends  _bss
endm    endbss
macro   startstack
  segment stack para public 'stack' use32
endm    startstack
macro   endstack
  ends  stack
endm    endstack

ifdef stackfar
  group dgroup _data,const,_bss
else
  group dgroup _data,const,_bss,stack
endif

@code           equ     _text
@data           equ     dgroup
ifdef stackfar
% @stack        equ     stack
else
% @stack        equ     @data
endif

        startcode
        endcode
        startdata
        enddata
        startconst
        endconst
        startbss
        endbss
        startstack
        endstack

endif
