#include "ntui.h"
#include "progress.h"

typedef struct tagPROGRESS
{
  unsigned pos;   // 0 <= pos <= 100
  //
  // bar members
  //
  HDC      barDC;
  HBITMAP  barBMP;
  HBITMAP  oBarBMP;
  //
  // text members
  //
  HDC      textDC;
  HBITMAP  textBMP;
  HBITMAP  oTextBMP;
} PROGRESS;

const char *PROGRESS_NAME = "KYProgress";

/*
  return 0 on OK, (-1) if bad
*/
static LRESULT create(HWND hWnd, LPCREATESTRUCT cs)
{
  LRESULT res = 0;
  PROGRESS *p = malloc(sizeof(*p));
  if (p)
  {
    HDC dc = GetDC(hWnd);
    RECT cr;
    GetClientRect(hWnd, &cr);
    p->pos  = 0;
    
    p->barDC   = CreateCompatibleDC(dc);
    p->barBMP  = CreateBitmap(cr.right-cr.left+1, cr.bottom-cr.top+1, 1, 1, 0);
    p->oBarBMP = SelectObject(p->barDC, p->barBMP);

    p->textDC   = CreateCompatibleDC(dc);
    p->textBMP  = CreateBitmap(cr.right-cr.left+1, cr.bottom-cr.top+1, 1, 1, 0);
    p->oTextBMP = SelectObject(p->textDC, p->textBMP);

    SetWindowLong(hWnd, 0, (long) p);
    ReleaseDC(hWnd, dc);
  } else
    res = -1;
  return res;
}

static LRESULT destroy(PROGRESS *p, HWND hWnd)
{
  if (p)
  {
    SelectObject(p->textDC, p->oTextBMP);
    DeleteObject(p->textBMP);
    DeleteDC(p->textDC);

    SelectObject(p->barDC,  p->oBarBMP);
    DeleteObject(p->oBarBMP);
    DeleteDC(p->barDC);

    free(p);
    SetWindowLong(hWnd, 0, 0);
  }
  return 0;
}

static LRESULT paint(const PROGRESS *p, HWND hWnd, RECT *r)
{
  PAINTSTRUCT  ps;
  HBRUSH       black = GetStockObject(BLACK_BRUSH);
  HBRUSH       white = GetStockObject(WHITE_BRUSH);
  RECT         lr;
  RECT         rr; // left / right rectangles

  HDC          dc = BeginPaint(hWnd, &ps);
  /*
    first paint into the mem DC (black/white)
    then blast it out to the world!
  */
  GetClientRect(hWnd, &lr);
  rr = lr;
  {
    char buf[4];
    itoa(p->pos, buf, 10);
    FillRect(p->textDC, &lr, white);
    DrawText(p->textDC, buf, strlen(buf), &lr, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
  }
  lr.right = rr.left = (lr.right * p->pos / 100);

  FillRect(p->barDC, &lr, white);
  FillRect(p->barDC, &rr, black);

  BitBlt(p->barDC, 0, 0, rr.right, rr.bottom, p->textDC, 0, 0, SRCINVERT);
  {
    COLORREF fg = SetTextColor(dc, IsWindowEnabled(hWnd) ? RGB(0,0,0xff) : GetSysColor(COLOR_GRAYTEXT));
    BitBlt(dc, 0, 0, rr.right, rr.bottom, p->barDC, 0, 0, SRCCOPY);
    SetTextColor(dc, fg);
  }

  EndPaint(hWnd, &ps);
  return 0;
}

static LRESULT CALLBACK ctlFn(HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp)
{
  LRESULT res = 0;
  PROGRESS *p = (PROGRESS *) GetWindowLong(hWnd, 0);
  switch (uMsg)
  {
    case WM_CREATE:
      res = create(hWnd, (LPCREATESTRUCT) lp);
      break;
    case WM_DESTROY:
      res = destroy(p, hWnd);
      break;
    case WM_GETDLGCODE:
      res = DLGC_STATIC;
      break;
    case WM_ERASEBKGND:
      break;
    case WM_PAINT:
      {
        RECT rc;
        if (GetUpdateRect(hWnd, &rc, FALSE))
          res = paint(p, hWnd, &rc);
        else
          res = 0;
      }
      break;
    case WM_SIZE:
      return 0; // no resizing!

    case KYPM_SETPOS:
      if ((0 <= wp) && (wp <= 100))
      {
        p->pos = wp;
        res = TRUE;
        InvalidateRect(hWnd, 0, FALSE);
      } else
        res = FALSE;
      break;

    default:
      res = DefWindowProc(hWnd, uMsg, wp, lp);
  }
  return res;
}

ATOM progressRegister(void)
{
  WNDCLASS wc;
  ATOM     ret;

  wc.style = CS_GLOBALCLASS | CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc    = ctlFn;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 4; // pointer to local data!
  wc.hInstance     = 0;
  wc.hIcon         = 0;
  wc.hCursor       = LoadCursor(0, IDC_ARROW);
  wc.hbrBackground = 0;
  wc.lpszMenuName  = 0;
  wc.lpszClassName = PROGRESS_NAME;
  ret = RegisterClass(&wc);
  return ret;
}
