/******************************************************************************
* Module    :   Lexical Analyzer --- Extract tokens from the source file.
*
* Author    :   John W. M. Stevens
******************************************************************************/

#if ! defined(LEXICAL_ANALYZER)
#define     LEXICAL_ANALYZER

typedef enum    {
    T_NOT_FND,
    T_ALTERNATE,
    T_BODY,
    T_CASE,
    T_HEADER,
    T_ID,
    T_IGNORE,
    T_NUMBER,
    T_PART,
    T_SEGMENT,
    T_SEGMENTS,
    T_SENSITIVE,
    T_STRING,
    T_TOTAL,
    T_L_BRACE,
    T_R_BRACE,
    T_DBL_QUOTE,
    T_INT_NO
} TKNS;

/*  Token structure for returning values.   */
typedef struct  {
    char        str[256];
    int         no;
} TOKEN;

/*  Function prototypes.    */
extern
void    ParseErr(char   *ErrStr);
extern
void    OpenCfg(char    *FileNm);
extern
void    CloseCfg(void);
extern
int     Lex(TOKEN   *sym);

#endif
