/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_abs.c: Liste der Abstracts schreiben
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <signal.h>
#include <malloc.h>
#include <dos.h>
#include "refs.h"
#include "keycodes.h"
#include "fl_ut.h"
#include "abstr.h"
#include "str_refs.h"
#include "ix04_fun.h"
#include "str_fun.h"
#include "l_menu.h"
#include "abbruch.h"
#include "cfg_fun.h"


#define ZEILE_LEN 30600
#define MAX_BLOECKE 62
  /* 62 * 492 Zeichen lange strings koennen verwaltet werden */

#define ABST_DAT "ABST.DAT"
#define ABST_IX  "ABST.IX"


 static char txt_name[PFAD_LEN];
 static char log_name[PFAD_LEN];

 static char bbt_name[PFAD_LEN];
 extern char abstr_dat_name[PFAD_LEN];
 extern char abstr_pix_name[PFAD_LEN];


 static char kennziffer[KENNZIFFER_LEN + 1];
 static char * zeile;

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];
 extern config_set one_config_set;

 static FILE * fpbbt;
 static FILE * fptxt;
 static FILE * fplog;
 static FILE * fpabsdat;

 extern FILE * ix04file;


 static bbatchtable_rec        one_bbt_rec;
 extern abstr_rec              one_abstr_rec;
 extern abstrpix_rec           ix04rec;

 static unsigned int           delaywrite;

 int list_abs_main(char * datpath);
 static int getfilenames_list_abs(void);
 static int dateien_oeffnen_list_abs(void);
 static int dateien_schliessen_list_abs(void);
 static int machlist_list_abs(void);


int list_abs_main(char * datpath)
{
     delaywrite=one_config_set.delay_list_write;

     if (!getfilenames_list_abs())
     {
         return 1;
     }
     if ((zeile = (char *) malloc ((ZEILE_LEN +1) * sizeof(char)))==NULL)
     {
         beenden("Memory allocation error ZEILE",2);
     }
     if (dateien_oeffnen_list_abs())
     {
         machlist_list_abs();
         dateien_schliessen_list_abs();
     }
     free(zeile);
     return 0;
}


static int getfilenames_list_abs(void)
{
  int taste;
  static char eingabe[DOSDATEIVORNAME_LEN +1];
  static int dateipos;
  do
  {
    if (strlen(eingabe)==0) strcpy(eingabe,"ABSTR");
    cls_line("REFERENCES VERSION 3.6 * LIST - ABSTRACT TEXTS");
    info_zeile("Edit filename for textfile, extension '.TXT' will be appended by the program");
    strcpy(wrtxtbu,"File name......");
    wrtxt(wrtxtbu);
    taste = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  eingabe,
                  DOSDATEIVORNAME_LEN,DOSDATEIVORNAME_LEN,0
                     );
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    if (taste==ESC_KEY)
    {
        cls_line("");
        return 0;
    }
    if (!isdosfilename(eingabe)) continue;
    if (taste==ENTER_KEY && strlen(eingabe) > 0) break;
  } while (1);
  upper(eingabe);
  strcpy(txt_name,eingabe);
  strcat(txt_name,".TXT");
  strcpy(log_name,eingabe);
  strcat(log_name,".LOG");

  if (isfile(txt_name))
  {
     taste = lotus_menu("Cancel$File with the name already exists, do not overwrite"
                "@Overwrite$The contents of the existing file will be lost");
     if (taste<=1) return 0;
  }
  cls_line("");
  taste = datei_suchen_default("*.BBT",bbt_name,&dateipos);
  if (taste) return 1;
  else
  {
     wrtxt("\n[Please press any key]>");
     tastelesen();
     return 0;
  }
}

static int dateien_oeffnen_list_abs(void)
{
    if (filesize(abstr_pix_name)==0)
    {
        wrtxt("\n[Abstract index file is empty, please press any key]>");
        tastelesen();
        return 0;
    }
    if (!read_ix04(abstr_pix_name))
    {
        tastelesen();
        return 0;
    }
    if ((fpabsdat=fopen(abstr_dat_name,"rb"))==NULL)
    {
       sprintf(wrtxtbu,"\n[ERROR: cannot read %s]>",abstr_dat_name);
       wrtxt(wrtxtbu);
       close_ix04();
       return 0;
    }
    if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
    {
       sprintf(wrtxtbu,"\n[ERROR: cannot read %s]>",bbt_name);
       wrtxt(wrtxtbu);
       close_ix04();
       fclose(fpabsdat);
       return 0;
    }
    if ((fptxt=fopen(txt_name,"w"))==NULL)
    {
       sprintf(wrtxtbu,"\n[ERROR: cannot write into %s]>",txt_name);
       wrtxt(wrtxtbu);
       close_ix04();
       fclose(fpabsdat);
       fclose(fpbbt);
       return 0;
    }
    if ((fplog=fopen(log_name,"w"))==NULL)
    {
       sprintf(wrtxtbu,"\n[ERROR: cannot write into %s]>",log_name);
       wrtxt(wrtxtbu);
       close_ix04();
       fclose(fpabsdat);
       fclose(fpbbt);
       fclose(fptxt);
       return 0;
    }
    return 1;
}

static int dateien_schliessen_list_abs(void)
{
   close_ix04();
   fclose(fpabsdat);
   fclose(fpbbt);
   fclose(fptxt);
   fclose(fplog);
   return 1;
}

static int machlist_list_abs(void)
{
   long i, ii, j, anzahl_records, byte_zeiger, rec_zeiger, anzahl_bloecke;
   unsigned int laenge;
   j = 1;
   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   rewind(fpbbt);
   anzahl_records = byte_zeiger / sizeof(one_bbt_rec);
   anzahl_records--;
   if (anzahl_records==-1)
   {
       wrtxt("\n[Current BBT-file is empty, please press any key]>");
       tastelesen();

       return 0;
   }
   wrtxt("\n");
   for (i=0;i<=anzahl_records;i++)
   {
       if (abbrechen()) break;
       fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
       /* eingefuegt 24.1.1999: */
       sc_gotoxy(1,one_config_set.sl);

       sprintf(wrtxtbu,"%.1f%% completed", (double) 100.0*(i+1)/(anzahl_records+1));
       wrtxt(wrtxtbu);
       sc_clreol();sc_gotoxy(1,one_config_set.sl);
       strcpy(kennziffer,one_bbt_rec.kennziffer);
       if (locate_ix04(kennziffer,&ix04rec) > -1)
       {
         rec_zeiger = ix04rec.abstr_rptr;
         byte_zeiger = rec_zeiger * sizeof(one_abstr_rec);
         strcpy(zeile,"");
         fseek(fpabsdat,byte_zeiger,SEEK_SET);
         fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
         fseek(fpabsdat,byte_zeiger,SEEK_SET);
         anzahl_bloecke = one_abstr_rec.abstr_n;
         for (ii=1;ii<=anzahl_bloecke;ii++)
         {
             fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsdat);
             strlimcat(zeile,one_abstr_rec.abs_text,ZEILE_LEN+1);
         }
         laenge = strlen(zeile);
         for (ii=0;ii<laenge;ii++)
         {
            if (zeile[ii]=='\xfe')
            {
              zeile[ii]='\n';
            }
         }
         fprintf(fptxt,"==========================================="
         "==================================");
         fprintf(fptxt,"\nABSTRACT TEXT\n");
         fprintf(fptxt,"==========================================="
         "==================================");
         fprintf(fptxt,"\n\n");
         fprintf(fptxt,"%s\n\n",zeile);
         j++;
         if (delaywrite > 0)
         {
#if defined(__EMX__)
            if(((j+1) % 100)==0) _sleep2(delaywrite);
#endif
#if defined(__DJGPP__)
            if(((j+1) % 100)==0) delay(delaywrite);
#endif
         }
       }
       else
       {
          fprintf(fplog,"Abstract text '%s' not found\n",kennziffer);
       }
   }
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   sprintf(wrtxtbu,"Please read file %s for missing abstract texts\n",
                    log_name);
   wrtxt(wrtxtbu);
   wrtxt("\n[Please press any key]>");
   tastelesen();
   return 1;
}
