/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
 *   ix01_fun.c -- index related code, documentation also for ix0[234]_fun.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "refs.h"
#include "ix01_fun.h"
#include "abbruch.h"
#include "l_menu.h"
#include "fl_ut.h"

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 FILE * ix01file;

void mrgeix01(char * srcl_name, char * srcsh_name, char * destin_name)
{
   FILE * srcl;
   FILE * srcsh;
   FILE * destin;
   long i,j;
   long max_srcl, max_srcsh;
   int done_srcl, done_srcsh;

   refspix_rec top_srcl, top_srcsh;
   int doneall;
   done_srcl = 0; done_srcsh = 0;

   if ((srcl=fopen(srcl_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open SRCL");
      beenden(fehlermeldung,2);
   }

   if(setvbuf(srcl,NULL,_IOFBF,20000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for srcl");
      beenden(fehlermeldung,2);
   }

   if ((srcsh=fopen(srcsh_name,"rb"))==NULL)
   {
       sprintf(fehlermeldung,"Cannot open SRCSH");
       beenden(fehlermeldung,2);
   }

   if (setvbuf(srcsh,NULL,_IOFBF,4000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for srcsh");
      beenden(fehlermeldung,2);
   }

   if ((destin=fopen(destin_name,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open DESTIN");
      beenden(fehlermeldung,2);
   }

   if (setvbuf(destin,NULL,_IOFBF,25000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for destin");
      beenden(fehlermeldung,2);
   }


   fseek(srcl,0L,SEEK_END); max_srcl=ftell(srcl)/sizeof(top_srcl);
   rewind(srcl);
   fseek(srcsh,0L,SEEK_END); max_srcsh=ftell(srcsh)/sizeof(top_srcsh);
   rewind(srcsh);

   wrtxt("Rebuilding index file (adding keys)... ");
   i=0;j=0;
   doneall = 0;

   if (i >= max_srcl) done_srcl = 1;
   if (i < max_srcl)
   {

       fread(&top_srcl,sizeof(top_srcl),1,srcl);
       i++;
   }

   if (j >= max_srcsh) done_srcsh = 1;
   if (j < max_srcsh)
   {
        fread(&top_srcsh,sizeof(top_srcsh),1,srcsh);
        j++;
   }

   do
   {
      if ((!done_srcsh) && (done_srcl))
      {
        fwrite (&top_srcsh,sizeof(top_srcsh),1,destin);
        if (j >= max_srcsh) done_srcsh = 1;
        if (j < max_srcsh)
        {
           fread(&top_srcsh,sizeof(top_srcsh),1,srcsh);
           j++;
        }
      }

      else if ((done_srcsh) && (!done_srcl))
      {
        fwrite (&top_srcl,sizeof(top_srcl),1,destin);
        if (i >= max_srcl) done_srcl = 1;
        if (i < max_srcl)
        {
           fread(&top_srcl,sizeof(top_srcl),1,srcl);
           i++;
        }
      }

      else if (strcmp(top_srcl.kennziffer,top_srcsh.kennziffer) < 0)
      {
           fwrite (&top_srcl,sizeof(top_srcl),1,destin);
           if (i >= max_srcl) done_srcl = 1;
           if (i < max_srcl)
           {
              fread(&top_srcl,sizeof(top_srcl),1,srcl);
              i++;
           }
      }

      else // ..if ((top_srcl <= top_srcsh))
      {
            fwrite (&top_srcsh,sizeof(top_srcsh),1,destin);
            if (j >= max_srcsh) done_srcsh = 1;
            if (j < max_srcsh)
            {
               fread(&top_srcsh,sizeof(top_srcsh),1,srcsh);
               j++;
            }
      }
      if (done_srcsh && done_srcl)
          doneall=1;
   } while (!doneall);
   fclose(srcl); fclose(srcsh); fclose(destin);
}


int read_ix01(char * datname)
{
  if ((ix01file=fopen(datname,"rb"))==NULL)
  {
     sprintf(wrtxtbu,"ERROR: Cannot open index file %s for reading\n",datname);
     wrtxt(wrtxtbu);
     return 0;
  }
  return 1;
}

int read_write_ix01(char * datname)
{
  if ((ix01file=fopen(datname,"r+b"))==NULL)
  {
     sprintf(wrtxtbu,"ERROR: Cannot open index file %s for reading and writing\n",datname);
     wrtxt(wrtxtbu);
     return 0;
  }
  return 1;
}

int close_ix01(void)
{
   fclose(ix01file);
   return 1;
}

/*
 *  Gibt die Datensatznummer im Index 0..N-1 zurueck, die zu keyval
 *  (kennziffer) gehoert. Gibt -1 zurueck, wenn der Datensatz nicht gefunden
 *  wurde. Die Indexdatei muss zuvor mit read_ix01 oder read_write_ix01
 *  geoeffnet worden sein
 */

long locate_ix01(const char * keyval, refspix_rec * recd)
{
   long l, r, x, n;
   l = 0;
   fseek(ix01file,0L,SEEK_END);
   n = (ftell(ix01file)/sizeof(refspix_rec)) -1;  /* Groesster Wert mit Pos. n-1 */
   r = n;
   while (r >= l)
   {
      x = (l + r)/2;
      fseek(ix01file,x*sizeof(refspix_rec),SEEK_SET);
      if (fread(recd,sizeof(refspix_rec),1,ix01file)!=1)
      {
         sprintf(fehlermeldung,"ERROR in locate_ix01(): Unable to "
             "read index file");
         beenden(fehlermeldung,2);
      }

      if (strcmp(keyval,recd->kennziffer) < 0) r = x-1; else l = x+1;
      if (strcmp(keyval,recd->kennziffer) == 0)
      {
         fseek(ix01file,-(long) sizeof(refspix_rec),SEEK_CUR);
         return x;
      }
   }
   return -1;
}


/*
 *  firstkey01()
 *
 *  Versucht den ersten Datensatz zu lesen, gibt '-1' zurueck, wenn dies
 *  nicht gelingt, sonst die Position im Bereich [0,n-1]. Nach erfolgreichem
 *  Aufruf der Funktion ist der Dateizeiger bereit, den 2. Datensatz zu
 *  lesen, wird also nicht auf den Angang des 1. Datensatzes zurueckgefuehrt.
 */

long firstkey01(refspix_rec * recd)
{
   fseek(ix01file,0L,SEEK_SET);
   if (fread(recd,sizeof(refspix_rec),1,ix01file)!=1)
      return -1;
   else return ftell(ix01file)/sizeof(refspix_rec) - 1;
}

/*
 *  lastkey01()
 *
 *  Versucht den letzten Datensatz zu lesen. Ermittelt dazu erst, ob
 *  ueberhaupt mindestens ein Datensatz vorhanden, wenn nicht, wird '-1'
 *  zurueckgegeben. Wenn der letzte Datensatz gelesen werden kann, wird die
 *  Position des Dateizeigers im Bereich [0,n-1] zurueckgegeben. Nach
 *  erfolgreichem Aufruf der Funktion wird der Dazeizeiger nicht auf den
 *  Anfang des letzten Datensatzes zurueckgefuehrt.
 */

long lastkey01(refspix_rec * recd)
{
   fseek(ix01file,0L,SEEK_END);
   if (ftell(ix01file)/sizeof(refspix_rec) >= 1)
   {
     fseek(ix01file,-(long) sizeof(refspix_rec),SEEK_END);

     if (fread(recd,sizeof(refspix_rec),1,ix01file)!=1)
        return -1;
     else return ftell(ix01file)/sizeof(refspix_rec) - 1;
   }
   else return -1;
}


/*
 *  Der alte Index ixfile_name wird in den neuen destin_name kopiert, ohne
 *  die in srcsh_name enthaltenen Datensaetze.
 */

void deleteix01(char * ixfile_name, char * srcsh_name, char * destin_name)
{
   FILE * srcsh;
   FILE * destin;
   long i,keyfound;

   refspix_rec rec_ix, rec_srcsh;
   long max_ixfile, max_srcsh;

   if ((ix01file=fopen(ixfile_name,"r+b"))==NULL)
   {
       sprintf(fehlermeldung,"Cannot open SRCL");
       beenden(fehlermeldung,2);
   }

   if(setvbuf(ix01file,NULL,_IOFBF,20000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for ix01file");
      beenden(fehlermeldung,2);
   }

   if ((srcsh=fopen(srcsh_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open SRCSH");
      beenden(fehlermeldung,2);
   }

   if (setvbuf(srcsh,NULL,_IOFBF,4000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for srcsh");
      beenden(fehlermeldung,2);
   }

   if ((destin=fopen(destin_name,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open DESTIN");
      beenden(fehlermeldung,2);
   }

   if (setvbuf(destin,NULL,_IOFBF,25000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for destin");
      beenden(fehlermeldung,2);
   }
   fseek(ix01file,0L,SEEK_END); max_ixfile=ftell(ix01file)/sizeof(refspix_rec); rewind(ix01file);
   fseek(srcsh,0L,SEEK_END); max_srcsh=ftell(srcsh)/sizeof(refspix_rec); rewind(srcsh);

   for (i=0;i<=max_srcsh-1;i++)
   {

      fread(&rec_srcsh,sizeof(refspix_rec),1,srcsh);
      keyfound =locate_ix01(rec_srcsh.kennziffer,&rec_ix);
      if (keyfound >= 0)
      {
          rec_ix.journal_rptr = -1;
          fwrite(&rec_ix,sizeof(refspix_rec),1,ix01file);
      }
   }
   fflush(ix01file);
   rewind(ix01file);
   wrtxt("Rebuilding index file (deleting keys)... ");
   for (i=0;i<=max_ixfile-1;i++)
   {
      fread(&rec_ix,sizeof(refspix_rec),1,ix01file);
      if (rec_ix.journal_rptr > -1) fwrite(&rec_ix,sizeof(refspix_rec),1,destin);
   }
   fclose(ix01file);fclose(srcsh); fclose(destin);

}


void appendix01(char * destin_name, char * src_name)
{
   FILE * src;
   FILE * destin;
   long i;

   long  max_src;
   refspix_rec recd;

   if ((src=fopen(src_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open SRCL");
      beenden(fehlermeldung,2);
   }

   if(setvbuf(src,NULL,_IOFBF,10000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for srcl");
      beenden(fehlermeldung,2);
   }

   if ((destin=fopen(destin_name,"r+b"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open DESTIN");
      beenden(fehlermeldung,2);
   }

   if (setvbuf(destin,NULL,_IOFBF,10000)!=0)
   {
      sprintf(fehlermeldung,"Failed to set up buffer for destin");
      beenden(fehlermeldung,2);
   }

   fseek(src,0L,SEEK_END); max_src=ftell(src)/sizeof(refspix_rec); rewind(src);

   fseek(destin,0L,SEEK_END);
   rewind(src);
   for (i=0;i<=max_src-1;i++)
   {
      fread(&recd,sizeof(refspix_rec),1,src);
      fwrite(&recd,sizeof(refspix_rec),1,destin);
   }
   fclose(src); fclose(destin);
}



/*
 *  Gegeben seien die (sortierten) Indexdateien src_name und destin_name.
 *  ok_appix01 gibt 1 (sonst 0) zurueck, wenn der 1. Key von src_name groesser
 *  ist als der letzte Key von destin_name (Dann koennen neue
 *  Indexdatensaetze mit appendix01 angefuegt werden, sonst nur mit
 *  mergix01).
 */

int ok_appix01(char * destin_name, char * src_name)
{
   FILE * src;
   FILE * destin;
   refspix_rec src_rec, destin_rec;
   if ((src=fopen(src_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open SRCL");
      beenden(fehlermeldung,2);
   }

   if ((destin=fopen(destin_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Cannot open DESTIN");
      beenden(fehlermeldung,2);
   }
   rewind(src);
   fseek(destin,-(long) sizeof(refspix_rec),SEEK_END);
   fread(&src_rec,sizeof(refspix_rec),1,src);
   fread(&destin_rec,sizeof(refspix_rec),1,destin);
   sprintf(wrtxtbu,"src %s, destin %s\n",src_rec.kennziffer,destin_rec.kennziffer);
   wrtxt(wrtxtbu);

   fclose(src); fclose(destin);
   if (strcmp(destin_rec.kennziffer,src_rec.kennziffer) < 1)
      return 1;
   else return 0;
}

/*
 *  scanseq_ix01():
 *
 *  Sucht sequentiell in einer unsortierten Datei mit
 *  Index01-struct-Elementen nach dem ersten Vorkommen der Zeichenkette in
 *  keyval. Gibt die Position des gefundenen Schluesselwertes im Bereich
 *  0..N-1 wieder oder -1, wenn keyval nicht gefunden wurde. scanseq_ix01
 *  oeffnet und schliesst die Datei, deren Name und Pfad in ix_name
 *  uebergeben wird; recd ueber gibt den Inhalt der eingelesenen
 *  struct-Variablen.
 */

long scanseq_ix01(const char * keyval, refspix_rec * recd, char * ix_name)
{
   FILE * ix_fp;
   long i, n;

   if (filesize(ix_name) < sizeof(refspix_rec))
   {
       return - 1;
   }

   if ((ix_fp=fopen(ix_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"ERROR in scanseq_ix01: cannot open %s",
         ix_name);
      beenden(fehlermeldung,2);
   }
   if (setvbuf(ix_fp,NULL,_IOFBF,5000)!=0)
   {
      sprintf(fehlermeldung,"ERROR in scanseq_ix01: cannot set up buffer for reading %s",
         ix_name);
      beenden(fehlermeldung,2);
   }
   fseek(ix_fp,-(long) sizeof(refspix_rec),SEEK_END);
   n = (ftell(ix_fp)/sizeof(refspix_rec));
   rewind(ix_fp);
   for (i=0;i<=n;i++)
   {
      if (fread(recd,sizeof(refspix_rec),1,ix_fp)!=1)
      {
         sprintf(fehlermeldung,"ERROR in scanseq_ix01: cannot "
             "read record in %s",ix_name);
         beenden(fehlermeldung,2);
      }
      if (strcmp(keyval,recd->kennziffer)==0)
      {
          fseek(ix_fp,-(long) sizeof(refspix_rec),SEEK_CUR);
          fclose(ix_fp);
          return i;
      }
   }
   fclose(ix_fp);
   return -1;
}
