//                         testtan.cc
//                                 -- by William T. Wyatt
//  This demonstration program calculates the arctangent of two, and then the
//  tangent of the result.  The final result is compared with two to see how
//  many digits agree.  Try to use as little memory as possible.

//              Copyright (c) 1997 William T. Wyatt, Jr.

#include "super.cc"

int main ( int narg, char * args)
{
	int i, radix, j;

	cout << "Test of accuracy of arctangent and tangent --" << endl;
	cout << "Enter number of digits (at least 5):";
	cin >> i;
	cout << "Enter radix (2-16):";
	cin >> radix;
	super_precision :: setup ( i, radix);
	super_precision x = 2;
	cout << "Maximum complex FFT size used for long mantissa multiplies is "
		<< disclose_fftsize ( ) << endl;

	x = atan ( x);
	x = tan ( x);
	if ( ( ( x.get_digit ( 0) == 2) && ( x.get_digit (1) == 0)) ||
	     ( radix == 2 && x.get_digit ( 1) == 0))
	{		// Result is 2 or slightly over 2.
		for ( j = 1; j < i; j++)
		{
			if ( x.get_digit ( j) != 0)	// Start count from 0.
			{
				break;
			}
		}
		cout << "x and 2 agree to " << j << " digits." << endl;
		cout << "Last 5 digits of x are " << x.get_digit ( i-5) <<
			" " << x.get_digit ( i - 4) <<
			" " << x.get_digit ( i - 3) <<
			" " << x.get_digit ( i - 2) <<
			" " << x.get_digit ( i - 1) << endl;
		cout << "Error in last digit of x is " <<
				x.get_digit ( i - 1) << endl;
	}
	else
	{		// Result is slightly less than 2 (i.e., 1.9999999...).
		for ( j = 1; j < i; j++)
		{
			if ( x.get_digit ( j) != ( radix - 1))
			{
				break;
			}
		}
		cout << "x and 2 agree to " << j - 1 << " digits." << endl;
		cout << "Last 5 digits of x are " << x.get_digit ( i-5) <<
			" " << x.get_digit ( i - 4) <<
			" " << x.get_digit ( i - 3) <<
			" " << x.get_digit ( i - 2) <<
			" " << x.get_digit ( i - 1) << endl;
		cout << "Error in last digit of x is " <<
				( radix - x.get_digit ( i - 1)) << endl;
	}

	return 0;
}
