//===================================================================
// domain.hpp
//
// Version 1.0
//
// Written by:
//   Brent Worden
//   WordenWare
//   email:  Brent@Worden.org
//
// Copyright (c) 1999 WordenWare
//
// Created:  April 10, 1999
// Revised:  
//===================================================================

#ifndef _DOMAIN_HPP_
#define _DOMAIN_HPP_

#include "numerics.h"

NUM_BEGIN

template<class X>
inline bool isPositive(X x)
//-------------------------------------------------------------------
// Return true if x is positive, false otherwise.
//-------------------------------------------------------------------
{
	return x > X(0);
};

template<class X>
inline bool isNegative(X x)
//-------------------------------------------------------------------
// Return true if x is negative, false otherwise.
//-------------------------------------------------------------------
{
	static X zero(0);
	return x < zero;
}

template<class X>
inline bool isNonNegative(X x)
//-------------------------------------------------------------------
// Return true if x is positive or zero, false otherwise.
//-------------------------------------------------------------------
{
	static X zero(0);
	return x >= zero;
}

template<class X>
inline bool isNonPositive(X x)
//-------------------------------------------------------------------
// Return true if x is negative or zero, false otherwise.
//-------------------------------------------------------------------
{
	static const X zero(0);
	return x <= zero;
}

template<class X>
inline bool isZeroOne(X x)
//-------------------------------------------------------------------
// Return true if x is an element of [0.0, 1.0], false otherwise.
//-------------------------------------------------------------------
{
	static const X zero(0);
	static const X one(1);
	return zero <= x && x <= one;
}

NUM_END

#endif

//===================================================================
// Revision History
//
// Version 1.0 - 04/10/1999 - New.
//===================================================================
