#ifndef __BGI_FONT_H_
#define  __BGI_FONT_H_

/*  Class incapsulate BGI fonts (*.chr) description.
    1. BGI fonts are not documented. I use existing format.
    2. Abstract (non-BGI) graphics is used for moveto, lineto, drawpoly and
       fillpoly operations. It should be overloaded in child classes for
       concrete graf. libraries like BGI, Windows GDI and so on.
    3. BGI header have some fields, which are not absolutely necessary. I
       skip them and remarks are not complete for them.
    4. No facilities like "vertical text" and so on is supported.
       The reason is: I suppose to use drawing extender which have rotation
       possibilities.
*/

#include "abs_graf.h" // Abstract graphics, functions shablones for lineto(),
		      // moveto(), drawpoly() and fillpoly()


struct BGI_Font : public AbstractGraphics
    {
    int h_just, v_just;   // LEFT_TEXT 0, CENTER_TEXT 1, RIGHT_TEXT 2
    // BGI Font Prefix
    int HeaderSize;           // ...
    int FontSize;             // Font without header
    // BGI Font descriptor
    uchar SymbolsInFont;      // Usually start from ' '
    uchar FirstSymbol;        // Usually start from ' '
    int StrokesOffset;        // Characters descriptions offset
    char FillFlag;            // Fill or not, default 0
    uchar CapitalHeight;      // ...
    uchar BaseLine;           // Usually 0
    uchar Descender;          // for y, g and other
    // BGI Tables
    int* OffsetTable;         // Offsets of symbols descriptions
    char* WidthTable;         // ...
    char* vectors;

    static char* buffer;
    int* polypoints;          // Used only for filled fonts.

    uchar multx, multy, divx, divy;   // Deformation for setusercharsize()
//////////////////////////////// Functions ///////////////////////////////////
    BGI_Font(char* fileName = 0);  // Create object and load() font. Set
				   // kh_error_code in the case of error
    ~BGI_Font();

    void load(char* fileName);     // Remove old and load new font

    int draw_char(int x, int y, uchar c, int dir = 0);
    int outtextxy(int x, int y, uchar far* str, int dir = 0);
    void outtext(uchar far* str) {} // Overload when CP specified

    int gettextwidth(uchar far*  str);
    int getheight() { return CapitalHeight; }
    void setusercharsize(int mx, int dx, int my, int dy)
	{ multx = mx; multy = my; divx = dx; divy = dy; }
    void settextjustify(int j, int k) { h_just = j; v_just = k; }
    };

#endif __BGI_FONT_H_