
/*
	MISC.CPP
	Created 1995 by Dejvid Zaninovic
*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <mem.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include "screen.hpp"
#include "misc.hpp"
#include "string.hpp"

char *error_msg[] = {				// error messages
	"Not enough memory !"			
};


/*
	void error (error_num n)

	- raise error n
*/

void error (error_num n)
{
	fprintf (stderr, "Fatal Error : %s\a\n", error_msg [n]);
	abort();
}


/*
	void beep()

	- beep
*/

void beep()
{
	cputs ("\a");
}


/*
	int gauge (int x, int y, int l, int p)

	- gauge with length l and percent p
*/

int gauge (int x, int y, int l, int p)
{
	gotoxy (x, y);
	cputcn (' ', l);
	gotoxy (x, y);
	cputcn ('', (l*p)/100);
	return p;
}


/*
	int play (int f, int d)

	- play sound f, delay d
	- return f
*/

int play (int f, int d)
{
	sound (f);
	delay (d*100);
	nosound();
	return f;
}


/*
	int wswap (int w)

    - swap lo and hi byte
*/

int wswap (int w)
{
	int lo, hi;

	lo = LOBYTE (w);
	hi = HIBYTE (w);
	return lo * 0x100 + hi;
}


/*
	int bcdtoi (int bcd)

	- convert from BCD to int
*/

int bcdtoi (int bcd)
{
	int d1, d2, d3, d4;

	d4 = (bcd >> 12);
	d3 = (bcd >> 8) - (d4 << 4);
	d2 = (bcd >> 4) - (d3 << 4) - (d4 << 8);
	d1 = bcd - (d2 << 4) - (d3 << 8) - (d4 << 12);

	return d1 + d2*10 + d3*100 + d4*1000;
}


/*
	int itobcd (int i)

	- convert int to BCD
*/

int itobcd (int i)
{
	int d1, d2, d3, d4;

	d4 = i/1000;
	d3 = i/100 - d4*10;
	d2 = i/10 - d3*10 - d4*100;
	d1 = i - d2*10 - d3*100 - d4*1000;

	return d1 + (d2 << 4) + (d3 << 8) + (d4 << 12);
}
				
char *cfgstr (char *s, word len, FILE *cfg)
{
	do {
		s = fgets (s, len, cfg);
		cfgset (s);
	} while (isblank (s) && s != NULL);
	if (s == NULL)
		return NULL;
	return s;
}

char *cfgdata (char *data, word len, word *l, FILE *cfg)
{
	char tmp [80];
	char *ptmp;
	char num [3];
	word i, id;
	char *endptr;
		
	id = 0;
	ptmp = tmp;
	cfgstr (tmp, 80, cfg);	
	do {
		for (i=0; (*ptmp != ' ') && (*ptmp != 0); i++, ptmp++)
			num [i] = *ptmp; 
		num [i] = 0;
		data [id++] = strtoul (num, &endptr, 16);
		if ((data[id-1] > 0xFF) || (id >= len))
			return NULL;
		ptmp = skipb (ptmp);
		if (*ptmp == 0)
			break;
	} while (TRUE);
	*l = id;
	return data;
}


/*
    char *cfgset (char *s);

    - normalize parameter in cfg file
*/

char *cfgset (char *s)
{
	strchg (s, "\n", "");
	strchg (s, "\t", "");
	strrem (s);
	stralltrim (s);
	return s;
}


/*
    long fsearch (char *search, word len, FILE *in);

    - search string in file
*/

long fsearch (char *search, word len, FILE *in)
{
	char buf [101];

	memset (buf, ' ', 100);
	buf [len] = 0;
	search [len] = 0;
	do {
		buf [len-1] = getc (in);
		if (strcmp (buf, search) == 0)
			break;
		strshl (buf);
	} while (!feof (in));
	if (feof (in))
		return -1;
	fseek (in, -((long) len), SEEK_CUR);
	return ftell (in);
}


/*
    char *fnpath (char *path, char *fpath)

    - get path from full path
*/

char *fnpath (char *path, char *fpath)
{
	char drive [MAXDRIVE];
	char dir [MAXDIR];
	char name [MAXFILE];
	char ext [MAXEXT];

	fnsplit	(fpath, drive, dir, name, ext);
	strcpy (path, drive);
	strcat (path, dir);
	return path;
}


/*
    char *fnext (char *ext, char *fpath);

    - get extension from full path
*/

char *fnext (char *ext, char *fpath)
{
	char drive [MAXDRIVE];
	char dir [MAXDIR];
	char name [MAXFILE];

	fnsplit	(fpath, drive, dir, name, ext);
	return ext;
}


/*
    char *fnpathname (char *s, char *fpath);

    - get full path without extension
*/

char *fnpathname (char *s, char *fpath)
{
	char drive [MAXDRIVE];
	char dir [MAXDIR];
	char name [MAXFILE];
	char ext [MAXEXT];

	fnsplit	(fpath, drive, dir, name, ext);
	strcpy (s, drive);
	strcat (s, dir);
	strcat (s, name);
	return s;
}


/*
    boolean strchk (char *s1, char *s2, int n);

    - s1 is list of strings to compare with string s2
    - n is number of strings in s1
*/

boolean strchk (char *s1, char *s2, int n)
{
	for (; n>0; n--) {
		if (strcmp (s1, s2) == 0)
			return TRUE;
		s1 += strlen (s1) + 1;
	}
	return FALSE;
}


/*
    void cputnl();

    -
*/

void cputnl()
{
	cputs (NL);
}

void putnl()
{
	putchar ('\n');
}
