/* Including <linux/fs.h> became more and more painful.
   Below a very abbreviated version of some declarations,
   only designed to be able to check a magic number
   in case no filesystem type was given. */

#pragma pack (1)

#ifndef BLKGETSIZE
#ifndef _IO
/* pre-1.3.45 */
#define BLKGETSIZE 0x1260		   /* return device size */
#else
/* same on i386, m68k, arm; different on alpha, mips, sparc, ppc */
#define BLKGETSIZE _IO(0x12,96)
#endif
#endif

#define MINIX_SUPER_MAGIC   0x137F         /* original minix fs */
#define MINIX_SUPER_MAGIC2  0x138F         /* minix fs, 30 char names */
struct minix_super_block {
	u_char   s_dummy[16];
	u_char   s_magic[2];
};
#define minixmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8))

#define ISODCL(from, to) (to - from + 1)
#define ISO_STANDARD_ID "CD001"
struct iso_volume_descriptor {
	char type[ISODCL(1,1)]; /* 711 */
	char id[ISODCL(2,6)];
	char version[ISODCL(7,7)];
	char data[ISODCL(8,2048)];
};

#define HS_STANDARD_ID "CDROM"
struct  hs_volume_descriptor {
	char foo[ISODCL (  1,   8)]; /* 733 */
	char type[ISODCL (  9,   9)]; /* 711 */
	char id[ISODCL ( 10,  14)];
	char version[ISODCL ( 15,  15)]; /* 711 */
	char data[ISODCL(16,2048)];
};

#define EXT_SUPER_MAGIC 0x137D
struct ext_super_block {
	u_char   s_dummy[56];
	u_char   s_magic[2];
};
#define extmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8))

#define EXT2_PRE_02B_MAGIC  0xEF51
#define EXT2_SUPER_MAGIC    0xEF53
#define EXT3_FEATURE_COMPAT_HAS_JOURNAL 0x0004
struct ext2_super_block {
	u_char 	s_dummy1[56];
	u_char 	s_magic[2];
	u_char	s_dummy2[34];
	u_char	s_feature_compat[4];
	u_char	s_feature_incompat[4];
	u_char	s_feature_ro_compat[4];
	u_char	s_uuid[16];
	u_char 	s_volume_name[16];
	u_char	s_dummy3[88];
	u_char	s_journal_inum[4];	/* ext3 only */
};
#define ext2magic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8))

#define _XIAFS_SUPER_MAGIC 0x012FD16D
struct xiafs_super_block {
    u_char     s_boot_segment[512];     /*  1st sector reserved for boot */
    u_char     s_dummy[60];
    u_char     s_magic[4];
};
#define xiafsmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8) + \
			(((uint) s.s_magic[2]) << 16) + \
			(((uint) s.s_magic[3]) << 24))

/* From jj@sunsite.ms.mff.cuni.cz Mon Mar 23 15:19:05 1998 */
#define UFS_SUPER_MAGIC 0x00011954
struct ufs_super_block {
    u_char     s_dummy[0x55c];
    u_char     s_magic[4];
};
#define ufsmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8) + \
			 (((uint) s.s_magic[2]) << 16) + \
			 (((uint) s.s_magic[3]) << 24))


typedef unsigned long long       CUInt64;

/* From Richard.Russon@ait.co.uk Wed Feb 24 08:05:27 1999 */
#define NTFS_SUPER_MAGIC "NTFS"
typedef struct ntfs_super_block
 {
  unsigned char  bJumpCode[3];      // Jump to boot code
  char           cSystemID[8];      // System ID, equals "NTFS    "
  unsigned short wSectorSize;       // Sector size for this volume
  unsigned char  bClusterSize;      // The number of sectors per cluster
  unsigned char  Unused1[7];        // 
  unsigned char  bMediaType;        // Media type (0xF8 - harddisk)
  unsigned char  Unused2[2];        // 
  unsigned short wSectorsPerTrack;  // The number of sectors per track
  unsigned short wHeadNumber;       // The number of heads per cylinder
  unsigned char  Unused3[8];        // 
  unsigned char  bBIOSDriveNumber;  // BIOS drive number               =0x80
  unsigned char  bReserved1;
  unsigned char  bExtendedSignature;// Extended BOOT signature         =0x80
  unsigned char  bReserved2;
  CUInt64        u64DiskSize;       // The size of this disk (huge)
  CUInt64        u64MFTCluster;     // The first cluster of $MFT
  CUInt64        u64MFTCopyCluster; // The first cluster of $MFTMirr
  unsigned char  bMFTRecordSize;    // The number of cluster in MFT record
  unsigned char  bReserved3[3];
  unsigned long  dwIndexRecordSize; // The size of INDX record in clusters
  CUInt64        u64SerialNumber;   // Volume serial number

  unsigned char  bBootCode[ 0x200 - 0x50 - 2 ];
  unsigned short wMagic;            // Boot signature                =0xAA55
} t_NTFSBoot;

// From inspection of a few FAT filesystems - aeb 
// Unfortunately I find almost the same thing on an extended partition;
// it looks like a primary has some directory entries where the extended
// has a partition table: IO.SYS, MSDOS.SYS, WINBOOT.SYS 

//    u_char    s_dummy[3];
//    u_char    s_os[8];	 "MSDOS5.0" or "MSWIN4.0" or "MSWIN4.1" 
//				 mtools-3.9.4 writes "MTOOL394" 
//    u_char    s_dummy2[32];
//    u_char    s_label[11];	 for DOS? 
//    u_char    s_fs[8];		 "FAT12   " or "FAT16   " or all zero   
//                               OS/2 BM has "FAT     " here. 
//    u_char    s_dummy3[9];
//    u_char    s_label2[11];	 for Windows? 
//    u_char    s_fs2[8];	         garbage or "FAT32   " 

typedef struct fat_super_block
 {
  unsigned char  bJumpCode[3];      // Jump to boot code
  char           cSystemID[8];      // OEM ID "MSDOS5.0" or "MSWIN4.0" or "MSWIN4.1" 
				    // mtools-3.9.4 writes "MTOOL394" 
  unsigned short wSectorSize;       // Sector size for this volume
  unsigned char  bClusterSize;      // The number of sectors per cluster
  unsigned short wReservedSectors;  // The number of sectors per boot
  unsigned char  bFATNumber;        // The number of FATs
  unsigned short wRootEntries;      // The number of entries per root dir
  unsigned short wDiskSize;         // The size of this disk (small)
  unsigned char  bMediaType;        // Media type (0xF8 - harddisk)
  unsigned short wFATSize;          // The size of a FAT in sectors
  unsigned short wSectorsPerTrack;  // The number of sectors per track
  unsigned short wHeadNumber;       // The number of heads per cylinder
  unsigned long  dwHiddenSectors;   // The number of 'hidden' sectors
  unsigned long  dwDiskSize;        // The size of this disk (large)

  union
   {
    struct
    {
      unsigned char  bBIOSDriveNumber;  // BIOS drive number
      unsigned char  bReserved;
      unsigned char  bExtendedSignature;// Extended BOOT signature
      unsigned long  dwSerialNumber;    // Partition serial number
      char           cVolumeLabel[11];  // Volume label for DOS? 
      char           cSystemID[8];      // System ID string "FAT12   " or "FAT16   " or all zero   
                            		// OS/2 BM has "FAT     " here. 
      unsigned char  bBootCode[448];
    } FAT16;

    struct
    {
      unsigned long  dwFatSize;         // FAT size (large)
      unsigned short wFATFlags;         // FAT mirriring flags
      unsigned short wVersion;          // File system version
      unsigned long  dwRootCluster;     // The first cluster of root dir
      unsigned short wInfoSector;       // Offset to system info sector
      unsigned short wBackupBootSector; // Offset to backup boot
      unsigned long  dwReserved[3];
      unsigned char  bBIOSDriveNumber;  // BIOS drive number
      unsigned char  bReserved;
      unsigned char  bExtendedSignature;// Extended BOOT signature
      unsigned long  dwSerialNumber;    // Partition serial number
      char           cVolumeLabel[11];  // Volume label
      char           cSystemID[8];      // System ID string
    } FAT32;
  };
  unsigned short wMagic;            // Boot signature                =0xAA55
} t_FATBoot;

///////////////////////////////////////////////////////////
// FAT boot defines
///////////////////////////////////////////////////////////
#define FAT_BOOT_MAGIC               0xAA55
#define FAT_BOOT_MEDIA_TYPE          0xF8
#define FAT_BOOT_EXTENDED_SIGNATURE  0x29
#define FAT_BOOT_FAT12_ID            "FAT12   "
#define FAT_BOOT_FAT16_ID            "FAT16   "
#define FAT_BOOT_FAT32_ID            "FAT32   "
#define FAT_BOOT_ACTIVE_FAT_MASK     0x000F
#define FAT_BOOT_MIRROR_FAT          0x0080
#define FAT_BOOT_FAT32_VERSION       0
#define FAT_BOOT_FAT32_INFO_SECTOR   1
#define FAT_BOOT_FAT32_BACKUP_SECTOR 6
#define FAT_BOOT_DISK_NUMBER         0x80

//    (*Buf).FatTp=FFAT32_;
//    (*Buf).FatSect=BR.e.f32.LFatSect;
//    (*Buf).f.Flgs=BR.e.f32.f.Flgs;
//    (*Buf).SInfSct=BR.e.f32.SInfSct;
//    (*Buf).RBtSct=BR.e.f32.RBtSct;
//    (*Buf).RootClst=BR.e.f32.RootClst;
//    (*Buf).RootEnts=0;
//    (*Buf).FSVer=BR.e.f32.FSVer;
//  }

#define XFS_SUPER_MAGIC "XFSB"
#define XFS_SUPER_MAGIC2 "BSFX"
struct xfs_super_block {
    u_char    s_magic[4];
    u_char    s_dummy[28];
    u_char    s_uuid[16];
    u_char    s_dummy2[60];
    u_char    s_fname[12];
};

#define CRAMFS_SUPER_MAGIC 0x28cd3d45
struct cramfs_super_block {
	u_char    s_magic[4];
	u_char    s_dummy[12];
	u_char    s_id[16];
};
#define cramfsmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8) + \
			 (((uint) s.s_magic[2]) << 16) + \
			 (((uint) s.s_magic[3]) << 24))

#define HFS_SUPER_MAGIC 0x4244
struct hfs_super_block {
	u_char    s_magic[2];
	u_char    s_dummy[18];
	u_char    s_blksize[4];
};
#define hfsmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8))
#define hfsblksize(s)	((uint) s.s_blksize[0] + \
			 (((uint) s.s_blksize[1]) << 8) + \
			 (((uint) s.s_blksize[2]) << 16) + \
			 (((uint) s.s_blksize[3]) << 24))

#define HPFS_SUPER_MAGIC 0xf995e849
struct hpfs_super_block {
	u_char    s_magic[4];
	u_char    s_magic2[4];
};
#define hpfsmagic(s)	((uint) s.s_magic[0] + (((uint) s.s_magic[1]) << 8) + \
			 (((uint) s.s_magic[2]) << 16) + \
			 (((uint) s.s_magic[3]) << 24))

struct adfs_super_block {
	u_char    s_dummy[448];
	u_char    s_blksize[1];
	u_char    s_dummy2[62];
	u_char    s_checksum[1];
};
#define adfsblksize(s)	((uint) s.s_blksize[0])
