PROGRAM Bisect2;

{------------------------------------------------------------------}
{-                                                                -}
{- Purpose: This program demonstrates the bisection routine with  -}
{-          a bare minimum of calling code.                       -}
{-          No I/O options or error checking code.                -}
{-                                                                -}
{-                                                                -}
{- Include files:   BISECT.INC     procedure Bisect               -}
{-                                                                -}
{-    Version July 1987                                           -}
{------------------------------------------------------------------}


VAR
  LeftEndpoint, RightEndpoint : Real; { Endpoints of the region }
  Answer, yAnswer : Real;             { Root of F(X) }
  Tol : Real;                         { Tolerance }
  Iter, MaxIter : Integer;            { Number of iterations }
  Error : Byte;                       { Flags something wrong}



  {----- HERE IS THE FUNCTION TO FIND A ROOT OF ------}

  FUNCTION TNTargetF(X : Real) : Real;
  BEGIN
    TNTargetF := -40.0+X*(1.0-Exp(-98.1/X))/(1.0+Exp(-98.1/X));
  END; { function TNTargetF }

  {---------------------------------------------------}


  {$I BISECT.INC}  { Load procedure Bisect }


BEGIN
  { Get necessary input. }
  Error := 0;
  WriteLn('Enter LeftEndpoint RightEndpoint seperated by a space.');
  ReadLn(LeftEndpoint, RightEndpoint);
  WriteLn;
  Write('Enter the tolerance (1E-8 suggested): ');
  ReadLn(Tol);
  Write('Enter maximum number of interations (100 suggested): ');
  ReadLn(MaxIter);

  Bisect(LeftEndpoint, RightEndpoint, Tol, MaxIter,
         Answer, yAnswer, Iter, Error);

  { Give resulting output. }
  WriteLn;
  WriteLn('Error = ', Error);
  WriteLn('left endpoint: ':30, LeftEndpoint);
  WriteLn('right endpoint: ':30, RightEndpoint);
  WriteLn('Tolerance: ':30, Tol);
  WriteLn('Maximum number of iterations: ':30, MaxIter);
  WriteLn;
  WriteLn('Number of iterations: ':26, Iter:3);
  WriteLn('Calculated root: ':26, Answer);
  WriteLn('Value of the function  ':26);
  WriteLn('at the calculated root: ':26, yAnswer);
END.
