/*******************************************************************

     Turbo Prolog Toolbox
     (C) Copyright 1987 Borland International.

 (Corrections 10/87 by a.lane)


 Returning all matching files to a file specified by backtracking.

 Ex: FindMatch("c:\\prolog\\*.PRO",SearchAttribute,MatchFileName,
                FilesAttribute,Hour,Min,Year,Month,Day, FilesSize)


  Ex: FindMatch("c:\\*.*",63,MatchFileName,FilesAttribute,Hour,Min,
                 Year,Month,Day,FilesSize)

 Range for attributes remembering it is a bitmask
 Attributes     =       0       Search for ordinary files
                =       1       File is read only
                =       2       Hidden file
                =       4       System file
                =       8       Volume label
                =       16      Subdirectory
                =       32      Archive file (used by backup & restore)

 Hour           =       0-23    Hour of day when the file was created
 Min            =       0-59    Minutes
 Year           =       1980-2099

 Month          =       1-12
 Day            =       1-31
 FilesSize      =       0-30MB  Size of file

********************************************************************/

PREDICATES
  nondeterm FindMatch(String,Integer,String,Integer,Integer,Integer,
                      Real,Integer,Integer,Real)
/* NOTE: Last parameter in FindMatch changed from Integer to Real
     10/87 a.lane
*/
  nondeterm findfiles(STRING,INTEGER)
  nondeterm findnext
  convert_Match(String,String,Integer,Integer,Integer,Real,Integer,
                Integer,Real)
/* NOTE: Last parameter in convert_Match changed from Integer to Real
         10/87 a.lane */

  DTA_word(String,Integer,Integer)
  FrontChar2(String,Char,String)
  isolate_bits(Integer,Integer,Integer,Integer)
  adjust( integer, real)

CLAUSES
  FindMatch(FileSpec,Attribute,
  FileName,FilesAttr,Hour,Min,Year,Month,Day,FilesSize):-
        /* Allocate Default Disk buffer area */
     str_len(DTA,128),
     ptr_dword(DTA,DTA_SEG,DTA_OFF),
     AX = $1A00, DS=DTA_SEG, DX=DTA_OFF,
     bios($21, reg(AX,0,0,DX,0,0,DS,0),_),
     findfiles(FileSpec,Attribute),
     convert_Match(DTA,FileName,FilesAttr,Hour,Min,Year,Month,Day,
                   FilesSize).

  findfiles(FileSpec,Attribute):-
     ptr_dword(FileSpec,FSPEC_SEG,FSPEC_OFF),
     bios($21, reg($4E00,0,Attribute,FSPEC_OFF,0,0,FSPEC_SEG,0),_),
     findnext.

  findnext.
  findnext:-
        bios($21, reg($4F00,0,0,0,0,0,0,0),reg(AX,_,_,_,_,_,_,_)),
        AX=0,
        findnext.


  convert_Match(DTA,FileName,FilesAttr,Hour,Min,Year,Month,Day,
                FilesSize):-
        DTA_word(DTA,21,FAttr), bitand(Fattr,255,FilesAttr),
        DTA_word(DTA,22,FilesTime), bitand(FilesTime,63,Min),
        isolate_bits(FilesTime,6,31, Hour),
        DTA_word(DTA,24,FilesDate), bitand(FilesDate,31,Day),
        isolate_bits(FilesDate,5,15,Month),
        isolate_bits(FilesDate,9,127,Year1),Year=Year1+1980,
        DTA_word(DTA,26,LowSize),
        DTA_word(DTA,28,HighSize),
/* LowSize and/or HighSize may be returned as negative numbers if
   they are larger than 32767 (they are, after all, integers). The
   adjust() predicate turns 'em into reals for us.   a.lane
*/
        adjust(LowSize,LS),
        adjust(HighSize,HS),
        FilesSize=LS+1024.0*64.0*HS,
        ptr_dword(DTA,DTA_SEG,DTA_OFF),
        NEW_OFF = DTA_OFF+30,
        ptr_dword(FileName1,DTA_SEG,NEW_OFF),
        concat(FileName1,"",FileName).  /* Create a copy */


/*******************************************************************
        Return a word from the DTA area
********************************************************************/

  DTA_word(DTA,OFF,WORD):-
        ptr_dword(DTA,DTA_SEG,DTA_OFF),
        NEW_OFF = DTA_OFF+OFF,
        memword(DTA_SEG,NEW_OFF,WORD).


/*******************************************************************
        Special version of frontchar
********************************************************************/

  FrontChar2(S,C,S2) :- FrontChar(S,C,S2),!.
  FrontChar2(S,'\000',S2) :-
        ptr_dword(S,S_SEG,S_OFF),
        S2_OFF=S_OFF+1,
        ptr_dword(S2,S_SEG,S2_OFF).

  isolate_bits(Word,ShiftFac,BitMask,V) :-

        bitright(Word,ShiftFac,V1),
        bitand(V1,BitMask,V).

/*******************************************************************

  adjust(integer, real)

        (added 10/87 by a.lane )

Recall that an integer is a 16-bit quantity.  If the high-order bit
is set, the integer is  considered to be a negative number in the
range -32768 to -1. To convert this value to a number from 32768 to
65535, we add  65536.0 (the '.0' part makes sure we add a real
number, else we'd be effectively adding  zero!)
********************************************************************/

adjust( I, R ) :-
        I < 0,
        R = I + 65536.0,
        !;
        R = I,!.


