#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <fcntl.h>

#define CHAPTERS 81
#define SCREEN_LINES 25

void main(int argc, char *argv[])
{
/******************* Declarations *******************/
   FILE *taotext;
   int i, chapter;
   unsigned char sday, fday;
   char textline[80];
   struct ftime taofiletime;
   struct date sysdate;
   struct time systime;

/*************** Open File Unbuffered ***************/
   if(argc==1) /* no arguments */
   {
      if((i=open("TAO.TXT", O_RDONLY))==-1)
      {
         printf("Can't find tao.txt.\n");
         exit(1);
      }
   }
   else  /* use cmd line filename */
      if((i=open(argv[1], O_RDONLY))==-1)
      {
         printf("Can't find %s.\n", argv[1]);
         exit(1);
      }

/******************** Set Chapter ********************/
   getftime(i, &taofiletime);
   getdate(&sysdate);
   gettime(&systime);

   /* Chapter number encoded in filetime min and sec */
   chapter = taofiletime.ft_min*30 + taofiletime.ft_tsec;

   /* Change chapters after 6 am. */
   sday = sysdate.da_day + (systime.ti_hour>=6);
   fday = taofiletime.ft_day + (taofiletime.ft_hour>=6);
   sysdate.da_year -= 1980; /* ft_year is years since 1980 */

   if(sysdate.da_year>taofiletime.ft_year ||
      sysdate.da_mon>taofiletime.ft_month ||
      sday>fday || chapter<1 || chapter>CHAPTERS)
   {
      chapter++;
      if(chapter<1 || chapter>CHAPTERS) chapter=1;
      taofiletime.ft_year = sysdate.da_year;
      taofiletime.ft_month = sysdate.da_mon;
      taofiletime.ft_day = sysdate.da_day;
      taofiletime.ft_hour = systime.ti_hour;
      taofiletime.ft_min = chapter/30;
      taofiletime.ft_tsec = chapter%30;
      if (setftime(i, &taofiletime))
      {
         printf("Can't modify text file date.\n");
         exit(1);
      }
   }

   close(i);

/**************** Open File Buffered ****************/
   if(argc==1) /* no arguments */
   {
      if((taotext=fopen("TAO.TXT", "r"))==NULL)
      {
         printf("Can't find tao.txt.\n");
         exit(1);
      }
   }
   else  /* use cmd line filename */
      if((taotext=fopen(argv[1], "r"))==NULL)
      {
         printf("Can't find %s.\n", argv[1]);
         exit(1);
      }

/****************** Display Chapter ******************/
   while(fgets(textline, 4, taotext), i=atoi(textline), i != chapter)
      if(feof(taotext))
      {
         printf("Reached end-of-file in tao.txt.\n");
         printf("You have an invalid tao.ini file.\n");
         fclose(taotext);
         exit(3);
      }
   clrscr();
   printf("------------%d------------\n", chapter);
   i=0;
   while(fgets(textline, 80, taotext), i++, textline[0]!='*')
   {
      printf("%s", textline);
      if(i==(SCREEN_LINES-2))  /*allows for passages > screen_lines*/
      {
         getch();
         printf("------------%d------------\n", chapter);
      }
   }
   printf("\n");
   fclose(taotext);
}
