PROGRAM Sysgen;

(*

  Roger Link 12/08/89

*)

USES
  DOS, CRT;

CONST
  Black     = 0;     Blue      = 1;    Green     = 2;     Cyan      = 3;
  Red       = 4;     Magenta   = 5;    Brown     = 6;     L_Gray    = 7;
  Gray      = 8;     L_Blue    = 9;    L_Green   = 10;    L_Cyan    = 11;
  L_Red     = 12;    L_Magenta = 13;   Yellow    = 14;    White     = 15;

  ErrorColor = Red;

TYPE
  LineType = STRING[ 255 ];

VAR
  Sysgen_Value     : INTEGER;

  OutputFile       : TEXT;

  Sysgen_FileName  : LineType;

  FileOpen         : BOOLEAN;

  Help             : BOOLEAN;
  FatalError       : BOOLEAN;
  QueryUser        : BOOLEAN;


PROCEDURE SignOn;
BEGIN
  TextColor( Magenta );
  WriteLn;
  WriteLn( '** Link Sysgen Utility - V1.32 12/08/89 **' );
  WriteLn;
END;  (* SignOn *)


PROCEDURE DoHelpScreen;
BEGIN
 TextColor( L_Green );
 WriteLn( 'SYSGEN [-Ffilename.type] [-Q] [-?] [?] [#]' );
 TextColor( Green);
 WriteLn( '  - Square brackets "[ ]" indicate a option' );
 WriteLn( '  - filename.type is the configuration file to use (defaults to sysgen.cfg)' );
 WriteLn( '  - # = sysgen value number in range 0-9' );
 WriteLn( '  - ALL OPTIONS MUST have spaces proceeding and preceding that option' );
 WriteLn( '  "-Q" -> Enter Query mode      "-?" or "?" This help screen' );
 WriteLn( ' If no parameters, sysgen enters query mode.'  );
 WriteLn;
 WriteLn( ' Column one of each line in the config file controls the primary use of that' );
 WriteLn( 'line. Columns 2-10 control the secondary use of the line. If the line is to' );
 WriteLn( 'be included/interperted, a character is put in the sysgen value+1 position to' );
 WriteLn( 'indicate it.' );
 WriteLn( '  The following commands are used: ' );
 WriteLn( '  "V" -> Variable line used for naming/allocating sysgen value when' );
 WriteLn( '         sysgen is used in query mode.' );
 WriteLn( '  "F" -> FILENAME.TYPE to put following SYSGEN.File data lines into' );
 WriteLn( '  "-" -> Output file data line' );
 WriteLn( '  "." -> Meta commands:' );
 WriteLn( '         "E" -> Echo the line. (unconditional echo)' );
 WriteLn( '         ";" -> comment line for sysgen config file. (ignored by sysgen)' );
 WriteLn( '  "E" -> Echo line (conditional)' );
END;  (* DoHelpScreen *)


PROCEDURE Do_Error( Line : LineType; ErrorPointer : INTEGER );
BEGIN
  TextColor( ErrorColor );
  WriteLn( Line );
  WriteLn( ' ':ErrorPointer - 1, '^--- Error' );
END;  (* Do_Error *)


FUNCTION Check( Line : LineType; Sysgen_Value : INTEGER ) : BOOLEAN;
(* Determine if this Line has a character in the proper position to *)
(* match Sysgen_Value. Any character will do!!! *)
BEGIN
  IF Length( Line ) > 9 THEN              (* Check for short lines *)
    Check := ( Line[ Sysgen_Value + 1 ] ) <> ' '
  ELSE
    BEGIN
      Do_Error( Line, 3 );                (* Go if line is too short....*)
      Check := FALSE;
    END;
END;  (* Check *)


PROCEDURE Do_MetaStuff( Line : LineType );
BEGIN
  Case Line[ 2 ] OF
    'E' : BEGIN
            Delete( Line, 1, 2 );   (* Delete ".;" *)
            TextColor( Green );
            WriteLn( Line );        (* Display the rest to the user *)
          END;
    ';' : BEGIN END;       (* Do nothing for comment line *)
  ELSE
    Do_Error( Line, 2 );            (* Un recoginized meta command *)
  END;
END; (* Do_MetaStuff *)


PROCEDURE Do_FileName( Line : LineType; Sysgen_Value : INTEGER );
VAR
  FileName : LineType;
BEGIN
  IF Check( Line, Sysgen_Value ) THEN         (* If this line is to be used *)
    BEGIN                                     (*  for this system *)
      IF FileOpen THEN
        Close( OutputFile );                  (* Close any files that we are *)
                                              (*  working on *)
      TextColor( Green );
      Delete( Line, 1, 10 );                  (* Delete prefix *)
      FileName := Line;                       (* Fire up the Name *)
      WriteLn( 'Output File = ', FileName );

      Assign( OutputFile, FileName );
      ReWrite( OutputFile );

      FileOpen := TRUE;                      (* Remember that we have a file *)
    END;                                     (*  open *)
END;  (* Do_FileName*)



PROCEDURE Do_OutputLine( Line : LineType; Sysgen_Value : INTEGER );
BEGIN
  IF Check( Line, Sysgen_Value ) THEN        (* Check to see if this line is *)
    BEGIN                                    (*  to be used *)
      Delete( Line, 1, 10 );                 (* Delete prefix *)
      WriteLn( OutputFile, Line );           (* Put out line *)
    END;
END;  (* Do_OutputLine *)



PROCEDURE Do_Echo( Line : LineType; Sysgen_Value : INTEGER );
BEGIN
  IF Check( Line, Sysgen_Value ) THEN        (* Check to see if this line is *)
    BEGIN                                    (*  to be used *)
      Delete( Line, 1, 10 );                 (* Delete prefix *)
      TextColor( L_Green );
      WriteLn( Line );                       (* Display to user *)
    END;
END;  (* Do_Echo *)



PROCEDURE SysgenWork( Sysgen_FileName : LineType; Sysgen_Value : INTEGER );
VAR
  Sysgen_File : TEXT;
  Line        : LineType;
  Test        : INTEGER;
BEGIN
  TextColor( Green );

  WriteLn( 'Using sysgen file -> ', Sysgen_FileName );

  Assign( Sysgen_File, Sysgen_FileName );  (* Open configuration file *)
  Reset( Sysgen_File );

  FileOpen := FALSE;                       (* No files are currently open *)

  WHILE NOT( EOF( Sysgen_File )) DO
    BEGIN
      ReadLn( Sysgen_File, Line );         (* Get a config line *)

      IF Length( Line ) > 1 THEN
        CASE Line[ 1 ] OF                  (* "Parse" config line *)
          '.' : Do_MetaStuff( Line );
          'F' : Do_FileName( Line, Sysgen_Value );
          '-' : Do_OutputLine( Line, Sysgen_Value );
          'E' : Do_Echo( Line, Sysgen_Value );
          'V' : ;                          (* Ingore variable lines *)
        ELSE
          Do_Error( Line, 1 );
        END;
    END;

  IF FileOpen THEN Close( OutputFile );    (* Close any files that we have *)
                                           (*  open *)
  Close( Sysgen_File );
END;  (* SysgenWork *)



PROCEDURE DoSysgen( Sysgen_FileName : LineType; Sysgen_Value : INTEGER );
VAR
  Character : CHAR;
BEGIN
  IF Sysgen_Value = 0 THEN
    BEGIN
      TextColor( Red );
      WriteLn( '** Sysgening --> NO SYSTEM **' );
      TextColor( CYAN );
      WriteLn( 'THIS WILL ERASE \AUTOEXEC.BAT & \CONFIG.SYS', ^G );
      Write( 'Do you want to do this? (Y/x) ' );
      TextColor( Brown );
      ReadLn( Character );

      TextColor( Green );
      IF UpCase( Character ) = 'Y' THEN
       BEGIN
         WriteLn( '    Erasing \autoexec.bat' );
         Assign( OutputFile, '\AUTOEXEC.BAT' );
         Erase( OutputFile );
         WriteLn( '    Erasing \config.sys' );
         Assign( OutputFile, '\CONFIG.SYS' );
         Erase( OutputFile );
       END
      ELSE
        WriteLn( '* * * No Sysgen action taken * * *' );
    END
  ELSE
    SysgenWork( Sysgen_FileName, Sysgen_Value );
END;  (* DoSysgen *)


PROCEDURE DoQueryUser;
VAR
  InputFile        : Text;
  SystemAvailable  : Array[ 1..9 ] OF INTEGER;
  SystemAvailPoint : INTEGER;
  Line             : LineType;
  GoodSysgen       : BOOLEAN;
  X                : INTEGER;

PROCEDURE ProcessQueryLine;
VAR
  X                : INTEGER;
BEGIN
  IF Length( Line ) < 10 THEN Do_Error( Line, 1 );

  Delete( Line, 1, 1 );     (* Get rid of V *)

  TextColor( Cyan );

  FOR X := 1 TO 9 DO
   BEGIN
     IF Line[ 1 ] <> ' ' THEN   (* We have found a valid system value *)
      BEGIN
       INC( SystemAvailPoint );
       SystemAvailable[ SystemAvailPoint ] := X; (* Remember valid system #s *)
       Write( X:2 );                             (* Display # to user *)
      END;
     Delete( Line, 1, 1 );
   END;

  TextColor( Green );

  WriteLn( ' ', Line );         (* Display system name/message to user *)
END;


BEGIN
  TextColor( Yellow );

  WriteLn( 'For SYSGEN help, type "SYSGEN ?"' );
  WriteLn;

  Assign( InputFile, Sysgen_FileName );
  Reset( InputFile );

  SystemAvailPoint := 0;            (* No systems have been found *)

  TextColor( Cyan ); Write( ' 0 ' );
  TextColor( Green ); WriteLn( '** NO autoexec.bat / NO config.sys ' );

  WHILE NOT EOF( InputFile ) DO
   BEGIN
     ReadLn( InputFile, Line );
     IF Line[ 1 ] = 'V' THEN        (* Get and process all variable lines *)
       ProcessQueryLine;
   END;

  Close( InputFile );
  WriteLn;

  GoodSysgen := FALSE;

  REPEAT
    TextColor( Cyan );
    Write( 'Enter number of system desired -> ' );
    TextColor( Brown );
    ReadLn( Sysgen_Value );

    IF Sysgen_Value = 0 THEN
      GoodSysgen := TRUE            (* Determine if user has entered a good *)
    ELSE                            (*  sysgen value *)
      FOR X := 1 TO SystemAvailPoint DO
        IF SystemAvailable[ X ] = Sysgen_Value THEN
          GoodSysgen := TRUE;

  UNTIL GoodSysgen;

  WriteLn;

  DoSysgen( Sysgen_FileName, Sysgen_Value );
END;  (* DoQueryUser *)



PROCEDURE ParseParameters;
VAR
  X        : INTEGER;
  ValError : INTEGER;
  Line     : LineType;

PROCEDURE ProcessDashCommands;
BEGIN
  CASE UpCase( Line[ 2 ] ) OF
    '?' : Help := TRUE;
    'F' : Sysgen_FileName := Copy( Line, 3, Length( Line ) - 2 );
    'Q' : QueryUser := TRUE;
  ELSE
   BEGIN
     WriteLn( 'Bad parameter -> "', Line, '"' );
     FatalError := TRUE;
   END;
  END;
END;  (* Process DashCommands *)

BEGIN
  TextColor( ErrorColor );  (* Assume error color !!! *)

  X := 1;

  REPEAT
    Line := ParamStr( X );              (* Get parameter *)

    CASE Line[ 1 ] OF
      '-' : ProcessDashCommands;
      '?' : Help := TRUE;
    ELSE
      IF Line[ 1 ] IN [ '0'..'9' ] THEN
       BEGIN
         Val( Line, Sysgen_Value, ValError );
         IF ValError <> 0 THEN
           BEGIN
             WriteLn( 'Sysgen Value is not numeric' );
             FatalError := TRUE;
           END
         ELSE
           IF Sysgen_Value > 9 THEN
            BEGIN
             WriteLn( 'Sysgen Value is greater than 9. Must be in 0-9 range' );
             FatalError := TRUE;
            END;
       END
      ELSE
       BEGIN
         WriteLn( 'Bad parameter -> "', Line, '"' );
         FatalError := TRUE;
       END;
    END;

    INC( X );

  UNTIL ( HELP ) OR ( FatalError ) OR ( X > ParamCount );

  TextColor( Green );
END;  (* ParseParameters *)



(*** * * *  *  *  *   *   M A I N   P R O G R A M  *   *  *  *  * * * ***)

BEGIN
  SignOn;

  Sysgen_FileName := 'SYSGEN.CFG';       (* Use default config file *)

  IF ParamCount = 0 THEN
    DoQueryUser             (* If no parameters, query user for sysgen # *)
  ELSE
    BEGIN
      TextColor( Green );


      FatalError      := FALSE;      (* We're not dead yet!!! *)
      Help            := FALSE;      (* No one has asked for help yet *)
      QueryUser       := FALSE;      (* We are not in query mode yet *)

      Sysgen_Value    := -1;         (* Default to a bad sysgen value *)
                                     (*  so we can tell if user input a *)
                                     (*  sysgen value *)

      ParseParameters;               (* Attempt to figure out users request *)

      IF FatalError THEN
       BEGIN
        TextColor( ErrorColor );
        WriteLn( 'Sysgen terminating on Fatal Error', ^G )
       END
      ELSE
        BEGIN
          IF Help THEN
            DoHelpScreen
          ELSE
            IF ( QueryUser ) OR ( Sysgen_Value = -1 ) THEN
              DoQueryUser
            ELSE
              DoSysgen( Sysgen_FileName, Sysgen_Value )
        END;
    END;
END.
