//===========================================================================
//                        Compiler Includes
//===========================================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <mem.h>

#include <mwr.h>
#include <mwrstr.h>
#include <mwrscr.h>
#include "INSTALL.H"


//===========================================================================
//                       Global Data Defines
//===========================================================================

const char _vers[] = " MWRLOAD Install Program - Version 1.0 (5/30/95) - by Marty W. Rhodes";
const char _s0[] = "\r\n";
const char _s1[] = "MWRLOAD Fixed Disk Boot Loader installed ok.";
const char _s2[] = "MWRLOAD Fixed Disk Boot Loader was NOT installed ok.";
const char _s3[] = "WARNING: This program replaces your Hard Disk's Master Boot Record!";
const char _s4[] = "Make sure you have a bootable DOS floppy with the FDISK program on it.";
const char _s5[] = "If your system does not boot properly, boot DOS from your floppy disk and";
const char _s6[] = "type:      FDISK /MBR <enter>";
const char _s7[] = "Type ""YES"" to install MWRLOAD or type ""NO"" to abort the install.";
const char _s8[] = "Install aborted.";
const char _yes[] = "YES";
const char loader_name[] = "MWRLOAD.BIN";
union REGS r;
struct SREGS sr;
boot_sector bs;
char loader_code[sizeof(bs.code)];

//===========================================================================
//                       Program Functions
//===========================================================================

void main()
  {
    char ans[129];
    FILE * f;
    puts(_s0);
    puts(_vers);
    puts(_s0);
    puts(_s3);
    puts(_s4);
    puts(_s7);
    puts(_s0);
    memset(ans,'\0',sizeof(ans));
    beep(3000,500);
    gets(ans);
    strcpy(ans,compress(ans," \n\r"));
    if (stricmp(_yes,ans) != 0)
      {
        puts(_s8);
        exit(1);
      }
    f = fopen(loader_name,"rb");
    if (f == NULL)
      {
        printf("Error opening file %s\r\n",loader_name);
        exit(2);
      }
    memset(loader_code,'\0',sizeof(loader_code));
    if (fread(loader_code,sizeof(loader_code),1,f) != 1)
      {
        printf("Error reading file %s\r\n",loader_name);
        exit(2);
      }
	 r.h.ah = 0x02;                 // BIOS Int 13, function 2 (Read Sector)
	 r.h.al = 0x01;                 // Sectors to read
	 r.h.cl = 0x01;                 // Sector #
	 r.h.ch = 0x00;                 // Cylinder #
	 r.h.dl = 0x80;                 // Drive #  (1st HD = 0x80)
	 r.h.dh = 0x00;                 // Head #
	 r.x.bx = FP_OFF(&bs);
    sr.es = FP_SEG(&bs);
    bios_call(0x13,FALSE);
    if (r.h.ah != 0 || r.x.cflag != 0)
      {
        puts(_s0);
        puts("ERROR: Error reading master boot record of Fixed Disk Drive 0.");
        puts(_s5);
        puts(_s6);
        exit(3);
      }
    puts("Writing new master boot record...");
    memcpy(bs.code,loader_code,sizeof(bs.code));
    r.h.ah = 0x03;                 // BIOS Int 13, function 3 (Write Sector)
    r.h.al = 0x01;                 // Sectors to write
    r.h.cl = 0x01;                 // Sector #
    r.h.ch = 0x00;                 // Cylinder #
    r.h.dl = 0x80;                 // Drive #  (1st HD = 0x80)
    r.h.dh = 0x00;                 // Head #
    r.x.bx = FP_OFF(&bs);
    sr.es = FP_SEG(&bs);
    bios_call(0x13,FALSE);
    if (r.h.ah != 0 || r.x.cflag != 0)
      {
        puts(_s0);
        puts("ERROR: Error writing partition table of Fixed Disk Drive 0.");
        puts(_s0);
        puts(_s2);
        puts(_s5);
        puts(_s6);
        exit(3);
      }
    else
      puts("Done.");
    puts("Verifying new master boot record...");
    r.h.ah = 0x04;                 // BIOS Int 13, function 4 (Verify Sector)
    r.h.al = 0x01;                 // Sectors to verify
    r.h.cl = 0x01;                 // Sector #
    r.h.ch = 0x00;                 // Cylinder #
    r.h.dl = 0x80;                 // Drive #  (1st HD = 0x80)
    r.h.dh = 0x00;                 // Head #
    r.x.bx = FP_OFF(&bs);
    sr.es = FP_SEG(&bs);
    bios_call(0x13,FALSE);
    if (r.h.ah != 0 || r.x.cflag != 0)
      {
        puts(_s0);
        puts("ERROR: Error verifying master boot record of Fixed Disk Drive 0.");
        puts(_s0);
        puts(_s5);
        puts(_s6);
        exit(3);
      }
    else
      puts("Verified.\r\n");
    puts(_s1);
	 exit(0);
  }  // End of main()

void bios_call(const UINT intr, const BOOL debug = FALSE)
  {
    if (debug == TRUE)
      {
	     printf("AH=%x,AL=%x,CL=%x,CH=%x,DH=%x,DL=%x\n\r",r.h.ah,r.h.al,r.h.cl,
		      r.h.ch,r.h.dh,r.h.dl);
	     printf("ES=%x,DS=%x,BX=%x\n\r",sr.es,sr.ds,r.x.bx);
      }
	 int86x(intr,&r,&r,&sr);
    if (debug == TRUE)
      {
	     printf("CF=%x,AH=%x,AL=%x\n\r",r.x.cflag,r.h.ah,r.h.al);
      }
  }  // End of bios_call()

//===========================================================================
//                     End of Program Source Code
//===========================================================================

