        PROGRAM NJTREE
c$LARGE
c------------------------------------------------------------------------
c                  Neighbor-joining Method (v2.0)
c------------------------------------------------------------------------
c   Reference: Saitou, N. and M., Nei. 1987. The Neighbor-joining Method:
c                   A New Method for Reconstructing Phylogenetic Trees. 
c                   Mol. Biol. Evol. 4: 406-425
c              Studier, J. and K., Keppler. 1988.  A Note on the Neighbor-
c                   joining Algorithm of Saitou and Nei. 5:729-731.
c   Language:  Fortran77
c   Version:   The progrom was originally written by N. Saitou (v1.0), and
c              was revised by L. Jin in Jan. 1989. (v2.0)
c------------------------------------------------------------------------
c       Minor modification to cater for up to 150 notu's and output to
c       indicate progress in the analysis   John Armstrong RSBS 1993
C       Modified for standard input file of NJT.IN for batch use Mar 1994
c-----------------------------------------------------------------
      parameter (maxnotu=150)
       dimension d(maxnotu,maxnotu),av(maxnotu)
c      dimension s(150,150)            This array is not used
      integer kill(maxnotu),l(3)
      character*4 type(3),typei,typej
      character*20 otuname(maxnotu)
      character*30 fname
        L5=5

      open(unit=6,file='NJTREE.OUT ',status='new')
C      write(*,7)
C    7 format(/,' File name of distance data ',/,
C     &         '  ( No correction will be made by this program ) ')
C      read(*,'(A)') fname
      open(unit=3,file='NJT.IN',status='old')

      notu=0
   10 read(3,'(A)') fname
      if(fname(1:1).eq.'*') goto 10
      do 9 i=1,20
         if(notu.ne.0) goto 8
         if(notu.eq.0.and.fname(i:i).ne.' ') goto 8
    9 continue
      goto 10
    8 notu=notu+1
      do 11 i=1,20
         if(fname(i:i).eq.' ') then
            goto 11
         else
            otuname(notu)=fname(i:20)
            goto 10
         end if
   11 continue
      notu=notu-1
      fotu=float(notu)

      do 12 i=1,notu
         write(6,900) otuname(i),i
12    continue
900   format(A20,' - ',i3)

      read(3,*) ((d(i,j),j=i+1,notu),i=1,notu-1)

c ******* first initialization **************

      nc=1
      mini=0
      minj=0

      do 40 i=1,notu
         d(i,i)=0.0
         kill(i)=0
         av(i)=0.0
   40 continue

      write(6,1000) 
      call mat(notu,d,kill)
      write(6,1300)

c ******** enter the main cycle ****************

      do 150 nc=1,notu-3

         do 60 j=2,notu
            do 50 i=1,j-1
               d(j,i)=d(i,j)
c               s(i,j)=0.0
c               s(j,i)=0.0
   50       continue
   60    continue

         tmin=99999.0

c ******** compute sij values and find the smallest one. ********

         do 90 jj=2,notu
            if(kill(jj).eq.1) goto 90
            do 80 ii=1,jj-1
               if(kill(ii).eq.1) goto 80
               diq=0.0
               djq=0.0
               do 70 i=1,notu
                  diq=diq+d(i,ii)
   70             djq=djq+d(i,jj)
               dij=d(ii,jj)
               fotu2=fotu-2.0
               total=fotu2*dij-diq-djq
c              s(ii,jj)=total
               if(total.lt.tmin) then
                  tmin=total
                  mini=ii
                  minj=jj
               end if
   80       continue
   90    continue

c ********** compute branch lengths and print the results. **********

         dio=0.0
         djo=0.0
         do 100 i=1,notu
            dio=dio+d(i,mini)
  100       djo=djo+d(i,minj)
         dmin=d(mini,minj)
         dio=(dio-dmin)/fotu2
         djo=(djo-dmin)/fotu2
         bi=(dmin+dio-djo)*0.5
         bj=dmin-bi
         bi=bi-av(mini)
         bj=bj-av(minj)

         if(av(mini).gt.0.0) then
            typei='NODE'
         else
            typei='OTU'
         end if

         if(av(minj).gt.0.0) then
            typej='NODE'
         else
            typej='OTU'
         end if
         write(6,1500) nc,typei,mini,bi,typej,minj,bj
         av(mini)=dmin*0.5

c ********** re-initialization **********************

         fotu=fotu-1.0
         kill(minj)=1

         do 130 j=1,notu
            if(kill(j).eq.1) goto 130
            da=(d(mini,j)+d(minj,j))*0.5
            if(mini-j) 110,130,120
  110          d(mini,j)=da
               goto 130
  120          d(j,mini)=da
  130    continue

         do 140 j=1,notu
            d(minj,j)=0.0
  140          d(j,minj)=0.0

  150 continue

c ********** the last cycle( 3 otus only ) **************

      nude=1
      do 160 i=1,notu
         if(kill(i).eq.1) goto 160
         l(nude)=i
         nude=nude+1
  160 continue

      b1=(d(l(1),l(2))+d(l(1),l(3))-d(l(2),l(3)))*0.5
      b2=d(l(1),l(2))-b1
      b3=d(l(1),l(3))-b1
      b1=b1-av(l(1))
      b2=b2-av(l(2))
      b3=b3-av(l(3))

      do 170 i=1,3
         if(av(l(i)).gt.0.0) then
         type(i)='NODE'
      else
         type(i)='OTU'
      end if
  170 continue
      write(6,1700) type(1),l(1),b1,type(2),l(2),b2,type(3),l(3),b3

c *********** format statements ******************

 1000 format(//' DISTANCE MATRIX'/)
 1100 format(i3,2x,(10f8.3))
c 1100 format(i3,2x,(10f8.4))
 1200 format((7x,10(i3,5x)))
 1300 format(/,'NEIGHBOR-JOINING METHOD'/)
 1500 format('CYCLE ',i2,5x,a4,1x,i3,' ( ',f10.3,')',
     1 '   AND     ',a4,1x,i3,'(',f10.3,')')
 1700 format('LAST CYCLE',/,3(a4,1x,i3, '(',f10.3,')',5x))
c 1500 format('CYCLE ',i2,5x,a4,1x,i3,' ( ',f10.5,')',
c     1 '   AND     ',a4,1x,i3,'(',f10.5,')')
c 1700 format('LAST CYCLE',/,3(a4,1x,i3, '(',f10.6,')',5x))

      stop
      end

c ******** subroutine for printing with a matrix form ************

      subroutine mat(n,d,kill)

c      parameter (maxnotu=100)
      dimension d(150,150)
      integer kill(150)

      n1=n-1
      kaisu=n1/10+1
      joyo=mod(n1,10)
      if(joyo.eq.0) kaisu=kaisu-1
      iend=0
      jend=1

      do 20 k=1,kaisu
         ista=iend+1
         iend=ista+9
         if(n1.lt.iend) iend=n1
         jsta=jend+1
         jend=iend+1
         do 10 j=jsta,n
            j1=j-1
            if(j1.gt.iend) j1=iend
            if(kill(j).eq.1) goto 10
            write(6,1000) j,(d(i,j),i=ista,j1)
   10    continue
         write(6,1100) (i,i=ista,iend)
   20 continue

 1000 format(i3,2x,(10f8.4))
 1100 format((7x,10(i3,5x)))

      return
      end




