'
'
'   --- please read this ! ---
'
'  This source code is in "shrouded" form. It is distributed in this form
'  rather than as an object (.OBJ) file.
'
'  You can compile this code, but you will have to register with us in order
'  to get the normal (commented) PowerBASIC source code with normal variable
'  names.
'' si.c  (script interpreter)

$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFWRD A-Z

$INCLUDE "PUTGET.BI"
$INCLUDE "TERM_IO.BI"
$INCLUDE "MODEM_IO.BI"
$INCLUDE "XYMODEM.BI"
$INCLUDE "ZMODEM.BI"
$INCLUDE "OPCODES.BI"
$INCLUDE "SI.BI"
$INCLUDE "PCL4PB.BI"

%MARK = &H55
%ESC  = &H1B

%False = 0
%True = NOT %False

%CODE.SIZE = 1024
%DATA.SIZE = 1024
%STACK.SIZE  = 32

%BUFBLK.SIZE = 1024

DIM V43 AS SHARED INTEGER     ' current version of script language
DIM V5 AS SHARED BYTE       ' checksum
DIM V8 AS SHARED INTEGER      ' code program counter
DIM V13 AS SHARED INTEGER      ' data program counter
DIM V38 AS SHARED INTEGER    ' stack top
DIM V25 AS SHARED BYTE        ' every data ref instruction sets pgm char
DIM V26 AS SHARED INTEGER    ' counter (used by LOOP)
DIM V29 AS SHARED INTEGER     ' wait in tics for string in <WaitFor()>
DIM V27 AS SHARED INTEGER     ' SendTo inter-char pace (tics)
DIM V24 AS SHARED INTEGER     ' %True  WAITFOR case sensitive
DIM V28 AS SHARED BYTE    ' X (Xmodem), Y (YMODEM), Z (ZMODEM)
DIM V3 AS SHARED INTEGER  ' binary object file
DIM V16 AS SHARED STRING     ' object filename
DIM V6(%CODE.SIZE) AS SHARED BYTE     ' code area
DIM V10(%DATA.SIZE) AS SHARED BYTE     ' data area
DIM V37(%STACK.SIZE) AS SHARED BYTE   ' stack area
DIM V2 AS SHARED INTEGER
DIM V23 AS SHARED INTEGER
DIM V11 AS SHARED INTEGER
DIM V39 AS SHARED INTEGER
DIM V15(10) AS SHARED INTEGER
DIM V4(%BUFBLK.SIZE) AS SHARED BYTE
DIM V40 AS SHARED INTEGER
DIM V41 AS SHARED STRING

SUB InitSi
V43 = 2
V5 = 0
V8 = 0
V13 = 0
V38 = 0
V26 = 1
V29 = 540
V27 = 5
V24 = %True
V28 = ASC("X")
V15(0) = &H180
V15(1) = &H0C0
V15(2) = &H060
V15(3) = &H030
V15(4) = &H018
V15(5) = &H00C
V15(6) = &H006
V15(7) = &H003
V15(8) = &H002
V15(9) = &H001
END SUB


SUB SaySiErr(BYVAL Code AS INTEGER) PUBLIC
SELECT CASE Code
    CASE  %SI.CANNOT.OPEN
      WriteMsg("Cannot open script binary")
    CASE  %SI.UNEXPECTED.EOF
      WriteMsg("Unexpected EOF")
    CASE  %SI.NOT.SCRIPT.BINARY
      WriteMsg("Not script binary")
    CASE  %SI.NOT.CURRENT.VERSION
      WriteMsg("Incorrect script version")
    CASE  %SI.CODE.LENGTH.OVERFLOW
      WriteMsg("Code overflow")
    CASE  %SI.DATA.LENGTH.OVERFLOW
      WriteMsg("Data overflow")
    CASE  %SI.BAD.OPCODE
      WriteMsg("Bad opcode encountered")
    CASE  %SI.USER.ABORTS
      WriteMsg("User aborting...")
    CASE  %SI.STACK.OVERFLOW
      WriteMsg("Stack overflow")
    CASE  %SI.STACK.UNDERFLOW
      WriteMsg("Stack underflow")
    CASE  %SI.BAD.CHECKSUM
      WriteMsg("Bad checksum")
    CASE ELSE
      V41 = "Script error " + STR$(Code)
      WriteMsg(V41)
END SELECT
END SUB

FUNCTION V18 AS BYTE
DIM I AS INTEGER
DIM K AS INTEGER
DIM B AS BYTE
ON LOCAL ERROR GOTO GetByteTrap
  GET V3, ,B
  V5  = V5 XOR B
  V18 = B
GetByteTrap.Exit:
  EXIT FUNCTION

GetByteTrap:
  SELECT CASE ERR
    CASE ELSE
      PRINT "GetScriptByte Error: "; ERR
    END SELECT
    V18 = %SI.UNEXPECTED.EOF
    RESUME GetByteTrap.Exit
END FUNCTION


FUNCTION V33(BYVAL Item AS INTEGER) AS INTEGER
V37(V38) = Item
V38 = V38 + 1
IF V38 = %STACK.SIZE THEN
  V33 = %SI.STACK.OVERFLOW
  EXIT FUNCTION
END IF
V33 = 0
END FUNCTION

FUNCTION V30 AS INTEGER
IF V38  = 0 THEN
   V30 = %SI.STACK.UNDERFLOW
   EXIT FUNCTION
END IF
V38 = V38 - 1
V30 = V37(V38)
END FUNCTION

FUNCTION V36(BYVAL Flag AS INTEGER) AS BYTE
DIM C AS BYTE
IF Flag THEN
  V36 = ASC("T")
ELSE
  V36 = ASC("F")
END IF
END FUNCTION


FUNCTION V17(BYVAL V14 AS INTEGER) AS INTEGER
DIM I AS INTEGER
FOR I = 0 TO 9
  IF V14=V15(I) THEN
    V17 = I
    EXIT FUNCTION
  END IF
  V17 = -1
NEXT I
END FUNCTION

FUNCTION Extract(BYVAL V1 AS INTEGER) PRIVATE AS STRING
DIM I AS INTEGER
DIM C AS BYTE
DIM TheString AS STRING
TheString = ""
FOR I = V1 TO %DATA.SIZE
   C = V10(I)
   IF C = 0 THEN
     Extract = TheString
     EXIT FUNCTION
   END IF
   TheString = TheString + CHR$(C)
NEXT I
Extract = TheString
END FUNCTION

' script interpreter

FUNCTION Script(BYVAL Port AS INTEGER, _
                BYVAL TheFile AS STRING, _
                BYVAL Debug AS INTEGER) PUBLIC AS INTEGER
DIM I AS INTEGER
DIM K AS INTEGER
DIM RC AS INTEGER
DIM C AS BYTE
DIM V32 AS STRING
DIM V21 AS INTEGER  ' operation code
DIM V22 AS INTEGER    ' shifted address page
DIM V1 AS INTEGER    ' code address or data address
DIM V7 AS INTEGER    ' # bytes of code
DIM V12 AS INTEGER    ' # bytes of data
DIM V9 AS INTEGER
DIM V31 AS INTEGER
DIM V19 AS INTEGER
DIM V34 AS BYTE
DIM V14 AS INTEGER
DIM NCGchar AS BYTE
DIM AnyKey AS STRING
ON LOCAL ERROR GOTO SiTrap
 ' init
 IF Debug THEN
   PRINT "Script ='";TheFile;"''
   CALL ModemDebug(%True)
 END IF
 CALL InitSi
 V34 = &H22
 NCGchar = ASC("C")
 ' get parms
 V14 = SioGetDiv(Port)
 V2 = V17(V14)
 V31 = SioRead(Port,3)
 V11 = &H03 AND V31
 V39 = &H01 AND (V31 \ 4)
 V23 = &H07 AND (V31 \ 8)
 ' can ZMODEM stream ?
 IF V2 <= %Baud19200 THEN
    V40 = %True
 ELSE
    V40 = %False
 END IF
 ' initialize
 FOR I=0 TO %CODE.SIZE-1
    V6(I) = %OPC.HALT
 NEXT I
 FOR I = 0 TO %DATA.SIZE - 1
    V10(I) = 0
 NEXT I
 V5 = 0
 V8 = 0
 V13 = 0
 V38 = 0
 V25 = %True
 V26 = 1
 ' construct filename
 V16 = TheFile + ".sb"
 ' open binary
 V3 = FREEFILE
 OPEN V16 FOR BINARY ACCESS READ AS V3
 ' read marker
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 IF RC <> %MARK THEN
    Script = %SI.NOT.SCRIPT.BINARY
    EXIT FUNCTION
 END IF
 ' read version number
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 IF RC <> V43 THEN
    Script = %SI.NOT.CURRENT.VERSION
 END IF
 ' read code length
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 V7 = &H00FF AND RC
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 V7 = 256*V7 + (&H00FF AND RC)
 IF Debug THEN
    PRINT "Code = ";V7;" bytes."
 END IF
 IF V7 >= %CODE.SIZE THEN
    Script = %SI.CODE.LENGTH.OVERFLOW
 END IF
 ' read data length
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 V12 = &H00FF AND RC
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 V12 = 256*V12 + (&H00FF AND RC)
 IF Debug THEN
    PRINT "Data = ";V12;" bytes."
 END IF
 IF V12 >= %DATA.SIZE THEN
    Script = %SI.DATA.LENGTH.OVERFLOW
    EXIT FUNCTION
 END IF
 ' read in code
 FOR I = 0 TO V7-1
   RC = V18
   IF RC < 0 THEN
      Script = RC
      EXIT FUNCTION
   END IF
   V6(V8) = RC
   V8 = V8 + 1
 NEXT I
 ' read marker
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 IF RC <> %MARK THEN
    Script = %SI.NOT.SCRIPT.BINARY
    EXIT FUNCTION
 END IF
 ' read in data
 FOR I=0 TO V12-1
   RC = V18
   IF RC < 0 THEN
      Script = RC
      EXIT FUNCTION
   END IF
   V10(V13) = RC
   V13 = V13 + 1
 NEXT I
 ' read marker
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 IF RC <> %MARK THEN
    Script = %SI.NOT.SCRIPT.BINARY
 END IF
 ' read checksum byte
 V9 = V5
 RC = V18
 IF RC < 0 THEN
    Script = RC
    EXIT FUNCTION
 END IF
 IF RC <> V9 THEN
    Script = %SI.BAD.CHECKSUM
    EXIT FUNCTION
 END IF
 ' ready to run !
 V8 = 0
 DO
    AnyKey = INKEY$
    IF AnyKey <> "" THEN
      C = ASC(AnyKey)
      IF C = %ESC THEN
         Script = %SI.USER.ABORTS
         EXIT FUNCTION
      ELSE
         RC = CharPut(Port,C)
      END IF
    END IF
    ' extract opcode & (shifted) page
    K = V6(V8)
    V8 = V8 + 1
    V21 = &H003F AND K
    V22 = &H00C0 AND K
    SHIFT LEFT V22, 2
    IF Debug THEN
       V19 = MatchOpCode(V21)
       V41 = "@" + STR$(V8) + GetOpText(V19)
       WriteMsg(V41)
    END IF
    ' compute operand address if %CODE.REF or %DATA.REF instruction
    IF V21 >= 8 THEN
       V1 = V22 OR (&H00FF AND V6(V8))
       V8 = V8 + 1
       IF Debug THEN
         SELECT CASE GetOperType(V19)
           CASE %CODE.REF
              V41 = STR$(V1) + " )"
              WriteMsg(V41)
            CASE %DATA.REF
              V41 = CHR$(V34) + Extract(V1) + CHR$(V34)
              WriteMsg(V41)
            END SELECT
       END IF
    END IF
    ' execute next command
    SELECT CASE V21
      CASE %OPC.HALT
        Script = 0
        EXIT FUNCTION

      CASE %OPC.STATUS
        PRINT "PgmChar=";CHR$(V25);" (&H";HEX$(V25);"), V29=";STR$(V29);
        PRINT ", V24=";V36(V24);" ,V27=";STR$(V27)

      CASE %OPC.DELAY
        V41 = Extract(V1)
        RC = SioDelay( 18 * VAL(V41) )

      CASE %OPC.CALL
        RC = V33(V8)
        IF RC < 0 THEN
          Script = RC
          EXIT FUNCTION
        END IF
        V8 = V1

      CASE %OPC.RETURN
        RC = V30
        IF RC < 0 THEN
           Script = RC
           EXIT FUNCTION
        END IF
        V8 = RC

      CASE %OPC.BAUD
        I = MatchBaud(Extract(V1))
        IF V2 = -1 THEN
           V25 = %False
        ELSE
           V2 = I
           RC = SioBaud(Port,V2)
           V25 = %True
        END IF

      CASE %OPC.DATABITS
        I = VAL(Extract(V1))
        V25 = %True
        SELECT CASE I
           CASE 7
             V11 = %WordLength7
           CASE 8
             V11 = %WordLength8
           CASE ELSE
             V25 = %False
        END SELECT
        IF V25 THEN
           RC = SioParms(Port,V23,V39,V11)
        END IF

      CASE %OPC.STOPBITS
        I =  VAL(Extract(V1))
        V25 = %True
        SELECT CASE(I)
           CASE 1
             V39 = %OneStopBit
           CASE 2
             V39 = %TwoStopBits
           CASE ELSE
             V25 = %False
        END SELECT
        IF V25 THEN
           RC = SioParms(Port,V23,V39,V11)
        END IF
      CASE %OPC.PARITY
        C = V10(V1)
        V25 = %True
        SELECT CASE (STR$(C))
           CASE "N"
             V23 = %NoParity
           CASE "E"
             V23 = %EvenParity
           CASE "O"
             V23 = %OddParity
           CASE ELSE
             V25 = %False
        END SELECT
        IF V25 THEN
           RC = SioParms(Port,V23,V39,V11)
        END IF

      CASE %OPC.REPLY
        RC = ModemSendTo(Port,V27,Extract(V1))

      CASE %OPC.SETCOUNT
        V26 = VAL(Extract(V1))

      CASE %OPC.SETWAIT
        V29 =  (18 * VAL(Extract(V1)))

      CASE %OPC.LOOP
        V26 = V26 - 1
        IF V26 > 0 THEN V8 = V1

      CASE %OPC.IFTRUE
        IF V25 THEN V8 = V1

      CASE %OPC.IFFALSE
        IF V25 = 0 THEN V8 = V1

      CASE %OPC.IF
        IF V25 <> V10(V1) THEN V8 = V8 + 2

      CASE %OPC.IFNOT
        IF V25 = V10(V1) THEN V8 = V8 + 2

      CASE %OPC.GOTO
        V8 = V1

      CASE %OPC.TEST
        V25 = V10(V1)

      CASE %OPC.ACCEPT    ' max area 15 ?
        CALL ReadMsg(V41,1,15)
        FOR I = 1 TO LEN(V41)
           V10(V1+I-1) = ASC(MID$(V41,I,1))
        NEXT I


      CASE %OPC.SAY
        V32 = Extract(V1)
        I = 1
        DO
          C = ASC(MID$(V32,I,1))
          I = I + 1
          IF C = ASC("^") THEN
             C = ASC(MID$(V32,I,1)) - &H20
             I = I + 1
             IF C = 10 THEN
               PRINT
             END IF
          ELSE
             PRINT CHR$(C);
          END IF
        LOOP WHILE I <= LEN(V32)
        PRINT

      CASE %OPC.WAITFOR
        V25 = ModemWaitFor(Port,V29,V24,Extract(V1))

      CASE %OPC.NOP

      CASE %OPC.DEBUG
        '''ModemDebug

      CASE %OPC.SETPACE
        V27 = (18 * VAL(Extract(V1)))

      CASE %OPC.SETCASE
        C = ASC(UCASE$(CHR$(V10(V1))))
        IF C = ASC("T") THEN V24 = %True
        IF C = ASC("F") THEN V24 = %False

      CASE %OPC.QUIET
        RC = ModemQuiet(Port, (18 * VAL(Extract(V1))) )

      CASE %OPC.HANGUP
        RC = ModemHangup(Port)

      CASE %OPC.PROTOCOL
        C = ASC(UCASE$(CHR$(V10(V1))))
        IF C = ASC("A") THEN V28 = ASC("A")
        IF C = ASC("X") THEN V28 = ASC("X")
        IF C = ASC("Y") THEN V28 = ASC("Y")
        IF C = ASC("Z") THEN V28 = ASC("Z")

      CASE %OPC.SEND
        IF CHR$(V28) <> "A" THEN
           RC = ModemEcho(Port,10)
        END IF
        SELECT CASE CHR$(V28)
           CASE "A"
             ' start ASCII send
           CASE "X"
             ' start XMODEM send
             RC = XmodemTx(Port,Extract(V1),%False)
           CASE "Y"
             ' start YMODEM send
             RC = YmodemTx(Port,Extract(V1),%True)
           CASE "Z"
             ' start ZMODEM send
             RC = ZmodemTx(Port,V16,V40)
        END SELECT

      CASE %OPC.RECEIVE
        IF CHR$(V28) <> "A" THEN
            RC = ModemEcho(Port,10)
        END IF
        SELECT CASE CHR$(V28)
            CASE "A"
               ' start ASCII receive
            CASE "X"
               ' start XMODEM receive
               RC = XmodemRx(Port,Extract(V1),NCGchar)
            CASE "Y"
               ' start YMODEM receive
               V41 = ""
               RC = YmodemRx(Port,V41,NCGchar)
            CASE "Z"
               ' start ZMODEM receive
               RC = ZmodemRx(Port,V40)
        END SELECT
        RC = ModemSendTo(Port,V27,"!")

      CASE %OPC.USER1
      CASE %OPC.USER2
      CASE %OPC.USER3
      CASE %OPC.USER4
      CASE %OPC.USER5
      CASE %OPC.USER6
      CASE %OPC.USER7
      CASE %OPC.USER8

     END SELECT
   LOOP

Si.Exit:
   EXIT FUNCTION

SiTrap:
  SELECT CASE ERR
    CASE ELSE
      PRINT "Si Error: "; ERR
    END SELECT
    Script = %SI.UNEXPECTED.EOF
    RESUME Si.Exit
END FUNCTION
