' -- PROCESS.BAS --
'
' This program is donated to the Public
' Domain by MarshallSoft Computing, Inc.
' It is provided as an example of the use
' of the Personal Communications Library.
'
$CPU 8086          'make compatible with XT systems
$LIB ALL OFF       'turn off all PowerBASIC libraries
$ERROR ALL OFF     'turn off all PowerBASIC error checking
$OPTIMIZE SIZE     'optimize for smaller code
$COMPILE UNIT      'compile to a UNIT (.PBU)

DEFINT A-Z

$INCLUDE "TERM_IO.BI"
$INCLUDE "XYMODEM.BI"
$INCLUDE "ZMODEM.BI"
$INCLUDE "PCL4PB.BI"

%FALSE = 0
%TRUE = NOT %FALSE
%NAK = &H15

DIM ThePort AS SHARED INTEGER
DIM Protocol AS SHARED STRING
DIM OneKflag AS SHARED INTEGER
DIM NCGbyte AS SHARED BYTE
DIM BatchFlag AS SHARED INTEGER
DIM BaudCode AS SHARED INTEGER
DIM BaudRate AS SHARED STRING
DIM Streaming AS SHARED INTEGER
DIM EchoFlag AS SHARED INTEGER

SUB InitProcess(BYVAL Port AS INTEGER, _
                      Rate AS STRING, _
                      Code AS INTEGER) PUBLIC
  ThePort = Port
  BaudRate = Rate
  BaudCode = Code
  Protocol = "X"
  OneKflag = %FALSE
  NCGbyte = %NAK
  BatchFlag = %FALSE
  EchoFlag = 0

END SUB

SUB ShowStatus(Message AS STRING) PUBLIC

  DIM P AS STRING
  DIM Temp AS STRING

  P$ = STR$(1+ThePort)
  Temp$ = "COM" + RIGHT$(P$,LEN(P$)-1) + " " + BaudRate$ + " " _
          + Protocol + " [ " + Message + " ]"
  CALL WriteColMsg(Temp,1)

END SUB

FUNCTION Process PUBLIC

  DIM Flag AS INTEGER
  DIM GetNameMsg AS STRING
  DIM CmdChar AS STRING
  DIM ResultMsg AS STRING
  DIM P AS STRING
  DIM Filename AS STRING

  Process = %FALSE

  'quit if user types ^Z

  CALL WriteColMsg("Q)uit P)rotocol S)end R)eceive T)race: ",41)
  CALL ReadMsg(ResultMsg$, 79, 1)

  CmdChar$ = UCASE$(LEFT$(ResultMsg$, 1))

  SELECT CASE CmdChar$
    CASE "Q"   'QUIT
      Process = %TRUE
      EXIT FUNCTION
    CASE "T"   'TRACE
      EchoFlag = 1 - EchoFlag
      PRINT "Trace=";EchoFlag
      CALL MsgEcho(EchoFlag)
    CASE "P"   'PROTOCOL
      CALL WriteColMsg("X)modem Y)modem Z)modem: ",45)
      CALL ReadMsg(ResultMsg$, 69, 1)
      P$ = UCASE$(LEFT$(ResultMsg$, 1))
      SELECT CASE P$
        CASE "X"  'XMODEM
          Protocol = "X"
          OneKflag = %FALSE
          NCGbyte = %NAK
          BatchFlag = %FALSE
          CALL WriteColMsg(" Protocol = XMODEM  ",45)
        CASE "Y"  'YMODEM
          Protocol = "Y"
          OneKflag = %TRUE
          NCGbyte = ASC("C")
          BatchFlag = %TRUE
          CALL WriteColMsg(" Protocol = YMODEM  ",45)
        CASE "Z"  'ZMODEM
          IF BaudCode <= %Baud19200 THEN
             Streaming = %True
          ELSE
             Streaming = %False
          END IF
          Protocol = "Z"
          CALL ZmodemDebug(1)
          CALL WriteColMsg(" Protocol = ZMODEM  ",45)
      END SELECT
    CASE "R"  'Receive
      ShowStatus("^X aborts")
      Filename = ""
      SELECT CASE Protocol
        CASE "X"
           Flag = XmodemRx(ThePort, Filename, NCGbyte)
        CASE "Y"
           Flag = YmodemRx(ThePort, Filename, NCGbyte)
        CASE "Z"
           Flag = ZmodemRx(ThePort, Streaming)
      END SELECT
    CASE "S"  'Send
      ShowStatus("^X aborts")
      Filename = ""
      SELECT CASE Protocol
        CASE "X"
           Flag = XmodemTx(ThePort, Filename, OneKflag)
        CASE "Y"
           Flag = YmodemTx(ThePort, Filename, OneKflag)
        CASE "Z"
           Flag = ZmodemTx(ThePort, Filename, Streaming)
      END SELECT
    CASE ELSE
      CALL WriteMsg("Bad response")
   END SELECT
   ShowStatus("^Z for Menu")

END FUNCTION




