/****************************************************************

	ui_clock.c      Clock routines for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "time.h"
#include "gr.h"
#include "ui.h"

#ifdef  __STDC__
#include "stdlib.h"
#else
#define time_t  long
extern char *getenv();
#endif

/* #define      USESMALLFONT    */

int cl_initialized = FALSE;
static int cl_x, cl_y, cl_fore, cl_back;
static char clock_buf[ 36 ];
static char env_buf[ 48 ];
static int last_time;

ui_clinit( x, y, fore, back )
	int x, y, fore, back;
	{
	static time_t now;
	struct tm *clock_time;
	register int c;

	time( &now );
	clock_time = localtime( &now );

	if ( getenv( "TZ" ) == NULL )
		{
		strcpy( env_buf, "LOC" );
		}
	else
		{
		strcpy( env_buf, getenv( "TZ" ) );
		}

	if ( clock_time->tm_isdst == 0 )
		{
		env_buf[ 3 ] = 0;
		}
	else
		{
		for ( c = 0; c < 4; ++c )
			{
			env_buf[ c ] = env_buf[ c + 4 ];
			}
		}

	cl_x = x;
	cl_y = y;
	cl_fore = fore;
	cl_back = back;
	cl_initialized = TRUE;
	}

ui_clock()
	{
	static time_t now;
#ifdef  USESMALLFONT
	int save_fysize, save_font;
#endif
	struct tm *clock_time;

	if ( cl_initialized == FALSE )
		{
		return FALSE;
		}

	time( &now );
	clock_time = localtime( &now );

	if ( clock_time->tm_min == last_time )
		{
		return TRUE;
		}

#ifdef  USESMALLFONT
	save_fysize = ui_grwind->fysize;
	save_font   = ui_grwind->font;
	gr_font( ui_screen, save_font, save_fysize * 4 );
#endif

	last_time = clock_time->tm_min;
	sprintf( clock_buf, "%02d:%02d %s",
		clock_time->tm_hour, clock_time->tm_min, env_buf );
	gr_text( ui_screen, cl_x,
		cl_y, clock_buf, cl_fore, cl_back );

#ifdef  USESMALLFONT
	gr_font( ui_screen, save_font, save_fysize );
#endif

	}

ui_clforce()
	{
	last_time = 63;
	ui_clock();
	}
