/****************************************************************

	gr_spec.c	Specification of Graphics Interface 
			for Space Flight Simulator

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

	This file specifies the interface for graphics and mouse 
	handling utilized in the Space Flight Simulator.  This file
	may be utilized as the basis for implementations of gr and 
	thus of sfs on varied computers.  If you can implement the
	functions specified in this file, sfs should be implemented.

	COORDINATE SYSTEM. The gr interface presupposes throughout
	a Cartesian coordinate system in which pixels on the vertical
	axis (the y axis) are numbered beginning with 0 from the
	bottom up, and pixels on the horizontal axis (the x axis)
	are numbered beginning with 0 from the ;eft to the right.
	The numbering of the y axis may seem counterintuitive,
	since in many systems pixels are numbered vertically from
	the top to the bottom.

****************************************************************/

#include "stdio.h"
#include "gr.h"

int     gr_colors;      /* number of colors available */
int     gr_pxsize;      /* relative size of pixel, horizontal */
int     gr_pysize;      /* relative size of pixel, vertical */
int     gr_ismouse;     /* boolean -- does mouse exist? */
int     gr_clipping;    /* boolean -- is clipping implemented? */
int     gr_blitting;    /* boolean -- is blitting implemented? */
int     gr_saving;      /* boolean -- is screen saving implemented? */
int     gr_screens;     /* number of screens, 1 = visible screen
			   (GR_PRIMARY) only, 2 = visible and
			   hidden screen (GR_PRIMARY and GR_HIDDEN)
			   are available */

/****************************************************************

   gr_init()

   This function should initialize the entire graphics and mouse
   subsystem. The argument "grwindow" is a pointer to a gr_window
   structure which should be filled in by the function. The
   argument "font_path" is a pointer to a character string
   giving the name of a path where the function should look
   for font and other data files. The function should return
   BW_ERROR upon any error and TRUE upon a successful setting
   of the graphics subsystem.

****************************************************************/

gr_init( grwindow, font_path )
   struct gr_window *grwindow;
   char * font_path;
   {
   }

/****************************************************************

   gr_deinit()

   This function should deinitialize the entire graphics subsystem.

****************************************************************/

gr_deinit()
   {
   }

/****************************************************************

   gr_cls()

   This function should clear the entire screen area.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

****************************************************************/

gr_cls( screen )
   int screen;
   {
   }


/****************************************************************

   gr_pixel()

   This function turns on (or off, if the color is BLACK) a single
   pixel on the display.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x and y specify a pixel location on the screen
   in gr coordinates (see above on the coordinate system) where
   the pixel is to be located, x on the horizontal axis and y
   on the vertical axis.

   The argument "color" is an integer denoting a color defined
   in the header "gr.h".

****************************************************************/

gr_pixel( screen, x, y, color )
   int screen;
   int x, y;
   int color;
   {
   }
         
/****************************************************************

   gr_line()

   This function draws a line on the designated screen from
   point x1, y1 to point x2, y2 in a specified color and
   with a specified style.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x1, y1, x2, and y2 specify two pixel locations
   on the screen in gr coordinates (see above on the coordinate
   system) denoting the source (x1, y1) and destination (x2, y2)
   points for the line (x1 and x2 on the horizontal axis, and y1
   and y2 on the vertical axis.

   The argument "color" is an integer denoting a color defined
   in the header "gr.h".

   The argument "style" is an integer denoting a line style
   defined in "gr.h" (HOLLOW, SOLID, GRID, or HATCH -- GRID
   and HATCH denote dotted lines, and HOLLOW erases the area
   of the line).

****************************************************************/

gr_line( screen, x1, y1, x2, y2, color, style )
   int screen;
   int x1, y1, x2, y2;
   int color, style;
   {
   }

/****************************************************************

   gr_text()

   This function addresses text to a specified location on the
   screen in specified colors.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x and y specify a pixel location on the screen
   in gr coordinates (see above on the coordinate system) where
   the bottom left corner of the text is to be located, x on the
   horizontal axis and y on the vertical axis.

   The argument "string" designates a pointer to a character
   string to be written to the screen.

   The arguments "foreground" and "background" are integers
   denoting text foreground and background colors as defined
   in the header "gr.h".

****************************************************************/

gr_text( screen, x, y, string, foreground, background )
   int screen;
   int x, y;
   int foreground, background;
   char *string;
   {
   }

/****************************************************************

   gr_strlen()

   This function returns the length in pixels on the horizontal
   (x) axis of a specified character string.

   The argument "string" designates a pointer to a character
   string whose horizontal size is to be calculated.

****************************************************************/

unsigned int
gr_strlen( string )
   char *string;
   {
   }

/****************************************************************

   gr_rectangle()

   This function draws and possibly fills in (or blanks) a
   rectangular area of the screen.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x1, y1, x2, and y2 specify two pixel locations
   on the screen in gr coordinates (see above on the coordinate
   system) denoting the bottom left corner (x1, y1) and top right
   corner (x2, y2) of the rectangle (x1 and x2 on the horizontal
   axis, and y1 and y2 on the vertical axis).

   The argument "color" is an integer denoting a color defined
   in the header "gr.h".

   The argument "style" is an integer denoting a fill style
   defined in "gr.h" (HOLLOW, SOLID, GRID, or HATCH -- HOLLOW
   means that only a perimeter is drawn; SOLID means that the
   area is completely filled with the color, and GRID and HATCH
   represent varying degrees of partial fill, with GRID the finer
   and HATCH the rougher).

****************************************************************/

gr_rectangle( screen, x1, y1, x2, y2, color, style )
   int screen;
   int x1, y1, x2, y2;
   int color, style;
   {
   }

/****************************************************************

   gr_circle()

   This function draws and possibly fills in (or blanks) a
   circular area of the screen.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x and y specify a pixel location on the screen
   in gr coordinates (see above on the coordinate system) where
   the center of the circle is to be located, x on the horizontal
   axis and y on the vertical axis.

   The argument "radius" is an integer denoting the radius of the
   circle on the y (vertical) axis. Implementers should note that
   the x (horizontal) axis will have to be scaled.

   The argument "color" is an integer denoting a color defined
   in the header "gr.h".

   The argument "style" is an integer denoting a fill style
   defined in "gr.h" (HOLLOW, SOLID, GRID, or HATCH -- HOLLOW
   means that only a perimeter is drawn; SOLID means that the
   area is completely filled with the color, and GRID and HATCH
   represent varying degrees of partial fill, with GRID the finer
   and HATCH the rougher).

****************************************************************/

gr_circle( screen, x, y, radius, color, style )
   int screen;
   int x, y, radius;
   int color, style;
   {
   }

/****************************************************************

   gr_ellipse()

   This function is NOT CURRENTLY USED in any Bywater applications
   so it's here basically for future development.

   This function draws and possibly fills in (or blanks) an
   elliptical area of the screen.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x and y specify a pixel location on the screen
   in gr coordinates (see above on the coordinate system) where
   the center of the ellipse is to be located, x on the horizontal
   axis and y on the vertical axis.

   The arguments "x_radius" and "y_radius" specify the horizontal
   and vertical sizes, respectively, of the bounding rectangle
   of the ellipse.

   The argument "color" is an integer denoting a color defined
   in the header "gr.h".

   The argument "style" is an integer denoting a fill style
   defined in "gr.h" (HOLLOW, SOLID, GRID, or HATCH -- HOLLOW
   means that only a perimeter is drawn; SOLID means that the
   area is completely filled with the color, and GRID and HATCH
   represent varying degrees of partial fill, with GRID the finer
   and HATCH the rougher).

****************************************************************/

gr_ellipse( screen, x, y, x_radius, y_radius, mode, color, style )
   int screen;
   int x, y, x_radius, y_radius;
   int mode, color, style;
   {
   }
         
/****************************************************************

   gr_clip()

   If clipping is implemented (gr_clipping == TRUE), this
   function turns on or off clipping for a specified area
   of the screen.

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The argument "mode" is a boolean integer which tells whether
   clipping is to be turned on (TRUE) or off (FALSE).

   The arguments x1, y1, x2, and y2 specify two pixel locations
   on the screen in gr coordinates (see above on the coordinate
   system) denoting the bottom left corner (x1, y1) and top right
   corner (x2, y2) of the clipping rectangle (x1 and x2 on the
   horizontal axis, and y1 and y2 on the vertical axis).

****************************************************************/

gr_clip( screen, mode, x1, y1, x2, y2 )
   int screen;
   int mode;
   int x1, y1, x2, y2;
   {
   }

/****************************************************************

   gr_font()

   This function sets a font for future calls to gr_text().

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The argument "type" is an integer value (not currently
   implemented in applications by Bywater Software) which would
   denote a font type (these are defined in "gr.h" as F_DEFAULT,
   F_ROMAN, F_ITALIC, and F_GOTHIC). Don't worry about it.

   The argument "rq_height" is an integer value denoting the
   requested height of the new font in pixels. The function should
   set the closest available height and then denote the size of
   the new font in the fysize variable in the gr_display structure.

****************************************************************/

gr_font( screen, type, rq_height )
   int screen;
   int type, rq_height;
   {
   }

/****************************************************************

   gr_blit()

   This function "blits" (copies) a rectangular area of the screen
   from GR_PRIMARY to GR_HIDDEN or vice versa (if blitting is
   implemented, i.e., gr_blitting == TRUE).

   The arguments "src" and "dst" are integers denoting either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN). Obviously, one should be set to GR_PRIMARY and
   one to GR_HIDDEN. "src" denotes the source of the blit, and
   "dst" the destination.

   The arguments x1, y1, x2, and y2 specify two pixel locations
   on the screen in gr coordinates (see above on the coordinate
   system) denoting the bottom left corner (x1, y1) and top right
   corner (x2, y2) of the area to be blitted (x1 and x2 on the
   horizontal axis, and y1 and y2 on the vertical axis).

****************************************************************/

gr_blit( src, dst, x1, y1, x2, y2 )
   int src, dst;
   int x1, y1, x2, y2;
   {
   }

/****************************************************************

   gr_imsave()

   This function either saves a rectangluar area of the screen to
   a memory buffer (mode == TRUE), or restores a rectangular screen
   area from the buffer (mode == FALSE). It should free existing memory
   when mode == FALSE (thus, the area cannot be restored more than once).

   The argument "screen" is an integer denoted either the
   visible screen (defined as GR_PRIMARY) or a hidden buffer
   to which graphics output can be written (defined as
   GR_HIDDEN).

   The arguments x1, y1, x2, and y2 specify two pixel locations
   on the screen in gr coordinates (see above on the coordinate
   system) denoting the bottom left corner (x1, y1) and top right
   corner (x2, y2) of the rectangular area to be saved (x1 and x2
   on the horizontal axis, and y1 and y2 on the vertical axis).

   The argument "image" is an integer denoting the specific
   image that has been (or is to be) stored.

****************************************************************/

gr_imsave( screen, mode, x1, y1, x2, y2, image )
   int screen; 
   int mode, x1, y1, x2, y2;
   int *image;
   {
   }

/****************************************************************

	gr_imfree()

****************************************************************/

gr_imfree( image )
   int image;
   {
   }

/****************************************************************

   gr_mouse()

   This function either tells if a mouse button has been pushed
   (mode == SAMPLE or STATUS) or waits for a button to be pushed
   (mode == WAIT).

   The arguments x and y are integer pointers to be filled with a
   screen location in gr coordinates (see above on the coordinate
   system) where the mouse is currently located, x on the horizontal
   axis and y on the vertical axis.

   The argument "buttons" is an integer pointer which some great
   day will be used to specify which of the mouse buttons has been
   pushed but it hasn't been used yet in any Bywater applications
   so don't worry about it.

****************************************************************/

gr_mouse( mode, x, y, buttons )
   int mode;
   int *x, *y;
   int *buttons;
   {
   }

