/*	  SQUASH.H header file for limpel Ziv routine
		   this header should follow STDIO.h
*/

#ifndef EOF	/* defined in stdio.h */
#include  <stdio.h>
#endif

compress (FILE *,FILE *);
decompress(FILE *, FILE *);

/*
 * block compression parameters -- after all codes are used up,
 * and compression rate changes, start over.
 */

#define CHECK_GAP 10000 		/* ratio check interval */

/*
 * the next two codes should not be changed lightly, as they must not
 * lie within the contiguous general code space.
 */

#define FIRST	257			/* first free entry */
#define CLEAR	256			/* table clear output code */

/*
 * To save much memory, we overlay the table used by compress() with those
 * used by decompress().  The tab_prefix table is the same size and type
 * as the codetab.  The tab_suffix table needs 2**BITS characters.  We
 * get this from the beginning of htab.  The output stack uses the rest
 * of htab, and contains characters.  There is plenty of room for any
 * possible stack (stack used to be 8000 characters).
 */

#define MAXCODE(n_bits)  (( 1<<(n_bits)) - 1)

#define tab_prefixof(i) codetab[i]
#define tab_suffixof(i)        ((unsigned char *)(htab))[i]
#define de_stack	       ((unsigned char *)&tab_suffixof(1<<BITS))

#define BITS   13			/* could be restricted to 12 */
#define INIT_BITS 9			/* initial number of bits/code */

#if BITS == 13
# define HSIZE	9001			/* 91% occupancy */
#endif
#if BITS <= 12
# define HSIZE	5003			/* 80% occupancy */
#endif

struct arch_header			/* archive entry header format */
{
    char archmark;			/* should always be 0x1a; */
    char atype; 			/* header type */
    char name[13];			/* file name */
    long lzwsize;			/* size of file, in bytes */
    unsigned date;			/* creation date */
    unsigned time;			/* creation time */
    unsigned crc;			/* cyclic redundancy check */
    long length;			/* true file length */
}
;

#ifdef MAIN
struct arch_header ahead;
long htab [HSIZE];
unsigned short codetab [HSIZE];
short hsize ;				/* for dynamic table sizing */
int offset;
long int in_count = 1;			/* length of input */
long int bytes_out= 0;			/* length of compressed output */
long int out_count = 0; 		/* # of codes output (for debugging) */
long  int ratio = 0;
long checkpoint = CHECK_GAP;
short clear_flg = 0;
short n_bits;				/* number of bits/code */
short max_bits = BITS;			/* user settable max # bits/code */
short maxcode;				/* maximum code, given n_bits */
short maxmaxcode = 1 << BITS;		/* should NEVER generate this code */
short crc=0;
int free_ent = 0;			/* first unused entry */
long lzwsize;
#else
extern long htab [HSIZE];
extern long int in_count;		/* length of input */
extern long int bytes_out;		/* length of compressed output */
extern long int out_count;		/* # of codes output (for debugging) */
extern long  int ratio;
extern long checkpoint;
extern short clear_flg;
extern short n_bits;			/* number of bits/code */
extern short max_bits;			/* user settable max # bits/code */
extern short maxcode;			/* maximum code, given n_bits */
extern short maxmaxcode;		/* should NEVER generate this code */
extern short crc;
extern short free_ent;			/* first unused entry */
extern unsigned short codetab [HSIZE];
extern short hsize ;			/* for dynamic table sizing */
extern short offset;
extern struct arch_header ahead;
extern long lzwsize;
#endif

int getcode(FILE *);

