#include <stdlib.h>
#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef subwin

#ifdef PDCDEBUG
char *rcsid_subwin = "$Header: C:\CURSES\portable\RCS\subwin.c 2.1 1993/06/18 20:21:17 MH Rel MH $";
#endif




/*man-start*********************************************************************

  subwin()	- create subwindow

  X/Open Description:
 	This routine creates a new sub-window within a window.  The
 	dimensions of the sub-window are nlines lines and ncols
 	columns.  The sub-window is at position (begin_y, begin_x) on
 	the screen.  This position is relative to the screen, and not
 	to the window orig.

 	The sub-window is made in the middle of the window orig, so
 	that changes made to either window will affect both.  When
 	using this routine, it will often be necessary to call
 	touchwin before calling wrefresh.

  PDCurses Description:
 	No additional PDCurses functionality.

  X/Open Return Value:
 	On success the subwin function returns a pointer to the new
 	WINDOW structure created.  On failure the function returns a
 	null pointer.

  PDCurses Errors:
 	It is an error to pass sub-window coordinates that are out of
 	range or a NULL WINDOW pointer.  subwin() may also return an
 	error if it fails to allocate enough memory for the window
 	structure.

  Portability:
 	PDCurses	WINDOW*	subwin( WINDOW* orig, int nlines,
 				int ncols, int begin_y, int begin_x );
 	X/Open Dec '88	WINDOW*	subwin( WINDOW* orig, int nlines,
 				int ncols, int begin_y, int begin_x );
 	BSD Curses	WINDOW*	subwin( WINDOW* orig, int nlines,
 				int ncols, int begin_y, int begin_x );
 	SYS V Curses	WINDOW*	subwin( WINDOW* orig, int nlines,
 				int ncols, int begin_y, int begin_x );

**man-end**********************************************************************/

WINDOW*	subwin(WINDOW* orig,int nlines,int ncols,int begin_y,int begin_x)
{
extern	void*	(*mallc)( size_t );
extern	void*	(*callc)( size_t, size_t );
extern	void	(*fre)( void* );

	WINDOW*	win;
	int	i;
	int	j = begin_y - orig->_begy;
	int	k = begin_x - orig->_begx;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("subwin() - called: lines %d cols %d begy %d begx %d\n",nlines,ncols,begin_y,begin_x);
#endif

	if (!orig)
		return( (WINDOW *)NULL );

	/*
	 * make sure window fits inside the original one
	 */
	if ((begin_y < orig->_begy) ||
	    (begin_x < orig->_begx) ||
	    (begin_y + nlines) > (orig->_begy + orig->_maxy) ||
	    (begin_x + ncols)  > (orig->_begx + orig->_maxx))
	{
		return( (WINDOW *)NULL );
	}
	if (!nlines)	nlines = orig->_maxy - 1 - j;
	if (!ncols)	ncols  = orig->_maxx - 1 - k;
	if ((win = PDC_makenew(nlines, ncols, begin_y, begin_x)) == (WINDOW *) NULL)
	{
		return( (WINDOW *)NULL );
	}

	/*
	 * initialize window variables
	 */
	win->_attrs	= orig->_attrs;
	win->_leave	= orig->_leave;
	win->_scroll	= orig->_scroll;
	win->_nodelay	= orig->_nodelay;
	win->_use_keypad	= orig->_use_keypad;
	win->_parent	= orig;

	for (i = 0; i < nlines; i++)
	{
		win->_y[i] = (orig->_y[j++]) + k;
	}

	win->_flags |= _SUBWIN;
	return (win);
}
