/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program.: KnowledgeMan/2 Function Library
* Module..: pgRefTb1.IPF
* Version.: 1987-1 Spring
* Function: Maintain your reference look-up tables.
* Author..: William H. Mueller
* Date....: February 2, 1987
* Last Upd: 
* Notice..: (C) Copyright 1986, 87  Mueller's PC Consulting
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* This IPF is a menu system for maintaining your Reference Tables.
   Set up to call pgRefTb2.IPF which assumes the following:
    1. That each table has 2 fields = CODE & DESC.
    2. Table is indexed on Code field.
    3. Deletions are done by setting fields to NULL.
    4. Additions are done by looking for & using NULL's or
       ATTACHing if no NULL's are available.
    5. Editing of the Code field is not allowed for data integity.
   Other tables, not fitting this schema, may be linked into this
   routine by calling its own IPF and not pgRefTb2.IPF.  Your IPF
   should be sure to CLEAR its own screen elements & maintain the
   screen elements of this IPF.
   Selects which table to use & calls pgRefTb2 which does actual
   work.  Forms in pgRefTb2 will appear customized because table
   descriptive name is used for title, field labels for field prompts
   and field pictures for the input fields.
   Requires 5 parameters to invoke pgRefTb2.IPF.  See CASE statement
   in this IPF for proper format.
    #A - slTblDes = Descriptive name for a table
    #B - slTblNam = Actual Table name
    #C - slIndNam = Index file name
    #D - slCodPic = picture used for CODE field
    #E - slDesPic = picture used for DESC field
   To add/change/modify tables to be worked on you must do 3 things.
    1. Modify menu options. \ Both of these items are located in this
    2. Modify array alMnMnu./   IPF in a specially marked section.
    3. Modify the TEST ilMnuCho CASE's in this IPF to reflect your
       tables.  Follow the format of the other CASEs for proper
       parameter passing to pgRefTb2.IPF.
   Environmental variables needed for proper operation are controlled
   by this program (see ENVIR.SET section), however other
   environmental variables may affect some manner in which it
   operates.
   Examples: E.Paus will affect the table listing output.
             E.Auto will, of course, affect input operation.
             E.ECol & ERow for error msgs. (KMan defaults are fine).
*/

LOCAL FORM flPlWait
 AT 25,50 PUT " PROCESSING " WITH "RBL"
 AT 25,63 PUT "- Please Wait" WITH "L"
ENDFORM

CLEAR; PUTFORM flPlWait

    /* ENVIR.SET - Record user envir & set needed envir. */
LOCAL blIMac blSupD blIMrk blICas ilLStr ilPMar ilPDep blInUp
 blIMac = E.IMac
 blSupD = E.SupD
 blIMrk = E.IMrk
 blICas = E.ICas
 ilLStr = E.LStr
 ilPMar = E.PMar
 ilPDep = E.PDep
 blInUp = E.InUp

 E.IMac = FALSE
 E.SupD = TRUE
 E.IMrk = TRUE
 E.ICas = TRUE
 E.LStr = 80
 E.PMar = 5
 E.InUp = TRUE

LOCAL FORM flChoOpt
 AT 3,13 PUT\
  "Select option with cursor keys and then press <RETURN>" WITH "L"
 AT 4,2 PUT "=======================================" WITH "L"
 AT 4,41 PUT "=======================================" WITH "L"
ENDFORM

LOCAL FORM flPgTitl
 AT 1,25 PUT " Reference  Table  Maintanance " WITH "RL"
 AT 2,12 PUT\
  "--------------------------------------------------------" WITH "L"
ENDFORM

/* ******************************************************************
  MODIFY THIS SECTION (to next marker) FOR YOUR TABLES
*/
    /*  Menu function settings for main menu - change settings here
         as numbers are used for forms and control purposes. */
LOCAL ilDefOpt ilNumOpt ilFirRow ilFirCol ilRowSpc ilColSiz ilNumCol
         /* These correspond to KMan MENU function options */
 ilDefOpt = 4           !Default option should always be last & exit
 ilNumOpt = ilDefOpt
 ilFirRow = 5           !Never a lower starting number
 ilFirCol = 25
 ilRowSpc = 2           !Cannot be 0
 ilColSiz = 31
 ilNumCol = 1

    /* Main Menu Array - modify this for your tables */
LOCAL DIM alMnMnu(ilDefOpt)
 alMnMnu(1) = "      Parts Code Table       "
 alMnMnu(2) = "    Sales Man Code Table     "
 alMnMnu(3) = "    Warehouse Code Table     "
 alMnMnu(ilDefOpt) = " Exit Reference Table Maint. "

/*  END OF SECTION TO MODIFY - also modify TEST statements.
****************************************************************** */

LOCAL ilEndRow
    /* ilEndRow is used to determine ending row of main menu array -
       under some combinations it may be one row lower than actual
       array.  Used in FORM flBlnkMn to CLEAR the main menu. */
 IF ilNumOpt MOD ilNumCol = 0 THEN
  ilEndRow = ilFirRow + ((ilNumOpt / ilNumCol) * ilRowSpc) - ilRowSpc
 ELSE
  ilEndRow = ilFirRow + (TRUNC(ilNumOpt / ilNumCol) * ilRowSpc)
 ENDIF

LOCAL FORM flBlnkMn          !Blanks out Main Menu area only
 AT ilFirRow, ilFirCol PUT " "
 AT ilEndRow, (ilFirCol+(ilColSiz*ilNumCol)) PUT " "
ENDFORM

LOCAL ilMnuCho slTblDes slTblNam slCodPic slDesPic slIndNam 
 ilMnuCho = -1
 slTblDes = "                              "
 slTblNam = "          "
 slCodPic = "                    "
 slDesPic =\
  "                                                            "
 slIndNam = "        "

LOAD PERFORM pgRefTb2

CLEAR flPlWait
PUTFORM flPgTitl
PUTFORM flChoOpt
WHILE TRUE DO                                    !IPF Control loop
 DRAIN()
 ilMnuCho = MENU(alMnMnu, ilDefOpt, ilNumOpt, ilFirRow,\
             ilFirCol, ilRowSpc, ilColSiz, ilNumCol)
 IF ilMnuCho = 0 OR ilMnuCho = ilDefOpt THEN     !Function exit by <ESC>
  CLEAR flBlnkMn                                 !or EXIT choice.
  BREAK
 ENDIF
 TEST ilMnuCho                    !Modify/add cases for your tables
  CASE 1:                                   !tParts table
   slTblDes = "\"Parts  Code  Table\""      !Descriptive Table Name
   slTblNam = "\"tParts\""                  !Table Name
   slIndNam = "xParts"                      !Index Name
   slCodPic = "\"nn-nnnn-nn\""              !Picture for table.Code
   slDesPic = "\"u%29r\""                   !Picture for table.Desc
   CLEAR flBlnkMn
   PERFORM pgRefTb2 slTblDes slTblNam slIndNam slCodPic slDesPic
   ilMnuCho = -1
   BREAK
  CASE 2:                                        !tSaleMan table
   slTblDes = "\"Sales Man Code Table\""
   slTblNam = "\"tSaleMan\""
   slIndNam = "xSaleMan"
   slCodPic = "\"uuu\""
   slDesPic = "\"u%24r\""
   CLEAR flBlnkMn
   PERFORM pgRefTb2 slTblDes slTblNam slIndNam slCodPic slDesPic
   ilMnuCho = -1
   BREAK
  CASE 3:                                        !tWarHous table
   slTblDes = "\"Warehouse Code Table\""
   slTblNam = "\"tWarHous\""
   slIndNam = "xWarHous"
   slCodPic = "\"uu-uu-n\""
   slDesPic = "\"u%29r\""
   CLEAR flBlnkMn
   PERFORM pgRefTb2 slTblDes slTblNam slIndNam slCodPic slDesPic
   ilMnuCho = -1
   BREAK
 ENDTEST      !TEST ilMnuCho
ENDWHILE      !IPF Control loop

E.IMac = blIMac                        !Load user envir.
E.SupD = blSupD
E.IMrk = blIMrk
E.ICas = blICas
E.LStr = ilLStr
E.PMar = ilPMar
E.PDep = ilPDep
E.InUp = blInUp

CLEAR flChoOpt
CLEAR flPgTitl
RELEASE PERFORM pgRefTb2
