{**********************************************************************}
{*                            P R O Z P                               *}
{*--------------------------------------------------------------------*}
{*    Task           : Examines the processor type in the PC and      *}
{*                     tells the user the processor type              *}
{*--------------------------------------------------------------------*}
{*    Author         : MICHAEL TISCHER                                *}
{*    Developed on   : 08/16/1988                                     *}
{*    Last update    : 05/23/1989                                     *}
{**********************************************************************}

program PROCP;

type  ProNames = array[0..7] of string[11]; { Array of processor names }

const ProcName : ProNames = ( 'INTEL 8088',                   { Code 0 }
                              'INTEL 8086',                   { Code 1 }
                              'NEC V20',                      { Code 2 }
                              'NEC V30',                      { Code 3 }
                              'INTEL 80188',                  { Code 4 }
                              'INTEL 80186',                  { Code 5 }
                              'INTEL 80286',                  { Code 6 }
                              'INTEL 80386' );                { Code 7 }

{**********************************************************************}
{* GETPROZ: Determines processor type in PC                           *}
{* Input   : none                                                     *}
{* Output  : Processor code (see CONST)                               *}
{* Info    : This function can be used in a program when added as     *}
{*           a UNIT                                                   *}
{**********************************************************************}

function getproz : byte;

begin           { Maschine code routine for determining processor type }
 inline(
        $9C/$51/$52/$57/$56/$06/$33/$C0/$50/$9D/$9C/$58/$25/$00/
        $F0/$3D/$00/$F0/$74/$13/$B2/$06/$B8/$00/$70/$50/$9D/$9C/
        $58/$25/$00/$70/$74/$36/$FE/$C2/$EB/$32/$90/$B2/$04/$B0/
        $FF/$B1/$21/$D2/$E8/$75/$12/$B2/$02/$FB/$BE/$00/$00/$B9/
        $FF/$FF/$F3/$26/$AC/$0B/$C9/$74/$02/$B2/$00/$0E/$07/$FD/
        $B0/$FB/$B9/$03/$00/$E8/$16/$00/$FA/$F3/$AA/$FC/$90/$90/
        $90/$42/$90/$FB/$88/$56/$FF/$07/$5E/$5F/$5A/$59/$9D/$EB/
        $07/$90/$5F/$83/$C7/$09/$EB/$E4
       );
end;

{**********************************************************************}
{**                           MAIN PROGRAM                           **}
{**********************************************************************}

begin
  writeln('PROCP  -  (c) 1988 by MICHAEL TISCHER');
  writeln(#13#10, 'Your PC contains a(n) ', ProcName[getproz],
                ' processor.');
  writeln(#13#10);
end.
