100 '*****************************************************************'
110 '*                         D I R B                               *'
120 '*---------------------------------------------------------------*'
130 '*  Task        : display all files in a directory               *'
140 '*                in a window on the display                     *'
160 '*  Author      : MICHAEL TISCHER                                *'
170 '*  developed   : 07/23/87                                       *'
180 '*  last Update : 04/08/89                                       *'
190 '*****************************************************************'
200 '
210 CLS : KEY OFF
220 PRINT"WARNING: This program can be run only if GWBASIC was started"
225 PRINT" from the "
230 PRINT"DOS level with the <GWBASIC  /m60000> command." : PRINT
240 PRINT"If this is not the case, please enter <s> for Stop."
250 PRINT : PRINT"Otherwise press any key ...";
260 A$ = INKEY$ : IF A$ = "s" THEN END
270 IF A$ = "" THEN 260
280 GOSUB 60000                 'Install function for calling interrupt
290 CLS
300 PRINT "DIR (c) 1987 by Michael Tischer"
310 PRINT
320 PRINT"Please input the search path for the file."
330 PRINT"Example: If all files with the extension .BAT in the Root"
340 PRINT"         directory of the disk in drive A should be displayed,"
350 PRINT"         then please input A:\*.BAT."
360 PRINT"With a blank input, all files in the current directory "
370 PRINT"are displayed." : PRINT
380 INPUT "Search Path: ",DIR$          'Input Search Path
390 IF DIR$ = "" THEN DIR$ = "*.*"      'search in current directory
400 ENTRY% = 14                         '14 Display entries in window
410 GOSUB 50000                         'Input Directory and output
420 END
430 '
50000 '***************************************************************'
50010 '* Input one Directory and display                             *'
50020 '*-------------------------------------------------------------*'
50030 '* Input:  DIR$    = the search path                           *'
50040 '*          ENTRY% = Number of entries in the window           *'
50050 '* Output: none                                                *'
50060 '***************************************************************'
50070 '
50080 DIM MONTH$[11]                           'accepts names of months
50090 RESTORE 50600
50100 FOR I% = 0 TO 11 : READ MONTH$[I%] : NEXT
50110 INR% = &H21                             'Call DOS-Interrupt 21(h)
50120 FCT% = &H2F                          'Get function number for DTA
50130 CALL IA(INR%,FCT%,Z%,OFSHI%,OFSLO%,Z%,Z%,Z%,Z%,Z%,Z%,DTASEG%,Z%)
50140 DTAOFS% = OFSLO% + OFSHI% * 256
50150 CLS
50160 OFFSET% = INT((20 - ENTRY%) / 2) + 1        'Start line of window
50170 LOCATE OFFSET%,14
50180 PRINT TAB(14)"ͻ"
50190 PRINT TAB(14)" Filename    Size     Date       Time   RHSVD"
50200 PRINT TAB(14)"Ķ"
50210 FOR I% = 1 TO ENTRY%        'output a line for every entry 
50220 PRINT TAB(14)"                                             "
50230 NEXT                                       'output next line
50240 PRINT TAB(14)"ͼ"
50250 NUMWIND% = -1                        'Number of entries in window
50260 NUMFND% = 0                    'Number of entries found up to now
50270 ATTRIBUTE% = 255             'search for files with any Attribute
50280 GOSUB 51000                               'search for first entry
50290 IF NOT(FOUNDIT%) THEN 50500          'no entry found --> finished
50300 NUMFND% = NUMFND% + 1           'Increase number of entries found
50310 NUMWIND% = NUMWIND% + 1     'Increase number of entries in window
50320 IF NUMWIND% <> ENTRY% THEN 50410                    'window full?
50330 LOCATE OFFSET%+ENTRY%+4,14       'Set Cursor to line under window
50340 COLOR 0,7                    'switch on inverse character display
50350 PRINT"                Please press any key               ";
50360 A$ = INKEY$ : IF A$= "" THEN 50360                'wait for a key
50370 LOCATE ,14                           'Cursor in line under window
50380 COLOR 7,0                       'switch on normal character color
50390 PRINT STRING$(51," ");
50400 NUMWIND% = -1          'the next entry is the first in the window
50410 NUMBER% = 1 : COLOUR% = 7
50420 ULR% = OFFSET% + 2 : LRR% = OFFSET%+ENTRY% + 1
50430 ULC% = 14 : LRC% = 62
50440 GOSUB 54000                                     'scroll window up
50450 LOCATE OFFSET%+ENTRY%+2,15        'Set Cursor to last window line
50460 PRINT "                                             "
50470 GOSUB 53000                                         'Output entry
50480 GOSUB 52000                                       'Get next entry
50490 IF FOUNDIT% THEN 50300         'continue if no entry is available
50500 LOCATE OFFSET%+ENTRY%+4,14       'Cursor in line under the window
50510 COLOR 0,7                    'switch on inverse character display
50520 PRINT STRING$(51," ");
50530 LOCATE ,14                           'Cursor in line under window
50540 IF NUMFND% = 0 THEN PRINT" no file found"; : GOTO 50570
50550 IF NUMFND% = 1 THEN PRINT" found one file"; : GOTO 50570
50560 PRINT NUMFND%;"files found";
50570 COLOR 7,0                       'switch on normal character color
50580 RETURN
50590 '
50600 DATA "JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP"
50610 DATA "OCT","NOV","DEC"
50620 '
51000 '***************************************************************'
51010 '* Search for first entry in a Directory                       *'
51020 '*-------------------------------------------------------------*'
51030 '* Input:  DIR$       = Search path                            *'
51040 '*         ATTRIBUTE% = Attribute of file                      *'
51050 '* Output: FOUND_IT%  = -1 if entry found, otherwise 0         *'
51060 '* Info  : the Directory entry is entered into Variable DTA%   *'
51070 '*                                                             *'
51080 '*         Z% is a Dummy-Variable                              *'
51090 '***************************************************************'
51100 '
51110 DIR$ = DIR$ + CHR$(0)           'Put End character on search path
51120 FCT% = &H4E               'Search function number for first entry
51130 INR% = &H21                             'Call DOS-Interrupt 21(h)
51140 ATLO% = ATTRIBUTE% AND 255                  'LO-Byte of Attribute
51150 ATHI% = INT(ATTRIBUTE% / 256)               'HI-Byte of Attribute
51160 OFSLO% = PEEK(VARPTR(DIR$)+1)          'LO-Byte of Offset address
51170 OFSHI% = PEEK(VARPTR(DIR$)+2)          'HI-Byte of Offset address
51180 CALL IA(INR%,FCT%,Z%,Z%,Z%,ATHI%,ATLO%,OFSHI%,OFSLO%,Z%,Z%,Z%,FLAGS%)
51190 FOUNDIT% = ((FLAGS% AND 1) = 0)                  'Test Carry-Flag
51200 RETURN                            'return to calling program 
51210 '
52000 '***************************************************************'
52010 '* find next entry in Directory                                *'
52020 '*-------------------------------------------------------------*'
52030 '* Input :  DIR$       = Search path                           *'
52040 '*          ATTRIBUTE% = Attribute of file                     *'
52050 '* Output:  FOUNDIT%   = -1 if file found, otherwise 0         *'
52060 '* Info  :  the Directory entry is read into Variable DTA%     *'
52070 '*                                                             *'
52080 '*          Z% is a Dummy-Variable                             *'
52090 '***************************************************************'
52100 '
52110 FCT% = &H4F                  'Find function number for next entry
52120 INR% = &H21                             'Call DOS-Interrupt 21(h)
52130 CALL IA(INR%,FCT%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,Z%,FLAGS%)
52140 FOUNDIT% = ((FLAGS% AND 1) = 0)                  'test Carry-Flag
52150 RETURN                                   'back to calling program
52160 '
53000 '***************************************************************'
53010 '* Output a Directory entry from the DTA to the display        *'
53020 '*-------------------------------------------------------------*'
53030 '* Input:  OFFSET% = first line of the Directory window        *'
53040 '*         ENTRY%  = Number of entries in the Directory window *'
53050 '*         DTAOFS% = Offset address of the DTA                 *'
53060 '*         MONTH$  = contains the names of months              *'
53070 '* Output: none                                                *'
53080 '***************************************************************'
53090 '
53100 DEF FNDTA(X) = PEEK(DTAOFS% + X)
53110 DEF SEG = DTASEG%                 'Set Segment address of the DTA
53120 LOCATE OFFSET%+ENTRY%+2,15 'Output in the last line of the window
53130 I% = 30                     'Offset address in DTA for file names
53140 WHILE FNDTA(I%) <> 0       'the END character terminates the name
53150 PRINT CHR$(FNDTA(I%));       'output a character of the file name
53160 I% = I% + 1                                       'next character
53170 WEND                                                 'End of Loop
53180 LOCATE OFFSET%+ENTRY%+2,28               'Set Cursor to column 28
53190 PRINT USING "#######"; FNDTA(26) + FNDTA(27) * 256! + FNDTA(28) * 4096! + FNDTA(29) * 65536!;
53200 DATE = FNDTA(24) + FNDTA(25) * 256                      'Get Date
53210 LOCATE OFFSET%+ENTRY%+2,36               'Set Cursor to Column 36
53220 PRINT MONTH$[(INT(DATE / 32) AND 15) - 1];  'Output name of month
53230 PRINT"/";:PRINT USING "##";DATE AND 31;      'Output day of month
53240 PRINT USING "/####";INT(DATE / 512) + 1980;          'Output year
53250 LOCATE OFFSET%+ENTRY%+2,49               'Set Cursor to column 49
53260 FTIME = FNDTA(22) + FNDTA(23) * 256                     'Get time
53270 PRINT USING "##";INT(FTIME / 2048);                  'Output hour
53280 PRINT ":";
53290 PRINT USING "##";INT(FTIME / 32) AND 63;           'Output Minute
53300 LOCATE OFFSET%+ENTRY%+2,59               'Set Cursor to column 59
53310 FOR I% = 0 TO 4               'test Bits 0 to 4 of file attribute
53320 IF (FNDTA(21) AND (2^I%)) <> 0 THEN PRINT"X"; ELSE PRINT" ";
53330 NEXT I%                                            'test next Bit
53340 DEF SEG : RETURN                         'back to calling program
53350 '
54000 '***************************************************************'
54010 '* Scroll current display page up or erase                     *'
54020 '*-------------------------------------------------------------*'
54030 '* Input :  NUMBER% = how many lines scrolled                  *'
54040 '*          ULC%    = column upper left                        *'
54050 '*          ULR%    = line upper left                          *'
54060 '*          LRC%    = column lower right                       *'
54070 '*          LRR%    = line lower right                         *'
54080 '*          COLOR%  = color of erased line                     *'
54090 '* Output:  none                                               *'
54100 '* Info  :  If 0 is given for NUMBER%, the screen area         *'
54110 '*          indicated is erased                                *'
54120 '*          the Variable Z% is a Dummy                         *'
54130 '***************************************************************'
54140 '
54150 FCT%=6                          'Function number for scrolling up
54160 INR%=&H10                        'Call BIOS-Video-Interrupt 16(h)
54170 CALL IA(INR%,FCT%,NUMBER%,COLOUR%,Z%,ULR%,ULC%,LRR%,LRC%,Z%,Z%,Z%,Z%)
54180 RETURN                                   'back to calling program
54190 '
60000 '***************************************************************'
60010 '* Initialize Routine for Interrupt call                       *'
60020 '*-------------------------------------------------------------*'
60030 '* Input : none                                                *'
60040 '* Output: IA is the Start address of the Interrupt-Routine    *'
60050 '***************************************************************'
60060 '
60070 IA=60000!      'Start address of the Routine in the BASIC-Segment
60080 DEF SEG                                        'Set BASIC-Segment
60090 RESTORE 60130
60100 FOR I% = 0 TO 160 : READ X% : POKE IA+I%,X% : NEXT  'Poke Routine 
60110 RETURN                                   'back to calling program
60120 '
60130 DATA  85,139,236, 30,  6,139,118, 30,139,  4,232,140,  0,139,118
60140 DATA  12,139, 60,139,118,  8,139,  4, 61,255,255,117,  2,140,216
60150 DATA 142,192,139,118, 28,138, 36,139,118, 26,138,  4,139,118, 24
60160 DATA 138, 60,139,118, 22,138, 28,139,118, 20,138, 44,139,118, 18
60170 DATA 138, 12,139,118, 16,138, 52,139,118, 14,138, 20,139,118, 10
60180 DATA 139, 52, 85,205, 33, 93, 86,156,139,118, 12,137, 60,139,118
60190 DATA  28,136, 36,139,118, 26,136,  4,139,118, 24,136, 60,139,118
60200 DATA  22,136, 28,139,118, 20,136, 44,139,118, 18,136, 12,139,118
60210 DATA  16,136, 52,139,118, 14,136, 20,139,118,  8,140,192,137,  4
60220 DATA  88,139,118,  6,137,  4, 88,139,118, 10,137,  4,  7, 31, 93
60230 DATA 202, 26,  0, 91, 46,136, 71, 66,233,108,255
