{{$M 2048,0,131072}

{$R-,S-,Q-}

unit rotozoom;
{
rotates/pans/scales a 256x256 bitmap.  This is the semi-famous Paul H. Kahler
method published in January 1994, adapted to CGA and 8088 optimized by
trixter@oldskool.org.
converted to OOP for block party
}

interface

uses
  cgalib,
  objects;

const
  UsingDOSMEM:boolean=false;

type
  protozoomer=^trotozoomer;
  trotozoomer=object(TObject)

    Constructor init(vidsys:pVidSystem;startloc:pointer;len:byte); {starting location and # of scanlines}
    Destructor Done; virtual;
    Procedure draw; {draw next iteration}

    private

    vs:pvidsystem; {reference to the video system}
    SinTable,CosTable: Array[0..255] Of Integer;
    Sin2Table,Cos2Table: Array[0..255] Of Integer;
    texMap:Word; {holds the segment of the 256x256 texture}
    p1,p2:pointer; {used to allocate memory from Turbo Pascal heap}
    rot,dr:Word;
    texX,texY,dd:Word;
    dist:integer;
    numscanlines:byte;
    drawloc:pointer;

    Procedure DrawScreen(X,Y,scale:Word; rotation:Byte);
  end;

implementation

constructor trotozoomer.init;
Var
  Direction:Integer;
  angle:Real;
  X,Y:Integer;
  map:word;
  f:file; {for loading texture}
  sourcetex:pointer;

begin
  Inherited init;
  {mystuff}
  vs:=vidsys; {so we can know about the screen we're writing to}
  numscanlines:=len;

  {Returns a segment pointer for a 64K bitmap.  Can't allocate a full,
  true 64K heap area thanks to Turbo Pascal's broken heap manager, so we
  try to allocate two consecutive 32K heap areas instead.  If that fails,
  fall back to asking DOS for a single 64K segment.}
  {try to allocate full 64K with TP heap -- it is SUPPOSED to be sequential}
  getmem(p1,$8000); getmem(p2,$8000);
  if seg(p2^)-seg(p1^)=($8000 div 16) then begin
    map:=seg(p1^);
    usingDOSMEM:=false;
  end else begin {our allocation faile}
    freemem(p2,$8000);
    freemem(p1,$8000);
    Asm
      mov   AH,$48
      mov   BX,$1000     { request 64K }
      Int   $21
      jnc   @noerror
      mov   AX,0000
  @noerror:
      mov   Map,AX       {The segment pointer goes in Map}
    End;
    If (Map=0) Then Begin
      asm
        mov ax,0003
        int 10h
      end;
      WriteLn('Could not allocate 64K from DOS!');
      Halt;
    end;
    usingDOSMEM:=true;
  End;
  texmap:=map;

  {init tables}
  For Direction:=0 To 255 Do Begin   {use 256 degrees in circle}
    angle:=Direction;
    angle:=angle*PI/128;
    SinTable[Direction]:=Round(Sin(angle)*256);
    CosTable[Direction]:=Round(Cos(angle)*256);
    Sin2Table[Direction]:=Round(Sin(angle+PI/2)*256*0.6); {accounts for pixel aspect ratio}
    Cos2Table[Direction]:=Round(Cos(angle+PI/2)*256*0.6); {1.2 would be appropriate for 320x200 but we're using 80x100}
  End;

  {draws a test image which shows some limitations.}
  (*
  For X:=-32768 To 32767 Do mem[Map:X]:=0;
  For Y:=0 To 15 Do          {this just frames the area}
    For X:=Y To 255 Do Begin
      mem[Map:Y*256+X]:=1;
      mem[Map:X*256+Y]:=2;
    End;
  For Y:=16 To 47 Do         { this part show Aliasing effects }
    For X:=16 To 255 Do mem[Map:Y*256+X]:=2+(X And 1)+(Y And 1);
  For Y:= -50 To 50 Do       { this draw the circles }
    For X:= Round(-Sqrt(2500 - Y*Y)) To Round(Sqrt(2500 - Y*Y)) Do
      mem[Map:(Y+100)*256+X+100]:=5+(X*X+Y*Y) Div 100;
  For X:=0 To 100 Do         { These lines also show sampling effects }
    For Y:=0 To 8 Do
      mem[Map:(Y*2560)+X+41100]:=5;
  *)

  {load a 16-col 256x256 .bmp}
  assign(f,'texture.bmp');
  reset(f,1);
  seek(f,filesize(f)-32768);
  getmem(sourcetex,32768);
  blockread(f,sourcetex^,32768);
  close(f);
  asm
    {translate 4-bit pixel to 8-bit}
    push ds
    mov cx,32768
    mov es,[map]
    xor di,di
    lds si,sourcetex
    cld

@trans:
    lodsb
    mov  bh,al   {copy packed to ah}
    and  bh,$0f  {isolate second/rightmost packed}
    shr  al,1
    shr  al,1
    shr  al,1
    shr  al,1    {isolate first/leftmost packed}
                 {al has first, bh has second}
    mov  ah,al   {double it so we don't have black dots between pixels}
    shl  ah,1
    shl  ah,1
    shl  ah,1
    shl  ah,1
    or   al,ah
    stosb

    mov  al,bh

    mov  ah,al   {double it so we don't have black dots between pixels}
    shl  ah,1
    shl  ah,1
    shl  ah,1
    shl  ah,1
    or   al,ah
    stosb

    loop @trans

    pop  ds
  end;
  freemem(sourcetex,32768);

  texX:=32768; texY:=0;         {this corresponds to (128,0) in fixed point}
  rot:=0; dr:=2;          {rotation angle and it's delta}
  dist:=1200; dd:=65534;  {distance to bitmap (sort of) and its delta}

  numscanlines:=len;
  drawloc:=startloc;
end;

destructor trotozoomer.done;
var
  map:word;
begin
  {mystuff}
  {give back memory}
  map:=texmap;
  if usingDOSMEM then begin
    Asm
      mov  AH,$49
      mov  DX,Map
      mov  ES,DX
      Int  $21
    End;
  end else begin
    freemem(p2,$8000); freemem(p1,$8000);
  end;

  inherited done;
end;

procedure trotozoomer.draw;
{draw one frame and update variables}
begin
  DrawScreen(texX,texY,dist,Lo(rot));
  rot:=rot+dr;
  inc(texY,128);      {slow panning. 1/2 pixel per frame}
  inc(texx,512);
  dist:=dist+(dd*3);
  If (dist>=2000) Or (dist<=2) Then dd:=-dd;
end;

Procedure trotozoomer.DrawScreen(X,Y,scale:Word; rotation:Byte);
Var
  Temp:LongInt;            {used for intermediate large values}
  ddx,ddy,D2X,D2Y:Integer;
  i,j:Word;
  loc:pointer;
  map:word;
  numlines:word;

Begin
  map:=texmap;
  numlines:=numscanlines; {make temp copies to local space so I don't have
  to do constant @Self dereferences}

  {The following lines of code calculate a 'right' and 'down' vector used
  for scanning the source bitmap.  I use quotes because these directions
  depend on the rotation.  For example, with a rotation, 'right' could mean
  up and to the left while 'down' means up and to the right.  Since the
  destination image (screen) is scanned left-right/top-bottom, the bitmap
  needs to be scanned in arbitrary directions to get a rotation.}

  ddx:=(CosTable[rotation]*Scale) Div 256;
  ddy:=(SinTable[rotation]*Scale) Div 256;

  {Different tables are used for the 'down' vector to account for non-
  square pixels. The 90 degree difference is built into the tables.
  If you don't like that, then use (rot+64) and 255 here
  and take the pi/2 out of CreateTables.}

  d2x:=(Cos2Table[rotation]*Scale) Div 256;
  d2y:=(Sin2Table[rotation]*SCALE) Div 256;

  {Since we want to rotate around the CENTER of the screen and not the upper
  left corner, we need to move to the center of the bitmap.}

  i:=X-ddx*(vs^.SLW div 2)-D2X*(vs^.height div 4);
  j:=Y-ddy*(vs^.SLW div 2)-D2Y*(vs^.height div 4);

  {The following chunk of assembly does the good stuff. It redraws the entire
  screen by scanning left-right/top-bottom on screen while also scanning the
  bitmap in the arbitrary directions determined above.}

  loc:=drawloc;

  Asm
    push DS
    mov  AX,[Map]      {set ds: to segment of bitmap}
    mov  DS,AX
    les  di,loc
    (*mov  AX,$b800      {set es: to video memory}
    mov  ES,AX
    xor  di,di*)
    mov  AX,[ddx]      {this is just to speed things up later}
    mov  SI,AX         {add ax,si  faster than  add ax,[ddx] }
    mov  CX,numlines   {Number of rows on Screen}

@vloop:
    push cx {so we can use it in hloop}
    mov  cx,[i]        {start scanning the source bitmap}
    mov  dx,[j]        {at i,j which were calculated above.}
    push bp {save BP last so we can use it in a loop and restore later to not crash when POPing later}
    mov  bp,ddy {stick ddy in bp so that we can avoid memory access in hloop}

    {This next block is repeated 40 times, for each word of a scanline}
                                                         {cycles  bytes}
    add  cx,SI {ddx}  {add the 'right' vector to the current} {3  2}
    add  DX,bp {ddy}  {bitmap coordinates.  8.8 fixed point}  {3  2}
    mov  BL,ch        {bx = 256*int(y)+int(x)}                {2  2}
    mov  BH,DH                                                {2  2}
    mov  al,[BX]      {load a pixel from source}              {10 3}
    add  cx,SI {ddx}  {add the 'right' vector to the current} {3  2}
    add  DX,bp {ddy}  {bitmap coordinates.  8.8 fixed point}  {3  2}
    mov  BL,ch        {bx = 256*int(y)+int(x)}                {2  2}
    mov  BH,DH                                                {2  2}
    mov  ah,[BX]      {load a pixel from source}              {10 3}
    stosw             {copy, advance to next dest. pixel}     {11 1}
                                                       {total: 51 23}
                                             {per pixel total: 26 12}

    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw
    add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov al,[BX];add cx,SI;add DX,bp;mov BL,ch;mov BH,DH;mov ah,[BX];stosw

    pop  bp {so that later pops will work}
    pop  cx {out of hloop, need to get it back to loop properly}

    mov  AX,D2X        { get the 'down' vector }
    add  i,AX          { i,j is the starting coords for a line }
    mov  AX,D2Y        {(use AX becase mov accum,mem is 10c, 3b)}
    add  j,AX          { so this moves down one line }

    dec  cx            {advance one scanline}
    jnz  @vloop        {can't use LOOP here because it's farther away than +/-128}
    pop  DS            { Restore the ds }
  End;
End;

end.