#ident  "@(#)kern-i386at:io/dlpi_cpq/pnt/pnt.cf/Space.c	1.4.1.1"
#ident  "$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>


#define NSAPS           	8
#define MAXMULTI        	8
#define INETSTATS       	1
#define STREAMS_LOG     	0
#define IFNAME          	"pnt"

#define PNT_TX_BUF      	16
#define PNT_RX_BUF      	16

#define LED0_Default		0x00c0
#define LED1_Default		0x00b0
#define LED2_Default		0x4088
#define LED3_Default		0x0081

#define BusTimer_Default	6		/* Default Bustimer Value */

#define Scan_ALL		0x0
#define Scan_PCI		0x1         /* PCI bus flag */
#define Scan_PLUG_PLAY		0x2         /* P&P bus flag */
#define Scan_LOCAL		0x3         /* local bus flag */
#define Scan_ISA		0x4         /* ISA bus flag */
#define Scan_PCI1		0x5         /* PCI type 1 bus flag */
#define Scan_PCI2		0x6         /* PCI type 2 bus flag */

int pnt_MaxStreams      	= NSAPS;
int pntstrlog           	= STREAMS_LOG;
char *pnt_ifname        	= IFNAME;
int pnt_nsaps           	= NSAPS;
int pnt_cmajors         	= PNT_CMAJORS;  /* # of possible major #'s */
int pnt_cmajor_0        	= PNT_CMAJOR_0; /* first major # in range */
short pnt_tx_buf        	= PNT_TX_BUF;
short pnt_rx_buf        	= PNT_RX_BUF;

struct pnt_ConfigStruct {
        short index;
        short minors;
        short vec;
        ushort iobase;
        short dma;
        ushort junk;
        short tx_buffers;
        short rx_buffers;
        long  bus_scan;
        long  led0;
        long  led1;
        long  led2;
        long  led3;
        long  dmarotate;
        long  tp;
        long  fdup;
        long  bustimer;
        long  notxint;
        long  pcnet2;
};

struct pnt_ConfigStruct pnt_ConfigArray[4] = {
    {
        0,
        NSAPS,
        0,
        0,
        -1,
        5,
        PNT_TX_BUF,
        PNT_RX_BUF,
        Scan_ALL,				/* bus to scan */
        LED0_Default,				/* led 0 */
        LED1_Default,				/* led 1 */
        LED2_Default,				/* led 2 */ 
        LED3_Default,				/* led 3 */
        0,      				/* dmarotate */
        0,      				/* TP */
        0,      				/* full duplex */
        BusTimer_Default,  			/* bus timer access */
        0,      				/* no end-of-transmit interrupt */
        0       				/* advanced features disabled */
    }
    ,
    {
        1,
        NSAPS,
        0,
        0,
        -1,
        5,
        PNT_TX_BUF,
        PNT_RX_BUF,
        Scan_ALL,				/* bus to scan */
        LED0_Default,				/* led 0 */
        LED1_Default,				/* led 1 */
        LED2_Default,				/* led 2 */ 
        LED3_Default,				/* led 3 */
        0,      				/* dmarotate */
        0,      				/* TP */
        0,      				/* full duplex */
        BusTimer_Default,  			/* bus timer access */
        0,      				/* no end-of-transmit interrupt */
        0       				/* advanced features disabled */
    }
    ,
    {
        2,
        NSAPS,
        0,
        0,
        -1,
        5,
        PNT_TX_BUF,
        PNT_RX_BUF,
        Scan_ALL,				/* bus to scan */
        LED0_Default,				/* led 0 */
        LED1_Default,				/* led 1 */
        LED2_Default,				/* led 2 */ 
        LED3_Default,				/* led 3 */
        0,      				/* dmarotate */
        0,      				/* TP */
        0,      				/* full duplex */
        BusTimer_Default,  			/* bus timer access */
        0,      				/* no end-of-transmit interrupt */
        0       				/* advanced features disabled */
    }
    ,
    {
        3,
        NSAPS,
        0,
        0,
        -1,
        5,
        PNT_TX_BUF,
        PNT_RX_BUF,
        Scan_ALL,				/* bus to scan */
        LED0_Default,				/* led 0 */
        LED1_Default,				/* led 1 */
        LED2_Default,				/* led 2 */ 
        LED3_Default,				/* led 3 */
        0,      				/* dmarotate */
        0,      				/* TP */
        0,      				/* full duplex */
        BusTimer_Default,  			/* bus timer access */
        0,      				/* no end-of-transmit interrupt */
        0       				/* advanced features disabled */
    }
};


