/* Copyright (c) 1995 ADVANCED MICRO DEVICES, INC. All Rights Reserved.
** This software is unpblished and contains the trade secrets and
** confidential proprietary information of AMD. Unless otherwise provided
** in the Software Agreement associated herewith, it is licensed in confidence
** "AS IS" and is not to be reproduced in whole or part by any means except
** for backup. Use, duplication, or disclosure by the Government is subject
** to the restrictions in paragraph (b) (3) (B) of the Rights in Technical
** Data and Computer Software clause in DFAR 52.227-7013 (a) (Oct 1988).
** Software owned by Advanced Micro Devices, Inc., 901 Thompson Place,
** Sunnyvale, CA 94088.
*/

#ifndef DOSINSTL_H_FILE
#define DOSINSTL_H_FILE

#define OK_PRESS_KEY    "Press a key when ready"
#define ERR_PRESS_KEY   "Error! - Press a key to continue."
#define ERR_DATE_MSG    "The date field is improperly formatted. Please\n"\
                        "use the format: \n"\
                        "              mmm ddd HH:MM:SS yyyy\n"\
                        "\n"\
                        "where m=month,d=day,H=hour,M=min,S=sec & y=year."\

#define MIF_TEXT_FILE   "doscolor.mif"
#define CLASS_STRING    "AMD|CSR|001"
#define DMIDIR          "c:\\dmi"

#define SCANBFRLEN      ((unsigned)1024*63) // 63K buffer to process MIF file.
#define CHRBFRLEN       256
#define DOSPATHBFRLEN   128
#define FILENAMELEN     12                  // FNAME=8, DOT=1, EXTENSION=3

#define DMI_DOS_ROOT    "c:\\dmi\\dos\\"
#define DMI_WIN_ROOT    "c:\\dmi\\win16\\"
#define DMI_OS2_ROOT    "c:\\dmi\\os2\\"
#define BIN_DIR         "bin\\"
#define MIF_DIR         "mifs\\"
#define MIF_BAK_DIR     "backup\\"
#define CUR_DIR         ".\\"
#define DOS_INSTR       "pcnet.ovl"         // DOS instrumentation.
#define WIN_INSTR       "pcnet.exe"         // Windows instrumentation.
#define OS2_INSTR       "pcnet.dll"
#define PCNETMIF_FNAME  "pcnet.mif"
#define PCNETMIF_FNBAK  "pcnet.bak"
#define ERROR_LOG       "pcneterr.log"

#define CT_AUI          "AUI"
#define CT_BNC          "10BASE-2 <BNC>"
#define CT_RJ45         "10BASE-T <RJ45>"

#define WIN_ND3         "NDIS3 (WFW 3.11 Native)"
#define DOS_OTHER       "NDIS2/ODI (DOS)"
#define OS2_OTHER       "NDIS2/ODI (OS/2)"

#define KW_NAME         "Name"
#define KW_VALUE        "Value"

#define SERIALNO        "Serial Number"
#define INSTDATE        "Installation"
#define CONNTYPE        "Connector Type"

#if !defined(SPAWN)
 #define EXPORT_         _far _loadds _export
#else
#define EXPORT_
#endif

#define P_EXPORT        EXPORT_ _pascal
#define C_EXPORT        EXPORT_ _cdecl

#define ARGCNT          2                   // # args when DoDmi... is spawned.

// This macro computes the maximum length of the path portion of a file spec.
// Note that the terminating null is not explicitly accounted for because the
// size of DMI_STRING is overstated by one byte.
#define MAXPATHLEN      (DOSPATHBFRLEN-sizeof(DMI_STRING)-FILENAMELEN)

// Length of char buffers used for miscellaneous purposes.
#define MISCBFRLEN      256

typedef enum{
  t_hexint=1,
  t_decint,
  t_str
  } TType;
typedef enum {
  _false,
  _true
  } TBool;
typedef enum {
  TerminateWithFailure,
  AllowFailure
  } SlExecutionMode;
typedef enum {
  errOk,
  errNoUpdate,
  errSrcOpenFail,
  errDstOpenFail,
  errBfrLen,
  errOpenFail,
  errFRead,
  errFWrite,
  errNoBfr,
  errNoDir,
  errSrcPathLen,
  errDstPathLen,
  errSLInvoke,
  errSLErr,
  errAccess,
  errNumParms,
  errEOF,
  errMissingOp
  } TErrCode;
typedef enum {
  noBrdr,
  snglBrdr,
  dblBrdr,
  thickBrdr
  } TBrdr;
typedef enum {
  cmNul,
  cmChr,
  cmChrExt,
  cmSetFocus,
  cmKillFocus
  } TMsgs;
typedef enum {
  wfwDvr,
  dosDvr,
  os2Dvr
  } TDvr;

// Structure used when finding attributes in the MIF file and replacing their
// existing values.
typedef struct {
    char*   pcAtrName;
    char*   pcAtrValue;             // Current value following keyword.
    char*   pcNewValue;             // New value to follow keyword.
    TType   tType;
    }       TAtrVal;

// void _FAR _cdecl confirmFunction(void _FAR *dmiMgmtCommand);
void _far _cdecl confirmFunction(void _far *dmiMgmtCommand);

static TBool slExecute(struct DmiMgmtCommand *dmiMgmtCommand, SlExecutionMode mode);
static TBool slSynchronousExecute(struct DmiMgmtCommand *dmiMgmtCommand, SlExecutionMode mode);

static void deleteComponent(char *classString);
static void slFailure(struct DmiMgmtCommand *dmiMgmtCommand);

TErrCode _cdecl mifUpdateFile(TAtrVal*,char*,char*,TDvr);
DMI_UNSIGNED /* C_EXPORT */ DoDmiInstall(char*);
int ScanInputBfr(char**, char*, TType);

_inline int file_exists(char* filename){return access(filename,0)== 0;}

_inline char* my_strrchr(const char* s, const register char c)
{
  const register char* p=s+strlen(s);
  while((*p!=c)&&(p!=s)) --p;
  return (char*)p;
}

_inline void my_strncpy(register char* d, register char* s, register int len)
{
  while(len--) *d++=*s++;
}

TErrCode makePath(char*);

#endif
 
