; Project name	:	AssemblyLibrary
; Description	:	Defines for BIOS functions.
%ifndef BIOS_FUNCTIONS_INC
%define BIOS_FUNCTIONS_INC

; BIOS interrupts
BIOS_VIDEO_INTERRUPT_10h		EQU		10h
BIOS_DISK_INTERRUPT_13h			EQU		13h
BIOS_SYSTEM_INTERRUPT_15h		EQU		15h
BIOS_KEYBOARD_INTERRUPT_16h		EQU		16h
BIOS_BOOT_FAILURE_INTERRUPT_18h	EQU		18h
BIOS_BOOT_LOADER_INTERRUPT_19h	EQU		19h
BIOS_DISKETTE_INTERRUPT_40h		EQU		40h
HD0_DPT_POINTER_41h				EQU		41h
HD1_DPT_POINTER_46h				EQU		46h

; Hardware interrupts
HARDWARE_IRQ_0_INTERRUPT_08h	EQU		08h		; System timer
HARDWARE_IRQ_1_INTERRUPT_09h	EQU		09h		; Keyboard
HARDWARE_IRQ_2_INTERRUPT_0Ah	EQU		0Ah
HARDWARE_IRQ_3_INTERRUPT_0Bh	EQU		0Bh
HARDWARE_IRQ_4_INTERRUPT_0Ch	EQU		0Ch
HARDWARE_IRQ_5_INTERRUPT_0Dh	EQU		0Dh
HARDWARE_IRQ_6_INTERRUPT_0Eh	EQU		0Eh
HARDWARE_IRQ_7_INTERRUPT_0Fh	EQU		0Fh
HARDWARE_IRQ_8_INTERRUPT_70h	EQU		70h
HARDWARE_IRQ_9_INTERRUPT_71h	EQU		71h
HARDWARE_IRQ_10_INTERRUPT_72h	EQU		72h
HARDWARE_IRQ_11_INTERRUPT_73h	EQU		73h
HARDWARE_IRQ_12_INTERRUPT_74h	EQU		74h
HARDWARE_IRQ_13_INTERRUPT_75h	EQU		75h
HARDWARE_IRQ_14_INTERRUPT_76h	EQU		76h
HARDWARE_IRQ_15_INTERRUPT_77h	EQU		77h


; BIOS video functions
SET_VIDEO_MODE					EQU		00h
SET_TEXT_MODE_CURSOR_SHAPE		EQU		01h
SET_CURSOR_POSITION				EQU		02h
GET_CURSOR_POSITION_AND_SIZE	EQU		03h
SELECT_ACTIVE_DISPLAY_PAGE		EQU		05h
TELETYPE_OUTPUT					EQU		0Eh

; BIOS disk functions
READ_SECTORS_INTO_MEMORY		EQU		02h
GET_DRIVE_PARAMETERS			EQU		08h
RESET_HARD_DISK					EQU		0Dh
GET_DISK_TYPE					EQU		15h
GET_DRIVE_INFORMATION			EQU		25h
CHECK_EXTENSIONS_PRESENT		EQU		41h
GET_EXTENDED_DRIVE_INFORMATION	EQU		48h

; BIOS system functions
OS_HOOK_DEVICE_BUSY				EQU		90h
OS_HOOK_DEVICE_POST				EQU		91h

; BIOS keyboard functions
GET_KEYSTROKE					EQU		00h
CHECK_FOR_KEYSTROKE				EQU		01h

; BIOS system functions
EVENT_WAIT						EQU		86h


%endif ; BIOS_FUNCTIONS_INC
