/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;
import java.util.Stack;

public class MicroBladePSUPowerCommand
extends MicroBladeCommand {
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() == null || this.getParameters().length != 2) {
            String s1 = ipmiMicroBladeOEMCommand.getALLPowerPresent();
            String s2 = ipmiMicroBladeOEMCommand.getALLPowerStatus();
            s1 = s1.substring(0, 8);
            s1 = MicroBladePSUPowerCommand.reverse(s1);
            s2 = s2.substring(0, 8);
            s2 = MicroBladePSUPowerCommand.reverse(s2);
            char[] ch = s2.toCharArray();
            char[] ch_present = s1.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                String isOn;
                if (ch_present[i] == '0') continue;
                String string = isOn = ch[i] == '1' ? "On" : "Off";
                if (i < 4) {
                    MOut.G(this).println("A" + (i + 1) + ": " + isOn);
                    continue;
                }
                MOut.G(this).println("B" + (i - 3) + ": " + isOn);
            }
            MOut.G(this).println("\nUsage: microbBlade psu <index> [on|off]");
        } else {
            String psuIndex = this.getParameters()[0];
            byte pIndex = (byte)PowerSupplyInfo.getIndex(psuIndex);
            if (pIndex < 0) {
                MOut.G(this).println("The PSU index must be A1-A4 or B1-B4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            pIndex = (byte)(pIndex + 1);
            boolean isOn = false;
            if (this.getParameters()[1].equalsIgnoreCase("on")) {
                isOn = true;
            } else if (this.getParameters()[1].equalsIgnoreCase("off")) {
                isOn = false;
            } else {
                MOut.G(this).println("The command must be either On or Off.");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            ipmiMicroBladeOEMCommand.setPowerStatus(pIndex, isOn);
        }
        this.statusCode = 0;
        sessionController.closeSession();
    }

    public static String reverse(String s) {
        Stack<Character> stk = new Stack<Character>();
        for (int i = 0; i < s.length(); ++i) {
            stk.push(Character.valueOf(s.charAt(i)));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(stk.pop());
        }
        return sb.toString();
    }
}

