/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.CheckboxMenuItem;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MenuLabel
extends Label
implements MouseListener,
MouseMotionListener {
    private boolean over = false;
    private PopupMenu menu;

    public MenuLabel(PopupMenu m) {
        super(m.getLabel(), 1);
        m.setLabel(null);
        this.menu = m;
        this.registerActionListener(m, new MenuListener());
        this.add(this.menu);
        this.setBackground(SystemColor.control);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void registerActionListener(Menu m, MenuListener l) {
        for (int i = 0; i < m.getItemCount(); ++i) {
            MenuItem it = m.getItem(i);
            if (it instanceof Menu) {
                this.registerActionListener((Menu)it, l);
                continue;
            }
            if (it instanceof CheckboxMenuItem) {
                ((CheckboxMenuItem)it).addItemListener(l);
                continue;
            }
            it.addActionListener(l);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.over) {
            int w = this.getSize().width - 1;
            int h = this.getSize().height - 1;
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(0, 0, w, 0);
            g.drawLine(0, 0, 0, h);
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, h, w, h);
            g.drawLine(w, 0, w, h);
        }
    }

    @Override
    public void update(Graphics g) {
        g.setColor(SystemColor.control);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        this.paint(g);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.over = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.over = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Label b = (Label)e.getSource();
        this.menu.show(b, 0, b.getSize().height);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class MenuListener
    implements ActionListener,
    ItemListener {
        MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuLabel.this.over = false;
            MenuLabel.this.repaint();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MenuLabel.this.over = false;
            MenuLabel.this.repaint();
        }
    }
}

