/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class PowerSupplyPolicyCommand
extends SuperBladeCommand {
    byte powerPolicy;

    @Override
    public void runCommand() throws Exception {
        if (this.parameters == null) {
            byte result = this.ipmiCMMOEMCommand.getPSPowerPolicy();
            switch (result) {
                case 0: {
                    MOut.G(this).println("Current policy: 0-Max power");
                    break;
                }
                case 1: {
                    MOut.G(this).println("Current policy: 1-Power redundancy N+1");
                    break;
                }
                case 2: {
                    MOut.G(this).println("Current policy: 2-Power redundancy N+N");
                    break;
                }
                default: {
                    MOut.G(this).println("Current policy: " + result + "-Unknown");
                }
            }
            this.statusCode = 0;
            this.printUsage();
        } else if (this.parameters.length == 1) {
            byte powerPolicy = 0;
            try {
                powerPolicy = Byte.parseByte(this.parameters[0]);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println("Policy format error");
                this.statusCode = 0;
                this.printUsage();
            }
            boolean result = this.ipmiCMMOEMCommand.setPSPowerPolicy(powerPolicy);
            if (result) {
                MOut.G(this).println("Set power policy done");
                this.statusCode = 0;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("\nPower policy Index:");
        MOut.G(this).println("0-Max power");
        MOut.G(this).println("1-Power redundancy N+1");
        MOut.G(this).println("2-Power redundancy N+N");
    }
}

