/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeNodeUIDLEDCommand
extends MicroBladeCommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute() throws Exception {
        ISessionController sessionController;
        block18: {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand;
            int nodeIndex;
            block19: {
                block17: {
                    if (!this.validateForCMM()) {
                        this.statusCode = 153;
                        return;
                    }
                    nodeIndex = 0;
                    ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
                    sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
                    if (sessionController == null) {
                        this.statusCode = 145;
                        return;
                    }
                    if (this.getParameters() != null) break block17;
                    MOut.G(this).println("Usage: microBlade node uid <bladeID> <nodeID> [on | off]");
                    break block18;
                }
                if (this.getParameters().length != 2) break block19;
                String bladeIndex = this.getParameters()[0];
                nodeIndex = Integer.parseInt(this.getParameters()[1]);
                byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
                if (bIndex < 0) {
                    MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                    this.statusCode = 147;
                    sessionController.closeSession();
                    return;
                }
                BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
                NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)(nodeIndex - 1));
                if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                    MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                    this.statusCode = 151;
                    sessionController.closeSession();
                    return;
                }
                if (nodeIndex < 1 || nodeIndex > 4) {
                    MOut.G(this).println("The node index must be 1-4");
                    this.statusCode = 147;
                    sessionController.closeSession();
                    return;
                }
                MOut.G(this).println("Usage: microBlade node uid <bladeID> <nodeID> [on | off]");
                byte b = ipmiMicroBladeOEMCommand.getNodeUIDLED(bIndex, nodeIndex - 1);
                if (b == 0) {
                    MOut.G(this).println("Current UID status: Off");
                    break block18;
                } else if (b == 1) {
                    MOut.G(this).println("Current UID status: On");
                }
                break block18;
            }
            if (this.getParameters().length == 3) {
                String bladeIndex = this.getParameters()[0];
                nodeIndex = Integer.parseInt(this.getParameters()[1]);
                byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
                if (bIndex < 0) {
                    MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                    this.statusCode = 147;
                    sessionController.closeSession();
                    return;
                }
                BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
                NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)(nodeIndex - 1));
                if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                    MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                    this.statusCode = 151;
                    sessionController.closeSession();
                    return;
                }
                if (nodeIndex < 1 || nodeIndex > 4) {
                    MOut.G(this).println("The node index must be 1-4");
                    this.statusCode = 147;
                    sessionController.closeSession();
                    return;
                }
                byte isOn = 0;
                if (this.getParameters()[2].equalsIgnoreCase("on")) {
                    isOn = 1;
                } else {
                    if (!this.getParameters()[2].equalsIgnoreCase("off")) {
                        MOut.G(this).println("command must be 'on' or 'off'.");
                        this.statusCode = 147;
                        sessionController.closeSession();
                        return;
                    }
                    isOn = 0;
                }
                boolean b = ipmiMicroBladeOEMCommand.setNodeUIDLED(bIndex, nodeIndex - 1, isOn);
                if (!b) {
                    MOut.G(this).println("Update UID Fail");
                    this.statusCode = 149;
                    sessionController.closeSession();
                    return;
                }
                MOut.G(this).println("set UID Successfully");
            } else {
                MOut.G(this).println("Usage: microBlade node uid <bladeID> <nodeID> [on | off]");
            }
        }
        sessionController.closeSession();
        this.statusCode = 0;
    }
}

