/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B7DBE_SensorEntity
extends AbstractMBSensorEntity {
    public static final byte DIMM_TEMP_HIGH_LIMIT = 85;
    public static final String CPU1 = "CPU1 Temp";
    public static final String CPU2 = "CPU2 Temp";
    public static final String CPU1_CORE_A = "CPU1 Core A Temp";
    public static final String CPU1_CORE_B = "CPU1 Core B Temp";
    public static final String CPU2_CORE_A = "CPU2 Core A Temp";
    public static final String CPU2_CORE_B = "CPU2 Core B Temp";
    public static final String SYSTEM_TEMP = "System Temp";
    public static final String CPU1_VOLTAGE = "CPU1 Vcore";
    public static final String CPU2_VOLTAGE = "CPU2 Vcore";
    public static final String V1P2 = "1.2V";
    public static final String CPU_VTT = "CPU VTT";
    public static final String V1P8 = "Memory Voltage";
    public static final String V1P5 = "1.5V";
    public static final String V3P3 = "3.3V";
    public static final String V12 = "12V";
    public static final String V5 = "5V";
    public static final String V5SB = "5VSB";
    public static final String BATTERY_VOLTAGE = "VBAT";
    protected byte pollCount;
    protected byte isPECI;
    protected byte remoteCPU1Temp;
    protected byte remoteCPU2Temp;
    protected byte remoteCPU3Temp;
    protected byte remoteCPU4Temp;
    protected byte systemTemp;
    protected byte cpu1CoreVoltage;
    protected byte cpu2CoreVoltage;
    protected byte v1p2;
    protected byte v1p8;
    protected byte v1p5;
    protected byte v3p3;
    protected byte v12;
    protected byte v5;
    protected byte v5sb;
    protected byte batteryVoltage;
    protected byte cpuTempHighLimit;
    protected byte systemTempHighLimit;
    protected byte[] raw;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npollCount = 0x" + ByteUtility.byteToHex(this.pollCount));
        sb.append("\nflag = 0x" + ByteUtility.byteToHex(this.flag));
        sb.append("\nisPECI = 0x" + ByteUtility.byteToHex(this.isPECI));
        sb.append("\nremoteCPU1Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU1Temp) + "(" + this.getRemoteCPU1Temp() + ")");
        sb.append("\nremoteCPU2Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU2Temp) + "(" + this.getRemoteCPU2Temp() + ")");
        sb.append("\nremoteCPU3Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU3Temp) + "(" + this.getRemoteCPU3Temp() + ")");
        sb.append("\nremoteCPU4Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU4Temp) + "(" + this.getRemoteCPU4Temp() + ")");
        sb.append("\nsystemTemp = 0x" + ByteUtility.byteToHex(this.systemTemp) + "(" + this.getSystemTemp() + ")");
        sb.append("\ncpu1CoreVoltage = 0x" + ByteUtility.byteToHex(this.cpu1CoreVoltage) + "(" + this.getCpu1CoreVoltageFormula() + ")");
        sb.append("\ncpu2CoreVoltage = 0x" + ByteUtility.byteToHex(this.cpu2CoreVoltage) + "(" + this.getCpu2CoreVoltageFormula() + ")");
        sb.append("\nv1p2 = 0x" + ByteUtility.byteToHex(this.v1p2) + "(" + this.getV1p2Formula() + ")");
        sb.append("\nv1p8 = 0x" + ByteUtility.byteToHex(this.v1p8) + "(" + this.getV1p8Formula() + ")");
        sb.append("\nv1p5 = 0x" + ByteUtility.byteToHex(this.v1p5) + "(" + this.getV1p5Formula() + ")");
        sb.append("\nv3p3 = 0x" + ByteUtility.byteToHex(this.v3p3) + "(" + this.getV3p3Formula() + ")");
        sb.append("\nv12 = 0x" + ByteUtility.byteToHex(this.v12) + "(" + this.getV12Formula() + ")");
        sb.append("\nv5 = 0x" + ByteUtility.byteToHex(this.v5) + "(" + this.getV5Formula() + ")");
        sb.append("\nv5sb = 0x" + ByteUtility.byteToHex(this.v5sb) + "(" + this.getV5sbFormula() + ")");
        sb.append("\nbatteryVoltage = 0x" + ByteUtility.byteToHex(this.batteryVoltage) + "(" + this.getBatteryVoltageFormula() + ")");
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.isPECI = raw[2];
        this.remoteCPU1Temp = raw[3];
        this.remoteCPU2Temp = raw[4];
        this.remoteCPU3Temp = raw[5];
        this.remoteCPU4Temp = raw[6];
        this.systemTemp = raw[7];
        this.cpu1CoreVoltage = raw[8];
        this.cpu2CoreVoltage = raw[9];
        this.v1p2 = raw[10];
        this.v1p8 = raw[11];
        this.v1p5 = raw[12];
        this.v3p3 = raw[13];
        this.v12 = raw[14];
        this.v5 = raw[15];
        this.v5sb = raw[16];
        this.batteryVoltage = raw[17];
        this.cpuTempHighLimit = raw[27];
        this.systemTempHighLimit = raw[28];
        this.raw = raw;
        return true;
    }

    public void setPollCount(byte pollCount) {
        this.pollCount = pollCount;
    }

    @Override
    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public void setIsPECI(byte isPECI) {
        this.isPECI = isPECI;
    }

    public void setRemoteCPU1Temp(byte remoteCPU1Temp) {
        this.remoteCPU1Temp = remoteCPU1Temp;
    }

    public void setRemoteCPU2Temp(byte remoteCPU2Temp) {
        this.remoteCPU2Temp = remoteCPU2Temp;
    }

    public void setRemoteCPU3Temp(byte remoteCPU3Temp) {
        this.remoteCPU3Temp = remoteCPU3Temp;
    }

    public void setRemoteCPU4Temp(byte remoteCPU4Temp) {
        this.remoteCPU4Temp = remoteCPU4Temp;
    }

    public void setSystemTemp(byte systemTemp) {
        this.systemTemp = systemTemp;
    }

    public void setCpu1CoreVoltage(byte cpu1CoreVoltage) {
        this.cpu1CoreVoltage = cpu1CoreVoltage;
    }

    public void setCpu2CoreVoltage(byte cpu2CoreVoltage) {
        this.cpu2CoreVoltage = cpu2CoreVoltage;
    }

    public void setV1p2(byte v1p2) {
        this.v1p2 = v1p2;
    }

    public void setV1p8(byte v1p8) {
        this.v1p8 = v1p8;
    }

    public void setV1p5(byte v1p5) {
        this.v1p5 = v1p5;
    }

    public void setV3p3(byte v3p3) {
        this.v3p3 = v3p3;
    }

    public void setV12(byte v12) {
        this.v12 = v12;
    }

    public void setV5(byte v5) {
        this.v5 = v5;
    }

    public void setV5sb(byte v5sb) {
        this.v5sb = v5sb;
    }

    public void setBatteryVoltage(byte batteryVoltage) {
        this.batteryVoltage = batteryVoltage;
    }

    public byte getPollCount() {
        return this.pollCount;
    }

    @Override
    public byte getFlag() {
        return this.flag;
    }

    public byte getIsPECI() {
        return this.isPECI;
    }

    public byte getRemoteCPU1Temp() {
        return this.remoteCPU1Temp;
    }

    public byte getRemoteCPU1TempHighLimit() {
        return 95;
    }

    public byte getRemoteCPU2Temp() {
        return this.remoteCPU2Temp;
    }

    public byte getRemoteCPU2TempHighLimit() {
        return 95;
    }

    public byte getRemoteCPU3Temp() {
        return this.remoteCPU3Temp;
    }

    public byte getRemoteCPU3TempHighLimit() {
        return 95;
    }

    public byte getRemoteCPU4Temp() {
        return this.remoteCPU4Temp;
    }

    public byte getRemoteCPU4TempHighLimit() {
        return 95;
    }

    public byte getSystemTemp() {
        return this.systemTemp;
    }

    public byte getSystemTempHighLimit() {
        return 85;
    }

    public byte getCpu1CoreVoltage() {
        return this.cpu1CoreVoltage;
    }

    public double getCpu1CoreVoltageHighLimit() {
        return 1.38;
    }

    public double getCpu1CoreVoltageLowLimit() {
        return 0.92;
    }

    public double getCpu1CoreVoltageFormula() {
        return (double)(this.cpu1CoreVoltage & 0xFF) * 0.008;
    }

    public byte getCpu2CoreVoltage() {
        return this.cpu2CoreVoltage;
    }

    public double getCpu2CoreVoltageHighLimit() {
        return 1.38;
    }

    public double getCpu2CoreVoltageLowLimit() {
        return 0.92;
    }

    public double getCpu2CoreVoltageFormula() {
        return (double)(this.cpu2CoreVoltage & 0xFF) * 0.008;
    }

    public byte getV1p2() {
        return this.v1p2;
    }

    public double getV1p2HighLimit() {
        return 1.32;
    }

    public double getV1p2LowLimit() {
        return 1.08;
    }

    public double getCPUVTTHighLimit() {
        return 1.32;
    }

    public double getCPUVTTLowLimit() {
        return 0.99;
    }

    public double getV1p2Formula() {
        return (double)(this.v1p2 & 0xFF) * 0.008;
    }

    public byte getV1p8() {
        return this.v1p8;
    }

    public double getV1p8HighLimit() {
        return 1.98;
    }

    public double getV1p8LowLimit() {
        return 1.34;
    }

    public double getV1p8Formula() {
        return (double)(this.v1p8 & 0xFF) * 0.016;
    }

    public byte getV1p5() {
        return this.v1p5;
    }

    public double getV1p5HighLimit() {
        return 1.65;
    }

    public double getV1p5LowLimit() {
        return 1.34;
    }

    public double getV1p5Formula() {
        return (double)(this.v1p5 & 0xFF) * 0.016;
    }

    public byte getV3p3() {
        return this.v3p3;
    }

    public double getV3p3HighLimit() {
        return 3.63;
    }

    public double getV3p3LowLimit() {
        return 2.96;
    }

    public double getV3p3Formula() {
        return (double)(this.v3p3 & 0xFF) * 0.016;
    }

    public byte getV12() {
        return this.v12;
    }

    public double getV12HighLimit() {
        return 13.25;
    }

    public double getV12LowLimit() {
        return 10.75;
    }

    public double getV12Formula() {
        return (double)(this.v12 & 0xFF) * 0.008 / 0.08333333333333333;
    }

    public byte getV5() {
        return this.v5;
    }

    public double getV5HighLimit() {
        return 5.5;
    }

    public double getV5LowLimit() {
        return 4.49;
    }

    public double getV5Formula() {
        return (double)(this.v5 & 0xFF) * 0.024;
    }

    public byte getV5sb() {
        return this.v5sb;
    }

    public double getV5sbHighLimit() {
        return 5.5;
    }

    public double getV5sbLowLimit() {
        return 4.49;
    }

    public double getV5sbFormula() {
        return (double)(this.v5sb & 0xFF) * 0.024;
    }

    public byte getBatteryVoltage() {
        return this.batteryVoltage;
    }

    public double getBatteryVoltageHighLimit() {
        return 3.63;
    }

    public double getBatteryVoltageLowLimit() {
        return 2.96;
    }

    public double getBatteryVoltageFormula() {
        return (double)(this.batteryVoltage & 0xFF) * 0.016;
    }

    public static void main(String[] args) {
        MB_B7DBE_SensorEntity m = new MB_B7DBE_SensorEntity();
        System.out.println(m.toString());
    }

    public int checkRemoteCPU1Temp() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU1Temp() < this.getRemoteCPU1TempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkRemoteCPU2Temp() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU2Temp() < this.getRemoteCPU2TempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkRemoteCPU3Temp() {
        if (this.getRemoteCPU3Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU3Temp() < this.getRemoteCPU3TempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkRemoteCPU4Temp() {
        if (this.getRemoteCPU4Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU4Temp() < this.getRemoteCPU4TempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkSystemTemp() {
        if (this.getSystemTemp() < this.getSystemTempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkCpu1CoreVoltage() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() <= this.getCpu1CoreVoltageLowLimit() || this.getCpu1CoreVoltageFormula() >= this.getCpu1CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCpu2CoreVoltage() {
        if (this.getIsPECI() > 0 ? this.getRemoteCPU2Temp() == -127 : this.getRemoteCPU3Temp() == -127) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() <= this.getCpu2CoreVoltageLowLimit() || this.getCpu2CoreVoltageFormula() >= this.getCpu2CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV1p2() {
        if (this.getV1p2Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p2Formula() <= this.getV1p2LowLimit() || this.getV1p2Formula() >= this.getV1p2HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCPUVTT() {
        if (this.getV1p2Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p2Formula() <= this.getCPUVTTLowLimit() || this.getV1p2Formula() >= this.getCPUVTTHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV1p5() {
        if (this.getV1p5Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p5Formula() <= this.getV1p5LowLimit() || this.getV1p5Formula() >= this.getV1p5HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV1p8() {
        if (this.getV1p8Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p8Formula() <= this.getV1p8LowLimit() || this.getV1p8Formula() >= this.getV1p8HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV3p3() {
        if (this.getV3p3Formula() == 0.0) {
            return 2;
        }
        if (this.getV3p3Formula() <= this.getV3p3LowLimit() || this.getV3p3Formula() >= this.getV3p3HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV12() {
        if (this.getV12Formula() == 0.0) {
            return 2;
        }
        if (this.getV12Formula() <= this.getV12LowLimit() || this.getV12Formula() >= this.getV12HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV5() {
        if (this.getV5Formula() == 0.0) {
            return 2;
        }
        if (this.getV5Formula() <= this.getV5LowLimit() || this.getV5Formula() >= this.getV5HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV5sb() {
        if (this.getV5sbFormula() == 0.0) {
            return 2;
        }
        if (this.getV5sbFormula() <= this.getV5sbLowLimit() || this.getV5sbFormula() >= this.getV5sbHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkBatteryVoltage() {
        if (this.getBatteryVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getBatteryVoltageFormula() <= this.getBatteryVoltageLowLimit() || this.getBatteryVoltageFormula() >= this.getBatteryVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkDIMMTemp(byte dimmTemp) {
        if (dimmTemp == 0) {
            return 2;
        }
        if ((dimmTemp & 0xFF) < 85) {
            return 0;
        }
        return 1;
    }

    protected FailureEntity generateBladeSensorFailure(BladeEntity bladeEntity, int moduleIndex, String sensor) {
        FailureEntity failureEntity = new FailureEntity();
        failureEntity.setLevel(2);
        failureEntity.setCurrentDataTime();
        failureEntity.setSourceObject(bladeEntity);
        failureEntity.setSource("Blade " + (moduleIndex + 1));
        failureEntity.setFailureItem(sensor);
        failureEntity.setFailureDetail("Reading out of range");
        return failureEntity;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            if (this.getIsPECI() > 0) {
                failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1));
            } else {
                failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_CORE_A));
            }
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            if (this.getIsPECI() > 0) {
                failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2));
            } else {
                failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_CORE_B));
            }
        }
        if (this.checkRemoteCPU3Temp() == 1 && this.getIsPECI() == 0) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_CORE_A));
        }
        if (this.checkRemoteCPU4Temp() == 1 && this.getIsPECI() == 0) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_CORE_B));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_VOLTAGE));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_VOLTAGE));
        }
        if (this.checkCPUVTT() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU_VTT));
        }
        if (this.checkV1p5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V1P5));
        }
        if (this.checkV1p8() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V1P8));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V3P3));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V12));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V5));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V5SB));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, BATTERY_VOLTAGE));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        if (this.getIsPECI() > 0) {
            this.addRaw(this.checkRemoteCPU1Temp(), CPU1, this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU1TempHighLimit()));
            this.addRaw(this.checkRemoteCPU2Temp(), CPU2, this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU2TempHighLimit()));
        } else {
            this.addRaw(this.checkRemoteCPU1Temp(), CPU1_CORE_A, this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU1TempHighLimit()));
            this.addRaw(this.checkRemoteCPU2Temp(), CPU1_CORE_B, this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU2TempHighLimit()));
            this.addRaw(this.checkRemoteCPU3Temp(), CPU2_CORE_A, this.showCandF(this.getRemoteCPU3Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU3TempHighLimit()));
            this.addRaw(this.checkRemoteCPU4Temp(), CPU2_CORE_B, this.showCandF(this.getRemoteCPU4Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU4TempHighLimit()));
        }
        this.addRaw(this.checkSystemTemp(), SYSTEM_TEMP, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        if (this.getIsPECI() > 0) {
            if (this.getRemoteCPU1Temp() == -127) {
                this.setCpu1CoreVoltage((byte)0);
            }
            if (this.getRemoteCPU2Temp() == -127) {
                this.setCpu2CoreVoltage((byte)0);
            }
        } else {
            if (this.getRemoteCPU1Temp() == -127) {
                this.setCpu1CoreVoltage((byte)0);
            }
            if (this.getRemoteCPU3Temp() == -127) {
                this.setCpu2CoreVoltage((byte)0);
            }
        }
        this.addRaw(this.checkCpu1CoreVoltage(), CPU1_VOLTAGE, this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), CPU2_VOLTAGE, this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkCPUVTT(), CPU_VTT, this.d2StrV(this.getV1p2Formula()), this.d2StrV(this.getCPUVTTLowLimit()), this.d2StrV(this.getCPUVTTHighLimit()));
        this.addRaw(this.checkV1p5(), V1P5, this.d2StrV(this.getV1p5Formula()), this.d2StrV(this.getV1p5LowLimit()), this.d2StrV(this.getV1p5HighLimit()));
        this.addRaw(this.checkV1p8(), V1P8, this.d2StrV(this.getV1p8Formula()), this.d2StrV(this.getV1p8LowLimit()), this.d2StrV(this.getV1p8HighLimit()));
        this.addRaw(this.checkV3p3(), V3P3, this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV12(), V12, this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkV5(), V5, this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), V5SB, this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5sbLowLimit()), this.d2StrV(this.getV5sbHighLimit()));
        this.addRaw(this.checkBatteryVoltage(), BATTERY_VOLTAGE, this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        if (this.getIsPECI() > 0) {
            list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), CPU1, this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU1TempHighLimit())));
            list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), CPU2, this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU2TempHighLimit())));
        } else {
            list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), CPU1_CORE_A, this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU1TempHighLimit())));
            list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), CPU1_CORE_B, this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU2TempHighLimit())));
            list.add(this.createTemperatureData(this.checkRemoteCPU3Temp(), CPU2_CORE_A, this.showCandF(this.getRemoteCPU3Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU3TempHighLimit())));
            list.add(this.createTemperatureData(this.checkRemoteCPU4Temp(), CPU2_CORE_B, this.showCandF(this.getRemoteCPU4Temp()), "N/A", "" + this.showCandF(this.getRemoteCPU4TempHighLimit())));
        }
        list.add(this.createTemperatureData(this.checkSystemTemp(), SYSTEM_TEMP, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        return list;
    }
}

