@echo off
rem /******************************************/
rem /* DEMO batch file for the KAF4200F.CAM   */
rem /* and KAF4200E.CAM logical camera files. */
rem /******************************************/

if "%1"=="4" goto extmode
if "%1"=="5" goto extmode
if "%1"=="6" goto frmode
if "%1"=="7" goto frmode

echo.
echo Bad or missing command-tail parameter.
echo Usage:  DEMO [camera mode]
echo.
echo Where camera mode should be the selected KAF-4200 camera
echo mode, according to it's rear switch setting.  Choose one
echo of the following:
echo   4 or 5 = External Control Single Line Readout mode.
echo   6 or 7 = Free-Running Single Line Readout mode.
echo.
goto exitthis

:extmode
imdownl -a shell.out
imldcam logcam\kaf4200e.cam 3 -a
cls
rem /*=======================================================*/
rem /* The following lines are for testting the KAF4200E.CAM */
rem /* logical camera file.  Camera mode is External Control */
rem /* (Mode 4 or 5).                                        */
rem /*=======================================================*/
echo This demonstration uses the KAF4200E.CAM logical camera file.
echo Please make sure the KAF-4200 camera is in mode 4 or 5.
echo This is the External Control mode.
grab\grabtest 3 2
goto exitthis

:frmode
imdownl -a shell.out
imldcam logcam\kaf4200f.cam 3 -a
cls
rem /*=======================================================*/
rem /* The following lines are for testting the KAF4200F.CAM */
rem /* logical camera file.  Camera mode is Free-Running     */
rem /* (Mode 6 or 7).                                        */
rem /*=======================================================*/
echo This demonstration uses the KAF4200F.CAM logical camera file.
echo Please make sure the KAF-4200 camera is in mode 6 or 7.
echo This is the Free-Running mode.
grab\grabtest 3 1

:exitthis
