/*

    filename :  open.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/* all conditionnal compilations switches in imseries.h */

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#if defined(I_UNIX) && defined(I_INTEL)
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif /*I_UNIX && I_INTEL */

#ifdef I_OS2
#include <process.h>
#endif

#if defined(I_MS_DOS)
#include <sys\types.h>
#include <sys\timeb.h>
#ifdef ANSI
#include <stdlib.h>
#endif
#endif /* I_MS_DOS */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifdef  I_PHYSMAP
#define BUFSIZE 20 * 1024   /* 20k is necessary to have a 16k buffer on a  */
							/* 4k boudary */
#define MAPSIZE 16 * 1024
#endif /* I_PHYSMAP */

#ifdef PHAR_LAP
_far unsigned long *AllocSegment(unsigned long, unsigned long);
#endif /* PHAR_LAP */

#ifdef WIN_NT
// dpet
int mapmem( void **ptr,unsigned long device);
#endif

#ifdef I_USE_ASM
#ifdef ANSI
void FTYPE _i_s_movmem286 ( void far *src, void far * dst, unsigned short count, unsigned short sizefactor );
void FTYPE _i_s_movmem386 ( void far *src, void far * dst, unsigned short count, unsigned short sizefactor );
void FTYPE _segtodsc ( void far *ptr );
void FTYPE _dpmicpuid ( void far *ptr );
void FTYPE cpuid( void far *buf );
#else
FTYPE _i_s_movmem286 ();
FTYPE _i_s_movmem386 ();
void FTYPE _segtodsc ();
void FTYPE _dpmicpuid ();
#endif
#endif

extern  I_IMGLOB    i_glob;

/* use for dummy operation */
static short dummy;


/* Special time variables for DLL */
/* We need it to be in the default data segment for using C library */
#ifdef __DLL__
static struct timeb 		time0, time1;
#endif

#ifdef ANSI
#ifdef PHAR_LAP
extern void FTYPE cpuid(void *buf);
#endif
static short check_map(short device);
static short refadr_check(IMGHRA *hra);
#endif /* ANSI */

/****************/
#define DELAY 50L
/****************/

static struct
   {
   char host_cpu_type;
   char dum[21];
   }
   info;

/* function pointer for io routines. used to switch between 286 & 386 code */
#if (!defined ( I_UNIX )) && (!defined ( I_386_ONLY )) && defined ( I_USE_ASM )
#ifdef ANSI
void ( FTYPE * _i_s_movmem ) ( void far *src, void far * dst,
 unsigned short count, unsigned short sizefactor );
#else
void ( FTYPE * _i_s_movmem ) ( );
#endif
#endif

/*/     Function:   ioopdevice()
*       Synopsis:   open IM-1280 driver.
*
*       Date:       February 12, 1990
*
*       Parameter:  unsigned long device : #define constant to identify
*                   the board to open.
*                   short flag : type of access permitted.
*
*       Return value:   a file handle
*
*       Anything requiring clarification:
*         MATROX internal info.:
*              On MS DOS systems, if bit 31 of device is set no checking
*              is done on the presence/absence of IMAGE board. It is a way
*              of forcing the opening of the device.
*
**/

#ifdef  ANSI
static unsigned short chk_align ( void )
#else
static unsigned short chk_align ()
#endif
{
#ifdef  ANSI
    size_t size;
#else
    int size;
#endif

    size = sizeof ( HRA );

    if ( size != I_HRASIZE ) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
        printf("IM-SERIES C-binding : fatal error.\n");
        printf("Data structures not aligned on byte boundaries.\n");
        printf("Please recompile library with proper flags.\n");
        printf("Program aborted.\n");
# else
        fprintf( stderr, "IM-SERIES C-binding : fatal error.\n");
        fprintf( stderr, "Data structures not aligned on byte boundaries.\n");
        fprintf( stderr, "Please recompile library with proper flags.\n");
        fprintf( stderr, "Program aborted.\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
        exit ( 1 );
    }

  return ( TRUE );

} /* chk_align () */


#ifdef  ANSI
int FTYPE ioopdevice(unsigned long device, short flag)
#else
int FTYPE ioopdevice(device, flag)
unsigned long   device;
short           flag;
#endif
/*************************** Start of UNIX code ***************************/
#ifdef  I_UNIX
{
    int fd;

#ifdef  I_PHYSMAP

#endif /* I_PHYSMAP */

    /* test to validate clibrary compilation */
    chk_align();

    /* open driver, return handle */
#if defined(I_INTEL)
    fd = open ( i_glob.driver[device], O_RDWR );
#else
    fd = open ( i_glob.driver[device], flag );
#endif

    if ( fd == -1 )
        return( -1 );

#ifdef  I_PHYSMAP

    /* allocate memory for virtual map */

#ifndef I_SCO /* On SCO, the driver allocates the memory. */

    /* i_glob.mem :	holds the true address of malloc ( not rounded off )
       i_glob.addr :	rounded off value to 4k boundary.
     */

    if (( i_glob.mem[device] = (IMGMAP *) malloc ( BUFSIZE )) == NULL) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
        printf("IM-Series: ioopdevice(), out of memory for malloc.\n" );
# else
        fprintf( stderr, "IM-Series: ioopdevice(), out of memory for malloc.\n" );
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
        return( -1 );
        }

    i_glob.img_addr[device]=(IMGMAP *)(((unsigned long)i_glob.mem[device]+0x0FFFL)&~0x0FFFL);
#else
    i_glob.img_addr[device] = NULL;	/* Address generates by img driver */
#endif /* I_SCO */

    /* map to pysical space */
    ioctl ( fd, IMG_MAPBOARD, &(i_glob.img_addr[device]) );

    /* put file descriptor into table */
    i_glob.fd[device] = fd;

#if  defined(I_INTEL)
    /* mmap() : Check virtual mapping for memory mapped devices. */

    i_glob.img_addr[device] = (IMGMAP *) mmap ( 0, MAPSIZE, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0 );
#endif /* I_INTEL */

    return(fd);

#endif /* I_PHYSMAP */

} /* ioopdevice() */
#endif /* I_UNIX */
/*************************** End of UNIX code ***************************/

/*************************** Start of MS DOS code ***************************/
#ifdef  I_MS_DOS
{
    unsigned long bypass_check;

    /* test to validate library compilation */
    chk_align();

    /* Under MS DOS, bit 31 says if checking of presence of IMAGE board
       is to be bypassed. */
    bypass_check = device & 0x80000000L;

    /* Clear bit 31 of device */
    device &= 0x7fffffffL;

/* dummy operation */
    dummy += flag;

    if ( device )
        {

        /* Get physical address of device. */
#ifdef PHAR_LAP
        /* SHey 93/05/03 Corrected bug. Convert physical pointer to long */
        /* for AllocSegment first parameter. Also removed extra ")"      */
        /* caracter                                                      */
        i_glob.img_addr[device] =
         (IMGMAP *)AllocSegment((unsigned long)MAP_IMAGE( device ),16);
#else
        i_glob.img_addr[(unsigned short)device] = MAP_IMAGE( device );
#endif

/* SHey 93/05/03 Added PHARLAP_286 for new PHARLAP support */
/* SHey 94/03/07 Addes WATCOM for WATCOM compiler support */
#if defined( __DLL__ ) || defined( PHARLAP_286 ) || defined( WATCOM )

		_segtodsc ( i_glob.img_addr + ( unsigned short ) device );

#endif

/* dpet 94/05/03 Added WIN_NT support */
#if defined( WIN_NT )

      // when mapmem return -1, something wrong happens...
      if (-1 == mapmem( (i_glob.img_addr + ( unsigned short ) device) , device))
          return( -1 );

#endif
        /* Cancel checking if wanted */
        if (!bypass_check)
           {
           if ( check_map( (unsigned short)device ) == -1 )
               {

               /* Abort open. */

               i_glob.img_addr[(unsigned short)device] = (IMGMAP *)NULL;

               return( -1 );

               }
           }

        /* update global. */
        i_glob.img_fd[(unsigned short)device] = (unsigned short)device;

        /* keep host control register configuration */
        /* this permits the user to call programs from os shells */
        i_glob.keep_hctrl[(unsigned short)device] = IOselect((unsigned short)device);

#ifdef PHAR_LAP

        /* SHey 93/05/03 Corrected bug. Was doing == instead of = */
        info.host_cpu_type = CPU_80386;
#else

#ifdef I_USE_ASM
/* SHey 93/05/03 Added PHARLAP_286 for new PHARLAP support */
/* SHey 94/03/07 Addes WATCOM for WATCOM compiler support */
/* dpet 94/05/05 Added WIN_NT for Windows NT support */
#if defined( WIN_NT)
    info.host_cpu_type = CPU_80386;
#else
# if defined( __DLL__ ) || defined( PHARLAP_286 ) || defined( WATCOM )

		_dpmicpuid((char far *)&info);

# else

        cpuid((char far *)&info);

# endif
#endif
        if (info.host_cpu_type >= CPU_80386)
            {
            i_glob.host_cpu_type = CPU_80386;   /* allow 32-bit access */
#ifdef I_USE_ASM
			_i_s_movmem = _i_s_movmem386;
#endif
            }
        else
            {
            i_glob.host_cpu_type = CPU_80286; /* allow only 16-bit access */
#ifdef I_USE_ASM
			_i_s_movmem = _i_s_movmem286;
#endif
            }
#else
            i_glob.host_cpu_type = CPU_80286; /* allow only 16-bit access */
#endif

#endif /* PHAR_LAP */

        }

    return((int)device);
} /* ioopdevice() */

static short check_map(short device)
{
    IMGHRA *hra;

    /* get address of supposed host register area */
    hra = &(( (IMGMAP *) i_glob.img_addr[device] ) -> hra[ (device - 1) & 1 ] );

    /* Check if an IM1280 board exist at this address. */
    /* perform various tests to try to catch error condition ( bad address ) */

    /* Verification #1: HCTRL bit 0 (RESET) should be cleared */

    if ( hra -> hctrl & 1 )
        return ( -1 ); /* IMAGE board not recognized */

    /* Verification #2: ADR registers HOST_IMASK and HOST_IID values should
                        be coherent */

    if ( hra -> host_iid & ( ~ ( hra -> host_imask )))
        return ( -1 ); /* IMAGE board not recognized */

    /* Verification #3: GSP REFADR register should change periodically */

    if ( refadr_check( hra ) )
        return( -1 ); /* IMAGE board not recognized */

    return( 0 );

} /* check_map() */

static short refadr_check(IMGHRA *hra)
{
  unsigned short 		temp1, temp2, temp3;

  /* Declared static at beginning of file */
  #ifndef __DLL__
  struct timeb 		time0, time1;
  #endif

  signed long		 difference;

  if ( ((hra -> config) & 0x1800) == 0x1800 )
     {
     /* Bits RR2 and RR1 are set, no DRAM refreshes are done by GSP. No
        conclusion can be made since REFADR does not toggle. */
     return ( 1 );
     }
  else
     {
     /* If an IMAGE is present, REFADR must toggle */

     temp1 = hra -> refadr;

     ftime(&time0);
     while ( 1 )
        {
        ftime(&time1);
	     difference  = ((signed long) time1.time) - ((signed long)time0.time);
   	  difference *= (signed long)1000L;
     	  difference += ((signed long) time1.millitm) - ((signed long)time0.millitm);
		  /* 18.2 =  1 seconde */
        if ( difference >= DELAY )
           break;
        }

     temp2 = hra -> refadr;

     ftime(&time0);
     while ( 1 )
        {
        ftime(&time1);
	     difference  = ((signed long) time1.time) - ((signed long)time0.time);
   	  difference *= (signed long)1000L;
     	  difference += ((signed long) time1.millitm) - ((signed long)time0.millitm);
        /* 18.2 =  1 seconde */
        if ( difference >= DELAY )
           break;
        }

     temp3 = hra -> refadr;

     /* If 2 values (or more) between temp1, temp2 and temp3 are different,
        an IMAGE board has been found */
     if ( (temp1 != temp2) || (temp1 != temp3) || (temp2 != temp3) )
        return( 0 ); /* EUREKA !!! */
     else
        return( 1 ); /* NO, not our board... */
     }

} /* refadr_check() */

#endif /* I_MS_DOS */
/*************************** End of MS DOS code ***************************/

/*************************** Start of OS2 code ***************************/
#ifdef  I_OS2
{

   HFILE  fh;                 /* file handle */
   USHORT status;             /* status returned */
   PSZ pfname;                /* pointer to file name */
   PHFILE pfh = &fh;          /* pointer to file handle */
   PUSHORT pstatus = &status; /* pointer to status returned */
   USHORT retval;
   long selector;
   long temp;

   /* test to validate library compilation */
   chk_align();

   /* dummy operation */
   dummy += flag;


   pfname = (PSZ) i_glob.driver[device];
   retval =
    DosOpen( (PSZ) pfname,     /* device name */
             (PHFILE) pfh,     /* pointer to file handle */
             (PUSHORT) pstatus,/* pointer to status returned */
             (ULONG)  0L,      /* filesize - not important */
             (USHORT) 0x0,     /* FILE_NORMAL - r\w */
             (USHORT) 0x01,    /* FILE_OPEN   */
             (USHORT) 0x0042,  /* OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE*/
             (ULONG)  0L);     /* reserved - must be 0 */

    if (retval != 0) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
       printf("\nIM-Series : ioopdevice(), error opening device.\n");
# else
       fprintf( stderr, "\nIM-Series : ioopdevice(), error opening device.\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
       return( -1 );
    }

#ifdef  I_PHYSMAP
    /* map to physical space */
    if (iomapboard(I_LOWMAP, 0, 0, &selector, fh))
       return( -1 );

    i_glob.host_cpu_type = CPU_80386; /* allow only 16-bit access */
    /* want to place selector in segment portion */
    temp = selector;
    i_glob.img_addr[device] = (IMGMAP *)(temp << 16);

	 /* Initialize i_s_movmem */
	_i_s_movmem = _i_s_movmem386;

	 /* put file descripor into table */
    i_glob.fd[device] = fh;

    return(fh);

#else /* I_PHYSMAP */

    return(fh);

#endif /* I_PHYSMAP */
} /* ioopdevice() */

#ifdef ANSI
short FTYPE iomapboard(unsigned short memflag, unsigned short memloc,
                       unsigned short memsiz, unsigned long far *bufsel,
                       HFILE  fh)      /* file handle */
#else
short FTYPE iomapboard(memflag, memloc, memsiz, bufsel, fh)
unsigned short memflag;
unsigned short memloc;
unsigned short memsiz;
unsigned long far *bufsel;
HFILE  fh;      /* file handle */
#endif /* ANSI */
{
    MEMINFO mem;
    PMEMINFO pmem=&mem;

    mem.memflag = memflag;
    mem.memloc  = memloc;
    mem.memsiz  = memsiz;
    if (DosDevIOCtl((PULONG)bufsel,(PMEMINFO)pmem,(USHORT)I_MAPBOARD,(USHORT)0x80,(HFILE)fh)!=0) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
        printf( "\nIM-Series: ioopdevice(), error mapping board to memory\n");
# else
        fprintf( stderr, "\nIM-Series: ioopdevice(), error mapping board to memory\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
        return(-1);
    }
  return(0);

} /* iomapboard() */
#endif /* I_OS2 */

/*************************** End of OS2 code ***************************/

