/*
    filename :  ioputmbu.c

COPYRIGHT (c) 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#ifdef I_UNIX
extern  I_IMGLOB    i_glob;
#endif

/*/     Function:   ioputmbuf()
*       Synopsis:   This routine writes a buffer to the FIFO.
*       Date:       January 7, 1991
*       param:
*                                               
*       returns:    no return value
**/

#ifdef  ANSI
void FTYPE ioputmbuf(unsigned short _I_PTYPE * _I_PTYPE *buffers,
					 unsigned short _I_PTYPE *ns, unsigned short n )
#else
FTYPE ioputmbuf( buffers, ns, n )
unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns, n;
#endif
{
#ifdef  I_UNIX

    I_IOMBUF iombuf;

    iombuf.buffers = buffers;
    iombuf.ns = ns;
    iombuf.n = n;

    ioctl ( i_glob.board, IMG_IOPUTMBUF, &iombuf );

#endif

#ifdef  I_MS_DOS

    while ( n-- )
        ioputbuf ( (short _I_PTYPE *) *buffers++, *ns++ );

#endif

#ifdef  I_OS2

    /* this code should be replaced by a driver call to avoid */
    /* context switches between buffers */
    while ( n-- )
        ioputbuf ( *buffers++, *ns++ );

#endif

} /* ioputmbuf() */
