/*/
* filter.c -- Image-1280 Windows 3.0 demo
*
* (c) Matrox Electronic Systems    April 1992
*
* This demo loads an image from disk and allows you to define an ROI with
* the mouse.  You can then perform various pre-defined filtering operations
* on the ROI.
*/

#include <windows.h>
#include <string.h>
#include <imseries.h>
#include <i_head.h>
#include <proto.h>
#include "filter.h"


#define APP_FILTERS	0
#define MAXBUFSIZE	0xf000

void OkMessageBox(HWND, char *, char *);

HANDLE hInst;

static old_x = 0;
static old_y = 39;

BOOL bTrack = FALSE;     		// TRUE if left button clicked
int OrgX = 0, OrgY = 0;  		// original cursor position
int PrevX = 0, PrevY = 0;		// current cursor position
int X = 0, Y = 0;        		// last cursor position
RECT Rect;               		// selection rectangle
FilterChoice = IDM_PREWITT;	 	// selected filter

BOOL original_palette = TRUE;
short current_app = APP_FILTERS;

short BorderWidth = 0;			// border width
short yHeight = 0;				// height of caption + menu bars + y border

char ImgFile[15];

char *filter[] =
	{
	"Prewitt",
	"Sharpening",
	"Horizontal Edge",
	"Vertical Edge",
	"Morphological Gradient",
	"Sobel Compass Gradient"
	};
 
#define NFILTER (sizeof(filter) / sizeof(filter[0]))

HWND hwnd;				// main window
HWND hFWnd;				// handle to Filter selection area
HWND hWndFilter[NFILTER];
HWND hWndFGroup;
HWND hWndFile;			// for 'File' listbox
HWND hWndLut;

static short xChar = 7;
static short yChar = 16;

short dcmasks[6];

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
	{
   MSG msg;
   int imhdl;

   imhdl = ioopdevice(I_LIN_AIN_LOW,0);
   iosldevice(imhdl);
   ioslmemdevice(imhdl);

   // Inquire for masks on FBs and overlay
   // im1280 win driver set overlay masks and they do not need to be changed!
   //  dcmask[0] for FB red         dcmask[3] for overlay red      
   //  dcmask[1] for FB green       dcmask[4] for overlay green    
   //  dcmask[2] for FB blue        dcmask[5] for overlay blue     
   pciqsys(I_IQ_DCMASKS,dcmasks);

	// clean up fb1
   ShowCursor(FALSE);
	krgcdi();
	pcstfborg(I_FB2X2KX1KX8);
	krhwslcsurf(I_FB_SURF1);
	krhwsclr(0);
	krhwslcsurf(I_OVL_SURF);
	krgcen();
   ShowCursor(TRUE);

	// set up the FBs properly. Keep overlay masks untoutched!
	lsdcstrdmask(-1, -1, -1, dcmasks[3], dcmasks[4], dcmasks[5]);

   if (!hPrevInstance)
		{
		if (!InitApplication(hInstance))
		    return (FALSE);
		}

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(&msg, NULL, NULL, NULL))
		{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
    	}

   return (msg.wParam);
	} // WinMain


BOOL InitApplication(hInstance)
HANDLE hInstance;
	{
   WNDCLASS  wc;

   wc.style          = NULL;
   wc.lpfnWndProc    = MainWndProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInstance;
   wc.hIcon          = NULL;
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);

   // Check if transparent color is black or dark green
   //  im1280 win driver sets masks on r,g and b for overlay to 0x1d
   //  when it is a driver used with WinSel strap
   if (dcmasks[3]==0x1d) /* Is green transparent? */
      wc.hbrBackground  = CreateSolidBrush(RGB(0,128,0));
   else
      wc.hbrBackground  = GetStockObject(BLACK_BRUSH);


   wc.lpszMenuName   = "FilterMenu";
   wc.lpszClassName  = "ImagewinWClass";

   return (RegisterClass(&wc));
	} // InitApplication


BOOL InitInstance(hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
	{
	HDC hDC;
	TEXTMETRIC tm;
	short i;

   hInst = hInstance;

   hwnd = CreateWindow( "ImagewinWClass",
        	               "Image-1280 Image-Processing Demo",
        	               WS_CAPTION | WS_SYSMENU | WS_CLIPCHILDREN | WS_MINIMIZEBOX,
        	               0,
        	               0,
			               0,
			               0,
        	               NULL,
        	               NULL,
        	               hInstance,
        	               NULL
    		             );

   if (!hwnd)
      return (FALSE);

	// create grey static window for button area
 	hFWnd = CreateWindow( "static",
				             NULL,
				             WS_CHILD | WS_VISIBLE | SS_WHITERECT,
				             0, 0, 0, 0,
				             hwnd,
				             9,
				             hInstance,
				             NULL
				             );

   if (!hFWnd)
		{
		DestroyWindow(hwnd);
		return (NULL);
    	}

	// create push buttons for different filters
	for (i = 0; i < NFILTER; ++i)
		{
		hWndFilter[i] = 
			CreateWindow("button",
				          filter[i],
				          WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				          0, 0, 0, 0,
				          hwnd,
				          i,
				          hInst,
				          NULL
			            );
		}

	hWndFGroup = 
		CreateWindow(  "button",
			            " Filters ",
			            WS_CHILD | WS_VISIBLE | BS_GROUPBOX,
			            0, 0, 0, 0,
			            hwnd,
			            10,
			            hInst,
			            NULL
			         );

	// create list box for 'File'
	hDC = GetDC(hwnd);
	GetTextMetrics(hDC, &tm);
	ReleaseDC(hwnd, hDC);


	hWndFile =
		CreateWindow(  "listbox",
			            "Image Files",
			            WS_CHILD | WS_CAPTION | LBS_STANDARD | LBS_NOREDRAW,
			            tm.tmAveCharWidth, tm.tmHeight,
			            tm.tmAveCharWidth * 13 + GetSystemMetrics(SM_CXVSCROLL),
			            tm.tmHeight * 10,
			            hwnd,
			            11,
			            hInst,
			            NULL
			         );

   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

	BorderWidth = GetSystemMetrics(SM_CXBORDER);
	yHeight = GetSystemMetrics(SM_CYCAPTION) + GetSystemMetrics(SM_CYMENU) +
			    GetSystemMetrics(SM_CYBORDER);

   return (TRUE);
	} // InitInstance


long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
   FARPROC lpProcAbout;
	HDC hDC;
	PAINTSTRUCT ps;
	OFSTRUCT of;
	TEXTMETRIC tm;
	short i;

   switch (message)
		{
		case WM_SIZE:
			if (SIZEICONIC != wParam)
				{
				// Set sizes of all windows
				hDC = GetDC(hWnd);
				GetTextMetrics(hDC, &tm);
				yChar = tm.tmHeight;
				xChar = tm.tmAveCharWidth;
				ReleaseDC(hWnd, hDC);

				MoveWindow(hwnd, 0, 0, 950 + (27 * xChar) + 7, 900, TRUE);
				MoveWindow(hFWnd, 951, 0, 27 * xChar, 900, TRUE);
				MoveWindow(hWndFGroup, 954, 0, 26 * xChar, 
                       2 * yChar * (NFILTER + 1), TRUE);
				for (i = 0; i < NFILTER; ++i)
					{
					MoveWindow(hWndFilter[i], 958, yChar + (2 * yChar * i) + 8,
											  25 * xChar, 2 * yChar, TRUE);
					}
				}

			break;

    	case WM_SETFOCUS:
    	    SetFocus (hwnd);
    	    break;

		case WM_COMMAND:
		    switch (wParam)
				{
            case IDM_EXIT:
					// clean up FBs before exit
					ShowCursor(FALSE);
					krgcdi();
					lsdcstmsbsource(I_FBPAL);
					lsdcstdmode(I_FB01_2K_1K_8);
					lsdcstopal(1);
					krhwslcsurf(I_FB_SURF1);
					krhwsclr(0);
					krhwslcsurf(I_FB_SURF0);
					krhwsclr(0);
					krhwslfborg(I_2FB_2KX1KX8);
					krhwslcsurf(I_FB_SURF0);
					krhwslcsurf(I_OVL_SURF);
					krgcen();
					ShowCursor(TRUE);
              	DestroyWindow(hWnd);
              	break;
    
            // edit menu commands
				case IDM_UNDO:
					undo();
					InvalidateRect(hWnd, NULL, TRUE);
					break;

            case IDM_SAVE:
            case IDM_SAVEAS:
            case IDM_PRINT:
            case IDM_CUT:
            case IDM_COPY:
            case IDM_PASTE:
            case IDM_CLEAR:
            case IDM_LIVE:
            case IDM_STILL:
               MessageBox(GetFocus(),
                          "Command not implemented",
                          "Matrox Image-Processing Demo",
                          MB_ICONASTERISK | MB_OK);
               break;

				case IDM_ABOUT:
					lpProcAbout = MakeProcInstance(About, hInst);

					DialogBox(hInst,"AboutBox",hWnd,lpProcAbout);

					FreeProcInstance(lpProcAbout);
					break;

				case 0:
					current_app = APP_FILTERS;
			      ShowCursor(FALSE);
					krgcdi();
				   enhance(OrgX + BorderWidth, OrgY + yHeight, 
					        PrevX + BorderWidth, PrevY + yHeight, IDM_PREWITT);
					krgcen();
			      ShowCursor(TRUE);
					break;

				case 1:
					current_app = APP_FILTERS;
			      ShowCursor(FALSE);
					krgcdi();
				   enhance(OrgX + BorderWidth, OrgY + yHeight, 
				    		  PrevX + BorderWidth, PrevY + yHeight, IDM_SHARP1);
					krgcen();
			      ShowCursor(TRUE);
					break;

				case 2:
					current_app = APP_FILTERS;
			      ShowCursor(FALSE);
					krgcdi();
				   enhance(OrgX + BorderWidth, OrgY + yHeight, 
				    		  PrevX + BorderWidth, PrevY + yHeight, IDM_HOREDGE);
					krgcen();
			      ShowCursor(TRUE);
					break;

				case 3:
					current_app = APP_FILTERS;
			      ShowCursor(FALSE);
					krgcdi();
				   enhance(OrgX + BorderWidth, OrgY + yHeight, 
				    		  PrevX + BorderWidth, PrevY + yHeight, IDM_VERTEDGE);
					krgcen();
			      ShowCursor(TRUE);
					break;

				case 4:
					current_app = APP_FILTERS;
			      ShowCursor(FALSE);
					krgcdi();
				   enhance(OrgX + BorderWidth, OrgY + yHeight, 
				    		  PrevX + BorderWidth, PrevY + yHeight, IDM_MORPHGRAD);
					krgcen();
			      ShowCursor(TRUE);
					break;

				case 5:
					current_app = APP_FILTERS;
			      ShowCursor(FALSE);
					krgcdi();
				   enhance(OrgX + BorderWidth, OrgY + yHeight, 
				    		  PrevX + BorderWidth, PrevY + yHeight, IDM_SOBEL);
					krgcen();
			      ShowCursor(TRUE);
					break;

				case IDM_OPEN:
					if (HIWORD(lParam) == BN_CLICKED)
						{
						// display list box
						SendMessage(hWndFile, LB_DIR, 0, (LONG)(LPSTR)"*.img");
						SendMessage(hWndFile, WM_SETREDRAW, TRUE, 0L);
						ShowWindow(hWndFile, SW_SHOWNORMAL);
						}

					break;

				case 11:
					{
					short i;
					char *ptr;

					if (HIWORD(lParam) == LBN_DBLCLK)
						{
						if ((i = (WORD )SendMessage(hWndFile,
										LB_GETCURSEL, 0, 0L)) != LB_ERR)
							{
							SendMessage(hWndFile, LB_GETTEXT, i,
										(LONG )(LPSTR)ImgFile);

							// clear the list box and remove it
							SendMessage(hWndFile, LB_RESETCONTENT, 0, 0L);
							ShowWindow(hWndFile, SW_HIDE);

							// load the image
							SetCursor(LoadCursor(NULL, IDC_WAIT));
							ReadFile(hInst, hWnd, &of, ImgFile);
							SetCursor(LoadCursor(NULL, IDC_ARROW));

							// set ROI for destination
							enhance_init();
							restore();		// restore the zoomed image
							lsdcstopal(3);	// use strange palette
							fbcpbtob(I_FB1 | I_ROI0, I_FB0 | I_ROI0, 0L, 0L, 
										2);		// zoom it by 2
							InvalidateRect(hWnd, NULL, TRUE);
							}
						}
					}
					break;

				default:
					return(DefWindowProc(hWnd, message, wParam, lParam));
				}

			break;

		case WM_DESTROY:
	      lsdcstrdmask(0, 0, 0, dcmasks[3], dcmasks[4], dcmasks[5]);
			ShowCursor(FALSE);
			krgcdi();
			lsdcstmsbsource(I_FBPAL);
			lsdcstdmode(I_FB01_2K_1K_8);
			lsdcstopal(1);
			krhwslcsurf(I_FB_SURF1);
			krhwsclr(0);
			krhwslcsurf(I_FB_SURF0);
			krhwsclr(0);
			krhwslcsurf(I_OVL_SURF);
			krgcen();
			ShowCursor(TRUE);
		   PostQuitMessage(0);
		   break;

		case WM_CREATE:
			// set ROI for destination
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			ShowCursor(FALSE);
			krgcdi();
			pcstroipos(0, 0, 0);
			pcstroisiz(512, 480);
			enhance_init();
			krgcen();
			ShowCursor(TRUE);

			SetCursor(LoadCursor(NULL, IDC_ARROW));
			break;

        case WM_RBUTTONDOWN:
			undo();
			break;

        case WM_LBUTTONDOWN:
			bTrack = TRUE;
			PrevX = (LOWORD(lParam) + 2 ) & 0xfffc;
			PrevY = HIWORD(lParam);
			if (!(wParam & MK_SHIFT))
				{
				// If shift key is not pressed
				OrgX = (LOWORD(lParam) + 2) & 0xfffc;
				OrgY = HIWORD(lParam);
				}

			// Capture all input even if the mouse goes outside of window
			SetCapture(hWnd);

			SetCursor(LoadCursor(NULL, IDC_CROSS));
			break;

        case WM_MOUSEMOVE:
            {
            RECT rectClient;
            int NextX;
            int NextY;

            if (bTrack)
			      {
            	NextX = LOWORD(lParam);
            	NextY = HIWORD(lParam);

            	// Do not draw outside the window's client area
            	GetClientRect (hWnd, &rectClient);
            	if (NextX < rectClient.left)
            		NextX = rectClient.left;
				   else
					   {
					   if (NextX >= rectClient.right)
            			NextX = rectClient.right - 1;
					   }

            	if (NextY < rectClient.top)
            		NextY = rectClient.top;
				   else
					   {
					   if (NextY >= rectClient.bottom)
            			NextY = rectClient.bottom - 1;
					   }

            	// If the mouse position has changed, then clear the
            	// previous rectangle and draw the new one.
            	if ((NextX != PrevX) || (NextY != PrevY))
					   {
            		hDC = GetDC(hWnd);
            		SetROP2(hDC, R2_NOT);          // Erase previous box
            		MoveTo(hDC, OrgX, OrgY);
            		LineTo(hDC, OrgX, PrevY);
            		LineTo(hDC, PrevX, PrevY);
            		LineTo(hDC, PrevX, OrgY);
            		LineTo(hDC, OrgX, OrgY);

            		// Get current mouse position
            		PrevX = NextX;
            		PrevY = NextY;
            		MoveTo(hDC, OrgX, OrgY);        // Draw new box
            		LineTo(hDC, OrgX, PrevY);
            		LineTo(hDC, PrevX, PrevY);
            		LineTo(hDC, PrevX, OrgY);
            		LineTo(hDC, OrgX, OrgY);
            		ReleaseDC(hWnd, hDC);
            		}
            	}
            }

            break;

        case WM_LBUTTONUP:	   
            bTrack = FALSE;         // Ignores mouse input
			   SetCursor(LoadCursor(NULL, IDC_ARROW));
            ReleaseCapture();  		// Releases hold on mouse input

            X = LOWORD(lParam);		// Saves the current value
            Y = HIWORD(lParam);
            break;

		default:
		    return (DefWindowProc(hWnd, message, wParam, lParam));
    	}

   return (NULL);
	} // MainEndProc


BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
    switch (message)
		{
		case WM_INITDIALOG:
		    return (TRUE);

		case WM_COMMAND:
		    if ((wParam == IDOK) || (wParam == IDCANCEL))
				{
				EndDialog(hDlg, TRUE);
				return (TRUE);
		    	}

		    break;
    	}
    return (FALSE);
	} // About


undo()
	{
	switch (current_app)
		{
		case APP_FILTERS:
			ShowCursor(FALSE);
			krgcdi();
			restore();		// restore the zoomed image
			lsdcstopal(3);	// use strange palette
			krgcen();
			ShowCursor(TRUE);
			break;
		}
	} // undo


BOOL ReadFile(HANDLE hInstance, HWND hwnd, POFSTRUCT pof, char *szFileName)
	{
	DWORD dwLength;
	HANDLE hFile, hImgBuffer;
	LPSTR lpImgBuffer;

	if (-1 == OpenFile(szFileName, pof, OF_READ | OF_EXIST))
		{
		MessageBeep(0);
		OkMessageBox(hwnd, "Cannot open file %s", szFileName);
		return(FALSE);
		}

	if (-1 == (hFile = OpenFile(szFileName, pof, OF_READ)))
		{
		OkMessageBox(hwnd, "Cannot open file %s", szFileName);
		return(FALSE);
		}

   dwLength = MAXBUFSIZE;

	if (NULL == (hImgBuffer = GlobalAlloc(GHND, (DWORD )dwLength)))
		{
		_lclose(hFile);
		OkMessageBox(hwnd, "Cannot allocate memory for %s", szFileName);
		return(FALSE);
		}

	lpImgBuffer = GlobalLock(hImgBuffer);

	ShowCursor(FALSE);
   krgcdi();
	krhwslfborg(I_2FB_2KX1KX8);
	krhwslcsurf(I_FB_SURF1);

	// Read image into FB1
	ioldfbarea(I_FB_SURF1, hFile, 0, 0, 511, 479, lpImgBuffer, dwLength);

	krhwslcsurf(I_OVL_SURF);
   krgcen();
	ShowCursor(TRUE);

	_lclose(hFile);
	GlobalUnlock(hImgBuffer);
	GlobalFree(hImgBuffer);
	return(TRUE);
	} // ReadFile


void OkMessageBox(hwnd, szStr, szFileName)
HWND hwnd;
char *szStr;
char *szFileName;
	{
	char szBuffer[40];

	wsprintf(szBuffer, szStr, (LPSTR)szFileName);
	MessageBox(hwnd, szBuffer, "FileIO", MB_OK | MB_ICONEXCLAMATION);
	} // OkMessageBox


