TITLE 12/16/83 TEST5  EXCEPTION INTERRUPT HANDLER
.XLIST
INCLUDE DSEG.SRC
INCLUDE POSTEQU.SRC
INCLUDE SYSDATA.INC
.LIST
PUBLIC	POST5
PUBLIC	EXC_00
PUBLIC	EXC_01
PUBLIC	EXC_02
PUBLIC	EXC_03
PUBLIC	EXC_04
PUBLIC	EXC_05
PUBLIC	EXC_06
PUBLIC	EXC_07
PUBLIC	EXC_08
PUBLIC	EXC_09
PUBLIC	EXC_10
PUBLIC	EXC_11
PUBLIC	EXC_12
PUBLIC	EXC_13
PUBLIC	EXC_14
PUBLIC	EXC_15
PUBLIC	EXC_16
PUBLIC	EXC_17
PUBLIC	EXC_18
PUBLIC	EXC_19
PUBLIC	EXC_20
PUBLIC	EXC_21
PUBLIC	EXC_22
PUBLIC	EXC_23
PUBLIC	EXC_24
PUBLIC	EXC_25
PUBLIC	EXC_26
PUBLIC	EXC_27
PUBLIC	EXC_28
PUBLIC	EXC_29
PUBLIC	EXC_30
PUBLIC	EXC_31

PUBLIC	SYS_32
PUBLIC	SYS_33
PUBLIC	SYS_34
PUBLIC	SYS_35
PUBLIC	SYS_36
PUBLIC	SYS_37
PUBLIC	SYS_38

INCLUDE SEGMENT.SRC


;----------------------------------------
;	EXCEPTION INTERRUPT ROUTINE	:
;----------------------------------------

	ASSUME	CS:CODE,DS:ABS0

POST5:
EXC_00:
	MOV	AL,90H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_01:
	MOV	AL,91H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_02:
	MOV	AL,92H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_03:
	MOV	AL,93H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_04:
	MOV	AL,94H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_05:

	PUSH	ES

	MOV	AX,ES_TEMP		; LOAD ES REGISTER
	MOV	ES,AX			;

;------- FIX BOUND PARAMETERS

	SUB	DI,DI			; POINT BEGINNING OF THE BLOCK
	MOV	WORD PTR ES:[DI],0	; SET FIRST WORD TO ZERO

	MOV	WORD PTR ES:[DI+2],07FFFH ; SET SECOND TO 07FFFH
	POP	ES

	MOV	AL,95H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_06:
	MOV	AL,96H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_07:
	MOV	AL,97H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_08:
	MOV	AL,98H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_09:
	MOV	AL,99H			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_10:
	MOV	AL,9AH			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_11:
	MOV	AL,9BH			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_12:
	MOV	AL,9CH			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_13:
	MOV	AL,9DH			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_14:
	MOV	AL,9EH			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_15:
	MOV	AL,9FH			;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_16:
	MOV	AL,0A0H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_17:
	MOV	AL,0A1H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_18:
	MOV	AL,0A2H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_19:
	MOV	AL,0A2H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_20:
	MOV	AL,0A3H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_21:
	MOV	AL,0A4H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_22:
	MOV	AL,0A5H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_23:
	MOV	AL,0A6H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_24:
	MOV	AL,0A7H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_25:
	MOV	AL,0A8H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_26:
	MOV	AL,0A9H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_27:
	MOV	AL,0AAH 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_28:
	MOV	AL,0ABH 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_29:
	MOV	AL,0ACH 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_30:
	MOV	AL,0ADH 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED
EXC_31:
	MOV	AL,0AEH 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF EXCEPTION WAS EXPECTED

SYS_32:
	MOV	AL,0AFH 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_33:
	MOV	AL,0B0H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_34:
	MOV	AL,0B1H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_35:
	MOV	AL,0B2H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_36:
	MOV	AL,0B3H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_37:
	MOV	AL,0B4H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
SYS_38:
	MOV	AL,0B5H 		;<><><>SET CHECKPOINT<><><><>
	JMP	TEST_EXC		; GO TEST IF INTERRUPT WAS EXPECTED
TEST_EXC:
	OUT	MFG_PORT,AL		; OUTPUT THE CHECKPOINT
	CMP	AL,0AEH 		; CHECK FOR EXCEPTION
	JA	TEST_EXC0		; GO IF A SYSTEM INT

	PUSH	DS			; SAVE THE CURRENT DATA SEGMENT
	PUSH	AX			;
	MOV	AX,GDT_PTR		;
	MOV	DS,AX			;
	MOV	DS:ES_TEMP.SEG_LIMIT,MAX_SEG_LEN
	MOV	BYTE PTR DS:(ES_TEMP.DATA_ACC_RIGHTS),CPL0_DATA_ACCESS
	MOV	AX,ES_TEMP
	MOV	ES,AX
	POP	AX			; RESTORE REGS
	POP	DS
	POP	DX			; CHECK IF CODE SEG SECOND ON STACK
	POP	CX
	PUSH	CX			;
	CMP	CX,SYS_ROM_CS		;
	JNZ	TEST_EXC0		; CONTINUE IF ERROR CODE
	PUSH	DX			; PUT SEGMENT BACK ON STACK

TEST_EXC0:
	XCHG	AH,AL			; SAVE THE CHECKPOINT
	IN	AL,DMA_PAGE+0AH 	;
	CMP	AL,AH			; WAS THE EXCEPTION EXPECTED?
	JZ	TEST_EXC3		; GO IF YES
TEST_EXC1:
	IN	AL,MFG_PORT		; CHECK THE CURRENT CHKPT
	CMP	AL,03BH 		;  HALT IF CHKPT BELOW 3BH
	JB	TEST_EXC2		;
	IRET				;
TEST_EXC2:
	XCHG	AH,AL			; OUTPUT THE CURRENT CHECKPOINT
	OUT	MFG_PORT,AL		; <><><> CKPT 90 THRU B5 <><><>

	HLT
	JMP	TEST_EXC2		; INSURE SYSTEM HALT
TEST_EXC3:
	SUB	AL,AL			; CLEAR DMA PAGE
	OUT	DMA_PAGE+0AH,AL 	;
	MOV	AX,0100H		; USED FOR BOUND INSTR EXPECTED INT5
	IRET				; RETURN
CODE	ENDS
	END
