TITLE	SYSINIT1 - 09/26/83 INITIALIZE FOR PROTECTED MODE (POST TEST)
;
;	SYSINIT1 Include files
;
;		INCLUDE SYSDATA.INC
;		INCLUDE ACCESS.INC
;		INCLUDE SYSDATA.MAC
;		INCLUDE IAPX286.MAC
;		INCLUDE POSTEQU.SRC
	.XLIST
		INCLUDE SYSDATA.INC
		INCLUDE IAPX286.MAC
		INCLUDE POSTEQU.SRC
	.LIST
		PUBLIC	SYSINIT1

		EXTRN	SIDT_BLD:NEAR
		EXTRN	GDT_BLD:NEAR
INCLUDE SEGMENT.SRC
		ASSUME CS:CODE
		ASSUME SS:NOTHING
		ASSUME DS:NOTHING
		ASSUME ES:NOTHING
PAGE
SYSINIT1	PROC	NEAR
;--------------------------------------------------------------------
;	THIS BUILDS THE DESCRIPTOR TABLES REQUIRED FOR PROTECTED MODE
;		PROCESSOR MUST BE IN REAL MODE
;--------------------------------------------------------------------

	CLI				; NO INTERRUPTS ALLOWED
	PUSH	BP			; SAVE BP
	MOV	AL,81H			;<><><><><><><><><><><><><>
	OUT	MFG_PORT,AL		;<><><>CHECKPOINT 81 <><><>
	CALL	SIDT_BLD
	MOV	BP,DI			; SAVE THE POINTER TO JUST PAST THE IDT
					; SINCE WE HAVE NO SDA, USE THE SIX BYTES
					;   HERE TO LOAD THE IDTR. WE WILL SIDT
					;   WHEN WE GET TO SDA INITIALIZATION.
	MOV	AX,SYS_IDT_LEN		; SEGMENT LIMIT = LENGTH OF IDT
	STOSW				; STORE THAT AS IDT LIMIT
	MOV	AX,SYS_IDT_LOC		; IDT ADDRESS
	STOSW				;   AND ACCESS RIGHTS BYTE (UNDEFINED)
	MOV	AX,0			;
	STOSW				;
	SEGOV	ES			; LOAD THE IDT
	LIDT	[BP]			;   REGISTER FROM THIS AREA
	MOV	DI,BP			; ES:DI NOW --> END OF IDT AGAIN

;
;	BUILD THE GDT.
;

	MOV	DI,GDT_LOC		  ;
	CALL	GDT_BLD
	MOV	BP,DI			; SAVE THE ES:DI POINTER
	MOV	AX,GDT_LEN		; AX = LENGTH OF THE GDT
	STOSW				; PUT THAT IN THE LIMIT FIELD
	MOV	AX,GDT_LOC		; AX = LOW WORD OF GDT ADDRESS
	STOSW				; PUT THAT IN BASE FIELD - LOW
	MOV	AX,0			; AX = HIGH BYTE OF ADDRESS, AND
	STOSW				;   ACCESS RIGHTS BYTE 15 UNDEFINED
	SEGOV	ES			; LOAD THE GDTR
	LGDT	[BP]			;   FROM THIS AREA
	MOV	DI,BP			; RESTORE THE ES:DI POINTER
	STOSW
	STOSW
	MOV	DI,BP

PAGE
;
;	SWITCH TO VIRTUAL MODE
;

	POP	BP				; RESTORE BP
	MOV	AX,VIRTUAL_ENABLE		; MACHINE STATUS WORD NEEDED TO
	LMSW	AX				;  SWITCH TO VIRTUAL MODE
	JUMPFAR DONE,SYS_ROM_CS 		; MUST PURGE PRE-FETCH QUEUE
DONE:
	MOV	AL,85H				;<><><><><><><><><><><><><><>
	OUT	MFG_PORT,AL			;<><><>CHECKPOINT 82 <><><><>
	RET	0				; SYSTEM INITIALIZATION
SYSINIT1	ENDP
CODE		ENDS
		END
