;-------------------------------------------------------------------------------
;	PROTECTED MODE EQUATES FOR POST TESTS AND BIOS ROUTINES 	       :
;-------------------------------------------------------------------------------

;-----		LENGTH EQUATES FOR PROTECTED MODE TESTS

SDA_LEN 	EQU	00300H		; SYSTEM DATA AREA LENGTH
SYS_IDT_LEN	EQU	256*8		; 256 SYSTEM IDT ENTRIES, 8 BYTES EACH
GDT_LEN 	EQU	TYPE GDT_DEF	; GDT STRUCTURE LENGTH
DESC_LEN	EQU	TYPE DATA_DESC	; LENGTH OF A DESCRIPTOR
MCRT_SIZE	EQU	4*1024		; MONOCHROME CRT SIZE
CCRT_SIZE	EQU	16*1024 	; COMPATIBLE COLOR CRT SIZE
ECCRT_SIZE	EQU	0FFFFH		; SIZE OF EACH PORTION OF THE ENHANCED
MAX_SEG_LEN	EQU	0FFFFH		; MAXIMUM SEGMENT LENGTH = 64K
NULL_SEG_LEN	EQU	00000H		; NULL SEGMENT LENGTH = 0

;-----		LOCATION EQUATES FOR PROTECTED MODE TESTS

SYS_IDT_LOC	EQU	0D0A0H		; THE SYSTEM IDT IS AT THE BOTTOM
SDA_LOC 	EQU	00400H		; SAME AS REAL
GDT_LOC 	EQU	(SYS_IDT_LOC + SYS_IDT_LEN)
MCRT@_LO	EQU	0000H		; MONOCHROME CRT ADDRESS
MCRT@_HI	EQU	0BH		; (0B0000H)
CCRT@_LO	EQU	8000H		; COMPATIBLE COLOR CRT ADDRESS
CCRT@_HI	EQU	0BH		; (0B8000H)
ECCRT@_LO_LO	EQU	0000H
ECCRT@_LO_HI	EQU	0AH		; (0A0000H)
ECCRT@_HI_LO	EQU	0000H
ECCRT@_HI_HI	EQU	0CH		; (0C0000H)
CSEG@_LO	EQU	0000H		; CODE SEGMENT POST/BIOS
CSEG@_HI	EQU	0FH		; (0F0000H) FOR TESTS
NSEG@_LO	EQU	0000H		; ABS0
NSEG@_HI	EQU	00H

;-----	DEFINITIONS FOR ACCESS RIGHTS BYTES

CPL3_DATA_ACCESS	EQU	11110011B	; PRESENT
						; DPL = 3
						; CODE/DATA SEGMENT
						; NOT EXECUTABLE
						; GROW-UP (OFFSET <= LIMIT)
						; WRITABLE
						; ACCESSED
CPL0_DATA_ACCESS	EQU	10010011B	; DPL = 0
CPL0_CODE_ACCESS	EQU	10011011B	; CPL 0 - NON-CONFORMING
LDT_DESC		EQU	11100010B
FREE_TSS		EQU	10000001B
INT_GATE		EQU	10000110B
TRAP_GATE		EQU	10000111B

VIRTUAL_ENABLE		EQU	0000000000000001B     ; PROTECTED MODE ENABLE


;-----	THE GLOBAL DESCRIPTOR TABLE DEFINITION FOR POWER ON SELF TESTS

GDT_DEF 	STRUC
		DQ	?		; UNUSED ENTRY
GDT_PTR 	DQ	?		; THIS ENTRY POINTS TO THIS TABLE
SYS_IDT_PTR	DQ	?		; POST INTERRUPT DESCRIPTOR TABLE
RSDA_PTR	DQ	?		; THE REAL SYSTEM DATA AREA FOR POST
C_BWCRT_PTR	DQ	?		; COMPATIBLE BW CRT FOR POST
C_CCRT_PTR	DQ	?		; COMPATIBLE COLOR CRT FOR POST
E_CCRT_PTR	DQ	?		; ENHANCED COLOR GRAPHICS CRT (16 BYTES)
E_CCRT_PTR2	DQ	?
SYS_ROM_CS	DQ	?		; CS - POST IDT, ROM RESIDENT
ES_TEMP 	DQ	?		; DYNAMIC POINTER FOR ES
CS_TEMP 	DQ	?		; DYNAMIC POINTER FOR CS
SS_TEMP 	DQ	?		; DYNAMIC POINTER FOR SS
DS_TEMP 	DQ	?		; DYNAMIC POINTER FOR DS
POST_TR 	DQ	?		; TR VALUE FOR THIS MACHINE'S TSS
POST_TSS_PTR	DQ	?
POST_LDTR	DQ	?		; LDTR VALUE FOR THIS MACHINE'S LDT
POST_LDT_PTR	DQ	?
GDT_DEF 	ENDS

;-----	SEGMENT DESCRIPTOR TABLE ENTRY STRUCTURE

DATA_DESC	STRUC
SEG_LIMIT	DW	?		; SEGMENT LIMIT (1 - 65535 BYTES)
BASE_LO_WORD	DW	?		; 24 BIT SEGMENT PHYSICAL
BASE_HI_BYTE	DB	?		;	ADDRESS (0 - (16M-1))
DATA_ACC_RIGHTS DB	?		; ACCESS RIGHTS BYTE
DATA_RESERVED	DW	?		; RESERVED - MUST BE 0000 FOR THE 80286
DATA_DESC	ENDS

;-----	GATE DESCRIPTOR TABLE ENTRY STRUCTURE

GATE_DESC	STRUC
ENTRY_POINT	DW	?		; DESTINATION ROUTINE ENTRY POINT
CS_SECECTOR	DW	?		; SELECTOR FOR DESTINATION SEGMENT
WORD_COUNT	DB	?		; NUMBER OF WORDS TO COPY FROM STACK
GATE_ACC_RIGHTS DB	?		; ACCESS RIGHTS BYTE
GATE_RESERVED	DW	?		; RESERVED - MUST BE 0000 FOR THE 80286
GATE_DESC	ENDS
