/****************************************************************************
*
*  File              : UTILFILE.C
*  Date Created      : 1/18/92
*  Description       : 
*                      
*
*  Programmer(s)     : Ryan Hanlon
*  Last Modification : 
*
*  Additional Notes  :
*
*****************************************************************************
*            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          *
****************************************************************************/
#include <dos.h>
#include <stdlib.h>
#include "cvxutil.h"

#define _IO_BLOCK_SIZE 0xF000

// Function to write to a file using int 21h ah=40h
//
WORD  cvxFileWrite ( HANDLE fileHandle, LPSTR buffer,
                     LONG bufferSize,   LONG * bytesWritten )
{
   WORD bufferSeg, bufferOff;
   WORD bytesToWrite;
   BYTE carryFlag;

   // Initialize bytesWritten
   *bytesWritten = 0L;

   // Calculate which is larger : The amount of data left to write
   // to file or 32K.
   bytesToWrite = ( WORD )( min( ( LONG )(bufferSize - *bytesWritten), 
                                 ( LONG )_IO_BLOCK_SIZE) );

   // Loop until entire file has been written.
   while( bytesToWrite > 0 )
   {
      // Get starting location of buffer.
      //
      bufferOff = FP_OFF( buffer );
      bufferSeg = FP_SEG( buffer );

      // Set up registers for file write.
      //
      _asm   mov   bx, fileHandle        // File handle

      _asm   mov   cx, bytesToWrite      // Number of bytes to write to file.

      _asm   mov   dx, bufferOff         // Buffer address in DS:AX
      _asm   mov   ax, bufferSeg         //
      _asm   push  ds                    //
      _asm   mov   ds, ax                //

      _asm   mov   ah, 40h               // Write to file or device
      _asm   int   21h                   //

      _asm   pop   ds                    //

      _asm   mov   bytesToWrite, ax      // AX contains error code or the actual
                                         // number of bytes written to file.

      _asm   lahf                        // Get state of carry flag.
      _asm   and   ah, 1                 //
      _asm   mov   carryFlag, ah         //

      if( !carryFlag )
      {
         // If disk is full then return error.
         //
         if( !bytesToWrite )
         {
            return( _ERROR_DISK_FULL );
         }
         else
         {
            // Increment to next 'block' of data to be written to file.
            //
            ( HPSTR )buffer += bytesToWrite;

            // Increment return value
            *bytesWritten += bytesToWrite;
      
            // Calculate which is larger : The amount of data left to write
            // to file or 32K.
            bytesToWrite = ( WORD )( min( ( LONG )(bufferSize - *bytesWritten), 
                                          ( LONG )_IO_BLOCK_SIZE) );
         }

      }
      else
      {
         switch( bytesToWrite )
         {
            case 5 :
               return( _ERROR_ACCESS_DENIED );

            case 6 :
               return( _ERROR_INVALID_HANDLE );

            default:
               return( _ERROR_FILE_READ_FAILED );
         }
      }
   }

   return( _ERROR_NONE );

}



// 
WORD cvxFileRead( HANDLE fileHandle, LPSTR buffer,
                  LONG bufferSize,   LONG * bytesRead )
{
   WORD bufferSeg, bufferOff;
   LONG bytesToRead;
   BYTE carryFlag;
   LONG tempBytesRead;

   // Initialize bytesRead
   //
   *bytesRead = 0L;

   // Calculate which is larger : The amount of data left to read
   // from file or 32K.
   if( (bytesToRead = (bufferSize - *bytesRead) ) > (LONG)_IO_BLOCK_SIZE )
   {
      bytesToRead = (LONG)_IO_BLOCK_SIZE;
   }

   // Loop until entire file has been read or until a read error occurs.
   //
   while( bytesToRead > 0L )
   {
      // Get starting location of buffer.
      //
      bufferOff = FP_OFF( buffer );
      bufferSeg = FP_SEG( buffer );

      // Set up registers for file read.
      //
      _asm   mov   bx, fileHandle            // File handle

      _asm   mov   cx, WORD PTR bytesToRead  // Number of bytes to read to file.

      _asm   mov   dx, bufferOff             // Buffer address in DS:AX
      _asm   mov   ax, bufferSeg             //
      _asm   push  ds                        //
      _asm   mov   ds, ax                    //

      _asm   mov   ax, 3F00h                 // Read from file or device
      _asm   int   21h                       //

      _asm   pop   ds                        //

      _asm   mov   WORD PTR bytesToRead, ax  // AX will contain an error code
                                             // or the actual bytes read.

      _asm   lahf                            // Get state of carry flag.
      _asm   and   ah, 1                     //
      _asm   mov   carryFlag, ah             //

      if( !carryFlag )
      {
         // Increment to next 'block' of data to be read to file.
         //
         ( HPSTR )buffer += bytesToRead;

         if( bytesToRead )
         {
            // Increment return value
            *bytesRead += bytesToRead;
         
            // Calculate which is larger : The amount of data left to read
            // from file or 32K.
            if( (bytesToRead = (bufferSize - *bytesRead)) > (LONG)_IO_BLOCK_SIZE )
                bytesToRead = (LONG)_IO_BLOCK_SIZE;

         }
      }
      else
      {
         switch( bytesToRead )
         {
            case 5L :
               return( _ERROR_ACCESS_DENIED );
         
            case 6L :
               return( _ERROR_INVALID_HANDLE );

            default:
               return( _ERROR_FILE_READ_FAILED );
         }
      }
   }

   return( _ERROR_NONE );
}


//
WORD cvxFileOpen( LPSTR fileName, BYTE fileAccess, HANDLE * fileHandle )
{
   HANDLE tempHandle;
   BYTE   carryFlag;
   WORD   tempSeg;
   WORD   tempOff;

   tempSeg = FP_SEG( fileName );
   tempOff = FP_OFF( fileName );

   _asm   mov   ah, 3Dh               // Open file function
   _asm   mov   al, fileAccess        // File access mode

   _asm   mov   dx, tempOff           // Seg:Offset of fileName
   _asm   mov   bx, tempSeg           // into DS:DX
   _asm   push  ds                    //
   _asm   mov   ds, bx                //

   _asm   int   21h                   //
   _asm   pop   ds                    //

   _asm   mov   tempHandle, ax        // AX will either contain an error
                                      // code or the file handle.

   _asm   lahf                        // Get state of carry flag.
   _asm   and   ah, 1                 //
   _asm   mov   carryFlag, ah         //

   // If error occured then the error code will be in
   // the tempHandle variable.
   //
   if( carryFlag )
   {
      switch( tempHandle )
      {
         case 2 :
            return( _ERROR_FILE_NOT_FOUND );
   
         case 3 :
            return( _ERROR_PATH_NOT_FOUND );

         case 4 :
            return( _ERROR_TOO_MANY_FILES_OPEN );

         case 5 :
            return( _ERROR_ACCESS_DENIED );

         case 12 :
            return( _ERROR_INVALID_ACCESS );

         default : 
            return( _ERROR_FILE_OPEN );
      }
   }

   // No error occured so assigned handle.
   *fileHandle = tempHandle;

   return( _ERROR_NONE );

}

//
WORD cvxFileCreate( LPSTR fileName, WORD fileAttribute, HANDLE * fileHandle )
{
   HANDLE tempHandle;
   BYTE   carryFlag;
   WORD   tempSeg;
   WORD   tempOff;

   tempSeg = FP_SEG( fileName );
   tempOff = FP_OFF( fileName );

   _asm   mov   ah, 3Ch               // Create file function
   _asm   mov   cx, fileAttribute     // Create mode

   _asm   mov   dx, tempOff           // Seg:Offset of fileName
   _asm   mov   bx, tempSeg           // into DS:DX
   _asm   push  ds                    //
   _asm   mov   ds, bx                //

   _asm   int   21h                   //
   _asm   pop   ds                    //

   _asm   mov   tempHandle, ax        // AX will either contain an error
                                      // code or the file handle.

   _asm   lahf                        // Get state of carry flag.
   _asm   and   ah, 1                 //
   _asm   mov   carryFlag, ah         //

   // If error occured then the error code will be in
   // the tempHandle variable.
   //
   if( carryFlag )
   {
      switch( tempHandle )
      {
         case 3 :
            return( _ERROR_PATH_NOT_FOUND );

         case 4 :
            return( _ERROR_TOO_MANY_FILES_OPEN );

         case 5 :
            return( _ERROR_ACCESS_DENIED );

         default : 
            return( _ERROR_FILE_CREATE );
      }
   }

   // No error occured so assigned handle.
   *fileHandle = tempHandle;

   return( _ERROR_NONE );

}


//
WORD cvxFileClose( HANDLE fileHandle )
{
   BYTE   carryFlag;

   _asm   mov   ah, 3Eh
   _asm   mov   bx, fileHandle

   _asm   int   21h

   _asm   lahf                        // Get state of carry flag.
   _asm   and   ah, 1                 //
   _asm   mov   carryFlag, ah         //

   if( carryFlag )
   {
      return( _ERROR_INVALID_HANDLE );
   }
   else
   {
      return( _ERROR_NONE );
   }
}
