/****************************************************************************
*
*  File              : UTILERR.C
*  Date Created      : 2/24/92
*  Description       : This function returns a string that corresponds with a
*                      passed numerical Covox Developers Toolkit error value.
*                      
*
*  Programmer(s)     : Ryan Hanlon
*  Last Modification : 
*
*  Additional Notes  :
*
*****************************************************************************
*            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          *
****************************************************************************/

#include "cvxutil.h"
#include "cvxdigi.h"
#include "cvxfmsy.h"
#include "cvxmidi.h"


//
PSTR cvxGetErrorString ( WORD errorValue )
{

   switch( errorValue )
   {
   
      case _ERROR_NONE :
         return( "No error" );
   
      case _ERROR_PORT_INIT_FAILED :
         return( "Unable to find specified port. ");

      case _ERROR_INVALID_BUFFER_SIZE :
         return( "BufferSize was found to be zero or less than 16." );

      case _ERROR_INVALID_FORMAT :
         return( "Buffer format different from call type." );

      case _ERROR_PLAY8_BUSY :
         return( "play8 function already active. " );
   
      case _ERROR_DURING_UNPACK_FIRST :
      case _ERROR_DURING_UNPACK_NEXT :
      case _ERROR_DURING_PACK_FIRST :
      case _ERROR_DURING_PACK_NEXT :
         return( "error during pack/unpack" );
   
      case _ERROR_DMA_DETECT_FAILED :
         return( "VM port, IRQ and channel not found." );

      case _ERROR_DMA_ALREADY_INITIALIZED :
         return( "dmaInit called more than once." );

      case _ERROR_DMA_NOT_INITIALIZED :
         return( "dmaInit not called first." );

      case _ERROR_QUEUE_FULL:
         return( "No room in queue for DMA I/O request." );
   
      case _ERROR_ALREADY_RESIDENT :
         return( "A call was made to tsrStart after TSRPLAY had been previously installed." );

      case _ERROR_FILE_COUNT :
         return( "File count is out of range." );

      case _ERROR_OPENING_FILE :
         return( "File name not found or error opening file." );

      case _ERROR_ILLEGAL_BUFFER_SIZE :
         return( "Buffer size is out of range." );

      case _ERROR_ILLEGAL_BUFFER_COUNT :
         return( "Buffer count is out of range." );

      case _ERROR_ILLEGAL_PORT :
         return( "dma Port is not valid." );

      case _ERROR_ILLEGAL_DMA_CHANNEL :
         return( "dma Channel is not valid." );

      case _ERROR_ILLEGAL_IRQ :
         return( "IRQ Number is not valid." );

      case _ERROR_DMA_INIT_FAILED :
         return( "Initialization of DMA failed." );

      case _ERROR_DMA_UNINIT_FAILED :
         return( "Uninitialization of DMA failed." );

      case _ERROR_DMA_PLAY_FAILED :
         return( "Insert DMA queue playback request failed." );

      case _ERROR_WRONG_DOS_VERSION :
         return( "DOS version is less than 3.1" );
   
      case _ERROR_INVALID_PORT :
         return( "Invalid FM port sent to fmInit" );

      case _ERROR_SYSTEM_NOT_INITIALIZED :
         return( "System has not been initialized." );

      case _ERROR_INVALID_VOICE_FOR_MODE :
         return( "An invalid voice was specified." );

      case _ERROR_INVALID_INSTRUMENT :
         return( "An invalid instrument was specified." );

      case _ERROR_INSTRUMENT_NOT_DEFINED :
         return( "Specified instrument was not defined." );

      case _ERROR_VOICE_NOT_ACTIVATED :
         return( "Specified voice not turned on." );

      case _ERROR_INVALID_VOICE : 
         return( "Specified voice does not exist." );

      case _ERROR_VOICE_OUT_OF_RANGE :
         return( " Voice out of range for current mode. " );
   
      case _ERROR_NOT_ENOUGH_MEMORY :
         return( "Insufficient memory available in system" );

      case _ERROR_MEMORY_ALLOC :
         return( "Error during memory allocation." );

      case _ERROR_MEMORY_DEALLOC : 
         return( "Error during memory deallocation." );

      case _ERROR_INVALID_HANDLE :
         return( "File not open." );

      case _ERROR_FILE_WRITE_FAILED : 
         return( "Unknown file write failure." );

      case _ERROR_FILE_READ_FAILED :
         return( "Unknown file read failure." );

      case _ERROR_FILE_NOT_FOUND:
         return( "Non-existent file given in cvxFileOpen." );

      case _ERROR_PATH_NOT_FOUND: 
         return( "Invalid path given." );

      case _ERROR_TOO_MANY_FILES_OPEN :
         return( "No more handles available in system." );

      case _ERROR_ACCESS_DENIED :
         return( "File access denied." );

      case _ERROR_INVALID_ACCESS :
         return( "Invalid mode during open/create." );

      case _ERROR_DISK_FULL :
         return( "Destination file or disk full." );

      case _ERROR_FILE_CREATE :
         return("Unknown file creation error.");

      case _ERROR_FILE_OPEN :
         return("Unknown file open error.");

      default :
         return( _NULL );
   
   }


}


