;****************************************************************************
;
;  File              : rec8.asm
;  Date Created      : 6/89
;  Description       : 8 bit record routine callable from C.
;
;  Last Modification : February 2, 1992
;
;  Additional Notes  :
;
;****************************************************************************
;            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved
;****************************************************************************

IFNDEF NO_DOS_SEG
  DOSSEG
ENDIF


      INCLUDE model.inc
      INCLUDE recplay.inc
      INCLUDE covox.inc

      EXTRN   _sr_header:BYTE

      EXTRN   recordByteInit:PROC
      EXTRN   recordByteUninit:PROC
      EXTRN   recordByte:PROC
      EXTRN   _sr_stop_io:PROC

      .DATA

saved_db_seg      DW  ?
saved_db_off      DW  ?
saved_dsize_msw   DW  ?
saved_dsize_lsw   DW  ?
dsize_msw         DW  ?
dsize_lsw         DW  ?
stk_rate          DW  ?

      .CODE

      PUBLIC  record8

;*********************************************************************
;**
;**  record8:  Records 8 bit PCM speech.
;**
;**  Called by C as: record8(start, size, rate, port_in);
;**  C declaration:  long record8(void far *, long, int, unsigned int);
;**
;**  The returned long is the size in bytes of the recorded buffer.  If the
;**  value is 0, then an error occurred in the parameters passed.  The
;**  parameters passed have the following ranges:
;**
;**   start:  SEGMENT:OFFSET of buffer where speech will be recorded.  The
;**      offset must be on an even paragraph boundary.
;**   size:   A long value of the number of bytes in the buffer.  If the
;**      value is not divisible by 16, the remainder will be ignored.
;**      The value must be larger then 32 or an error will result.
;**   rate:   If 0, default (132) is used.  If greater then 209 record8
;**      aborts.  Otherwise the value is used as is.
;**      On the Tandy version, the default is 28.  Otherwise the above
;**      still applies.
;**   port_in: The port where sound is to come in.  If the number is 0-3
;**      then the Voice Master II ports 22f, 24f, 28f, or 2cf are used
;**      respectively.  Otherwise the value is considered to be the
;**      actual port address.
;**      In the Tandy version of this library, the port variable is
;**      ignored.  For calling compatibility, the parameter is still
;**      passed.
;**             Added Jan 90: If port number between 4-6 then external Covox
;**             digitizer is used.
;**
;**     Uses:
;**             es:di   Pointer into destination buffer
;**
;**************************************************************************

record8      PROC \
      USES SI DI ES DS, \
      stk_start:FAR PTR BYTE, \
      stk_size:DWORD, \
      rate_in:BYTE, \
      stk_port_in:WORD, \
      bytesRecorded : PTR DWORD 

      mov    ax, @data
      mov    ds, ax

      xor    ah, ah
      mov    al, rate_in
      mov    stk_rate, ax

      setup_record 08h                 ; macro to setup all record pointers and load header

      c_call recordByteInit,<stk_port_in,stk_rate,0>

      or     ax, ax                    ; see if port present
      jnz    @F                        ; jump if a non-zero port

      mov    ax, _ERROR_PORT_INIT_FAILED
      jmp    ret_point                 ; return an error if no port
@@:
pack8_loop:
      cmp    dsize_lsw, 1              ; make sure at least 1 byte in 
      jae    @F                        ; destination buffer
      cmp    dsize_msw, 0
      jne    @F

j8_done_no_room:
      jmp    done                      ; jump if no space left

@@:
      c_call recordByte                ; uses routine to get one byte, dx,ax used

done2_getting:
      sub    dsize_lsw, 1    
      sbb    dsize_msw, 0
      mov    BYTE PTR es:[di], al
      inc    di
      cmp    di, 08000h
      jb     @F
      add    di, 08000h
      mov    cx, es
      add    cx, 0800h
      mov    es, cx

@@: 
      key_pressed                      ; macro to test for key press
      jnz    done
      jmp    pack8_loop                ; get next source bytes

ret_error_no_uninit:
      jmp    SHORT ret_point

done:
      les    ax, stk_size              ; calculate number of bytes
      mov    dx, es                    ; used and filed by finding
      sub    ax, dsize_lsw             ; the difference between what
      sbb    dx, dsize_msw             ; was left and the size of the
      dec    ax                        ; readjust for zero adjust at begining
      sbb    dx, 0

   IFDEF Smodel
      mov    bx, bytesRecorded
      mov    [bx], ax
      mov    [bx+2], dx
   ENDIF

   IFDEF Mmodel
      mov    bx, bytesRecorded
      mov    [bx], ax
      mov    [bx+2], dx
   ENDIF

   IFDEF Cmodel
      les    bx, bytesRecorded
      mov    es:[bx], ax
      mov    es:[bx+2], dx
   ENDIF

   IFDEF Lmodel
      les    bx, bytesRecorded
      mov    es:[bx], ax
      mov    es:[bx+2], dx
   ENDIF


      c_call recordByteUninit          ; routine to stop recording

      mov    ax, _ERROR_NONE

ret_point:
      ret

record8      ENDP

      END

