/****************************************************************************

  File                  : fmmode.c	
  Date                  : 3-18-91	
  Description           : Set mode function for Yamaha chip
				

  Progammer(s)          : Don Fowler, Lance Williams
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

/****************************************************************************

	Function	 : BYTE fmMode( BYTE Mode )

	Parameters: BYTE Mode( Perucussive or Melodic ) 
					exp. Mode is actual bit value for registers.

	Actions	 :	 1.) Check for melodic or percussive mode
							a. Melodic
								i.) Set the global parameters for mode to melodic
								ii.) Set the chip for melodic mode
								iii.) Set voices 6-10 for piano.

							b. Percussive
								i.) Set the global parameters for mode to percussive
								ii.) Set the chip for percussive mode
								iii.)	 Set a7, a8, b7, and b8 to their respective noixe
										 values.	

					2.) Clear all of the percussion and melodic on bits
					3.) Clear all of the instrument set for voice flags. 

*****************************************************************************/

WORD fmSetMode( BYTE Mode )
{
	// Generic counter 
	WORD 	Counter_i;

	// Check to see if the system is initialized
	if( !_fmGlobalParameters.systemInitialized )
		return( _ERROR_SYSTEM_NOT_INITIALIZED );
	  
	// Clear all of the melodic on bits
	for( Counter_i = 0; Counter_i < _MEL_VOICES; Counter_i++ )
	{
		// Set the global parameters
		_fmKONBLOCKReg[ Counter_i ] = _FALSE; 

		// Clear the kon bits only
		fmSetRegister( ( _KON_FNUM_H + Counter_i ), _fmKONBLOCKReg[ Counter_i ] );
	}

	// Clear all of the instrument set for voice flags
	for( Counter_i = 0; Counter_i < _VOICES; Counter_i++ )
	{
		// Set the flag to false for each instruments
		_fmInstrumentSet[ Counter_i ] = _FALSE;
	}

	// Check for melodic mode otherwise default to percussive
	if( Mode == _MELODIC )
	{
		// Set the global parameter variable for mode
		_fmGlobalParameters.mode = _MELODIC;

		// And off the percussion bits in the global registers for percussion
		_fmPercussionRegister &= _PERC_CLEAR;

		// Write	out the value to the percussion register
		fmSetRegister( _PERC, _fmPercussionRegister );
	}
	else 
	{
		// Set the global parameter variable for mode
		_fmGlobalParameters.mode = _PERCUSSIVE;

		// Or on bit 5 in the percussion register
		_fmPercussionRegister |= _PERCUSSIVE;

		// Write out the value to the percussion register
		fmSetRegister( _PERC, _fmPercussionRegister );

		// Set the noise values in a7, a8, b7, and b8
		fmSetRegister( ( _FNUM_L + 7 ), 0xae );  
		fmSetRegister( ( _FNUM_L + 8 ), 0x02 );  
		fmSetRegister( ( _KON_FNUM_H + 7 ), 0x07 );  
		fmSetRegister( ( _KON_FNUM_H + 8 ), 0x07 );  
	}											 

   // Return a no errors flag
	return( _ERROR_NONE ); 
}

