/****************************************************************************

  File                  : fmfreq.c	
  Date                  : 3-18-91	
  Description           : Set frequency function 
				

  Progammer(s)          : Don Fowler, Lance Williams
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

/****************************************************************************

	Function	 : BYTE fmSetFrequency( BYTE Voice,	WORD Frequency )

	Parameters: Voice, Frequency
					a. Voice - Voice to change
					b. Frequency  Block, F-numh, F-numl

	Actions	 :	 1.) Check for system initialized
					 2.) Check for note on for voice and set the kon bit accordingly

*****************************************************************************/

WORD fmSetFrequency( BYTE Voice, WORD Frequency )
{
	// Check for system initialized
	if(  !_fmGlobalParameters.systemInitialized  )
		return(  _ERROR_SYSTEM_NOT_INITIALIZED  );

	// Set the fnum-low for the voice
	_fmFNUMReg[ Voice ] = ( BYTE )Frequency;

   // Setup to turn the note on
	_fmKONBLOCKReg	[ Voice ] = ( BYTE )( Frequency >> 8 ) | _KON; 

	// Set the registers for the rate and kon and block information
	fmSetRegister( ( _FNUM_L + Voice ), _fmFNUMReg[ Voice ] ); 
	fmSetRegister( ( _KON_FNUM_H + Voice ), _fmKONBLOCKReg[ Voice ] );

	return( _ERROR_NONE );
}

