//*****************************************************************************
//  File              : CVXBRLND.H
//  Date              : January 10, 1992
//  Description       : Redefinition of Borland C interface functions.
//
//  Last update       : March 11, 1992
//  Additional Notes  : The following defines are used to bridge the differences
//                      between those Microsoft C 6.0 and Borland C 2.0 
//                      functions which are analogous but use different function
//                      names.
//*****************************************************************************
//             Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          
//*****************************************************************************

#ifndef  _CVXBRLND_DEFINED
#define  _CVXBRLND_DEFINED

#include "cvxdefs.h"

#define  __MSC  1          // For Borland C 2.0 

// Borland re-definitions necessary for the libraries.
//
#define _dos_setvect(vect, func)         setvect(vect, func)
#define _dos_getvect(vect)               getvect(vect)
#define _enable                          enable
#define _disable                         disable
#define _chain_intr(intr)                (*intr)()
                                            
#define _asm                             asm
                                            
//#define outp( port,val )               outportb( port,val )
//#define inp( port )                    inportb( port )
                     

// Supplies file attribute information for the Microsoft functions
// _dos_findfirst, _dos_findnext.
// Equivalent to ffblk structure in Borland C 2.0
struct find_t {
    char     reserved[21];
    char     attrib;
    unsigned wr_time;
    unsigned wr_date;
    long     size;
    char     name[13];
};

#define _A_NORMAL       0x00
#define _A_RDONLY       0x01 
#define _A_HIDDEN       0x02 
#define _A_SYSTEM       0x04 
#define _A_VOLID        0x08 
#define _A_SUBDIR       0x10 
#define _A_ARCH         0x20 

#define _dos_findfirst(path,attrib,fileinfo) \
        (unsigned)findfirst(path,(struct ffblk _FAR *)fileinfo,attrib)

#define _dos_findnext(fileinfo) \
        (unsigned)findnext((struct ffblk *)fileinfo)


#endif
//*****************************************************************************
// end         CVXBRLND.H
//*****************************************************************************
