// I1AREC.C
// This program records _BUFFER_SIZE bytes and writes the
// data to to _FILE_NAME.
// 
// NOTE : Before this program can be executed, INT1ATSR.EXE
//        must be loaded into memory.
//
#include <dos.h>
#include <fcntl.h>
#include <errno.h>
#include "cvxutil.h"

#define  _FILE_NAME    "TEST1.V8" // New sound file.
#define  _BUFFER_SIZE  0x8000     // Bytes to record.

BYTE     buffer[_BUFFER_SIZE];    // Buffer to store
                                  // recorded data.
VOID main( VOID )
{
   WORD   fileHandle;
   LONG   bytesWritten;
   BYTE   carryFlag;

   // Prompt user to hit a key to begin recording.
   printf( "Hit any key to begin recording\n" );
      
   // Wait for keystroke.
   while( !kbhit() );

   // Clear keystroke(s) from keyboard buffer.
   while( kbhit() )
      getch();
      
   // Notify user that recording has begun.
   printf( "Recording ..." );

   do
   {
      _asm   mov   bx, SEG buffer    // Load ES:BX with 
      _asm   mov   es, bx            // segment and offset
      _asm   mov   bx, OFFSET buffer // of buffer.

      _asm   mov   cx, _BUFFER_SIZE  // Set buffer length.
   
      _asm   mov   dx, 9622          // Set sample rate.
   
      _asm   mov   ah, 82h           // Output sound.
      _asm   int   1Ah               //       
                                     
      _asm   lahf                    // Get carry flag state.
      _asm   and   ah, 1             // If CF = 1 we need to
      _asm   mov   carryFlag, ah     // try request again.
                                     
   }while( carryFlag );              

   // Loop here until all output is completed.
   do
   {
      _asm   mov   ah, 81h           // Check sound status.
      _asm   int   1Ah

      _asm   lahf                    // Get carry flag state.
      _asm   and   ah, 1             //
      _asm   mov   carryFlag, ah     //

   }while( carryFlag );
  
   // Uninitialize the sound i/o facility.
   //
   _asm   mov   ah, 84h
   _asm   int   1Ah

   // Create new file for recorded data.
   if( cvxFileCreate( _FILE_NAME, _CREATE_NORMAL, &fileHandle) )
   {
      printf( "ERROR : Cannot create file.\n" );
      printf( "        Sound data lost.\n" );
   }

   // Write recorded data to file.
   if( cvxFileWrite( fileHandle, (LPVOID)buffer,
                     ( LONG )_BUFFER_SIZE, &bytesWritten) )
   {
      printf( "ERROR : Cannot write to file.\n" );
      printf( "        Sound data lost.\n" );
   }

   // Close new file.
   cvxFileClose( fileHandle );

   // Notify user that recording has completed.
   printf( " complete.\n" );
                        
}



