// BYTE_IO.C
// This program initializes the non-DMA recording and playback 
// system. A byte is input and immediately output through the
// Voice Master default port.

#include <bios.h>
#include <stdio.h>
#include "cvxdigi.h"

#define _TREBLE_FLAG      _FALSE

VOID main( VOID )
{
   BYTE aByte;
   BOOL disableTimerFlag    = _FALSE;
   WORD physPort;
   
   // Initialize recording system.
   physPort = recordByteInit( _CVX_VM0, _CVX_RATE_DEFAULT, 
                              disableTimerFlag );

   // Initialize playback system.
   physPort = playByteInit( _CVX_VM0, _CVX_RATE_DEFAULT, disableTimerFlag,
                            _TREBLE_FLAG );

   // If a physical port value was returned then record and 
   // playback a byte at a time.
   if( physPort )
   {
      // Wait for key hit to exit.
      while( !kbhit() )
      { 
         // Input one byte from physPort.
         aByte = recordByte();

         // Output one byte to physPort.
         playByte( aByte );
      }

      // Clear keystroke(s) from keyboard buffer.
      while( kbhit() )
         getch();

      // Uninitialize the playback system.
      playByteUninit();

      // Uninitialize the recording system.
      recordByteUninit();
   }
   else
   {
      printf( "ERROR : I/O port initialization failed.\n" );
   }
}




